/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bradesco;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoOauthDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.CertificadoBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.EmissaoBoletoBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.EmissaoBoletoBradescoHibridoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.GerarQrCodePixBradescoRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.QrCodePixBradescoErroResponseDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.bradesco.BradescoAutenticacaoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.dentrassi.crypto.pem.PemKeyStoreProvider;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoBradescoService
implements IntegracaoBoletoRegistrado,
IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoBradescoService.class);
    private static final String STATUS_SUCESSO = "0";
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;
    private final ParametroPixRepository parametroPixRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private String request = null;
    private static Map<String, String> converterValues = new HashMap();
    private final BradescoAutenticacaoService bradescoAutenticacaoService;
    private static final String URL_API_COBRANCA = "%s/boleto-hibrido/cobranca-registro/v1/gerarBoleto";
    private static final String URL_API_PIX = "%s/v2/cobv-emv/%s";

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_BRADESCO)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o Bradesco!"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        CodigoBarrasDTO codigoBarrasDTO;
        if (Boolean.TRUE.equals(boleto.getModeloBloqueto().getConvenio().getUtilizaPix())) {
            return this.generateBoletoHibrido(boleto, parametroCNAB240);
        }
        String stackTraceIntegracao = null;
        JsonNode responseFinal = null;
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
        byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoBradesco).orElse(null);
        String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoBradesco).orElse(null);
        try {
            this.validarModeloBoletoEntidadeRegistro(boleto);
            EmissaoBoletoBradescoDTO dto = EmissaoBoletoBradescoDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            KeyStore keyStore = this.loadKeystore(certificado, senhaCertificado);
            CMSSignedDataGenerator signatureGenerator = this.setUpSigner(keyStore, senhaCertificado);
            log.debug("JSON  Boleto registrado Bradesco  ID - {} {}", (Object)boleto.getId(), (Object)this.mapper.writeValueAsString((Object)dto));
            byte[] signedBytes = this.signPkcs7(this.mapper.writeValueAsBytes((Object)dto), signatureGenerator);
            String signedbase64 = new String(Base64.getEncoder().encode(signedBytes));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)signedbase64, (MultiValueMap)headers);
            this.request = String.format("POST TO %s: %s", this.bradescoAutenticacaoService.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_URLAPI), this.mapper.writeValueAsString((Object)requestEntity));
            JsonNode response = (JsonNode)this.restTemplate.exchange(this.bradescoAutenticacaoService.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_URLAPI), HttpMethod.POST, requestEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("Body") || !response.get("Body").has("registrarTituloResponse") || !response.get("Body").get("registrarTituloResponse").has("return")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "Erro de comunica\u00e7\u00e3o com o Bradesco");
            }
            responseFinal = (JsonNode)this.mapper.readValue(response.get("Body").get("registrarTituloResponse").get("return").asText(), JsonNode.class);
            if (!STATUS_SUCESSO.equals(responseFinal.get("cdErro").asText())) {
                throw new RestException(HttpStatus.BAD_REQUEST, responseFinal.toString());
            }
            codigoBarrasDTO = this.builderCodigoBarras(boleto, responseFinal.get("linhaDigitavel").asText(), responseFinal.get("cdBarras").asText());
        }
        catch (RestException e) {
            try {
                JsonNode responseError = this.converterErroResposta(e.getMessage());
                String mensagem = e.getMessage();
                String codigo = null;
                if (Objects.nonNull(responseError) && responseError.has("msgErro") && StringUtils.isNotEmpty((String)responseError.get("msgErro").asText())) {
                    mensagem = responseError.get("msgErro").asText();
                    codigo = responseError.get("cdErro").asText();
                }
                stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e);
                throw new BoletoException("Erro ao enviar o boleto registrado para o Bradesco: " + codigo + " - " + mensagem);
                catch (ParametroNaoEncontradoException e2) {
                    stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e2);
                    throw e2;
                }
                catch (Exception e3) {
                    stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e3);
                    throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.saveErroBoletoOnline(boleto, stackTraceIntegracao, responseFinal);
                throw throwable;
            }
        }
        this.saveErroBoletoOnline(boleto, stackTraceIntegracao, responseFinal);
        return codigoBarrasDTO;
    }

    public CodigoBarrasDTO generateBoletoHibrido(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        this.validarModeloBoletoEntidadeRegistro(boleto);
        Optional.ofNullable(parametroCNAB240).orElseThrow(() -> new EloValidationException("Necess\u00e1rio configurar TRIBPARAMETROCNAB240 para o Bradesco"));
        HttpEntity request = null;
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_BOLETO_COM_PIX);
        try {
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
            CertificadoBradescoDTO certificadoBradescoDTO = this.bradescoAutenticacaoService.getCertificado(boleto.getModeloBloqueto().getConvenio().getEntidade());
            String urlApiCobranca = String.format(URL_API_COBRANCA, this.bradescoAutenticacaoService.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_OAUTH_URL));
            BradescoOauthDTO oAauth = this.bradescoAutenticacaoService.getOauthBradesco(this.bradescoAutenticacaoService.urlOauthApiCobranca(), ParametroGeralEnum.BOLETO_BRADESCO_CLIENTID, ParametroGeralEnum.BOLETO_BRADESCO_CLIENTSECRET, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            HttpHeaders headers = this.bradescoAutenticacaoService.criarHeaders(oAauth, certificadoBradescoDTO, integracaoBoletoPixLog);
            EmissaoBoletoBradescoHibridoDTO dto = EmissaoBoletoBradescoHibridoDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(urlApiCobranca);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            JsonNode bradescoHibridoResponse = (JsonNode)this.bradescoAutenticacaoService.getRestTemplate(certificadoBradescoDTO.getArquivoCertificado(), certificadoBradescoDTO.getSenhaCertificado(), certificadoBradescoDTO.getNomeArquivo()).exchange(urlApiCobranca, HttpMethod.POST, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)bradescoHibridoResponse));
            String linhaDigitavel = "";
            String codigoBarras = "";
            if (bradescoHibridoResponse != null) {
                JsonNode responseLinhaDigitavel = bradescoHibridoResponse.path("linhaDig10");
                JsonNode responseCodigoBarras = bradescoHibridoResponse.path("codBarras10");
                JsonNode responseTxId = bradescoHibridoResponse.path("iconcPgtoSpi");
                JsonNode responseQrCodeEmv = bradescoHibridoResponse.path("wqrcdPdraoMercd");
                if (!responseQrCodeEmv.isMissingNode() && !StringUtils.isEmpty((String)responseQrCodeEmv.asText())) {
                    boleto.setTextoQrCode(responseQrCodeEmv.asText());
                }
                if (!responseTxId.isMissingNode() && !StringUtils.isEmpty((String)responseTxId.asText())) {
                    boleto.setTxidPix(responseTxId.asText());
                    integracaoBoletoPixLog.setTxid(responseTxId.asText());
                }
                if (!responseLinhaDigitavel.isMissingNode() && !StringUtils.isEmpty((String)responseLinhaDigitavel.asText())) {
                    linhaDigitavel = responseLinhaDigitavel.asText();
                }
                if (!responseCodigoBarras.isMissingNode() && !StringUtils.isEmpty((String)responseCodigoBarras.asText())) {
                    codigoBarras = responseCodigoBarras.asText();
                }
            }
            CodigoBarrasDTO codigoBarrasDTO = this.builderCodigoBarras(boleto, linhaDigitavel, codigoBarras);
            return codigoBarrasDTO;
        }
        catch (RestException e) {
            JsonNode responseError = this.converterErroResposta(e.getMessage());
            String mensagem = e.getMessage();
            mensagem = this.getMensagemErro(responseError, mensagem, integracaoBoletoPixLog);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel executar a requisi\u00e7\u00e3o na API do Bradesco para registrar o boleto com QRCODE: " + mensagem, (Throwable)e);
        }
        catch (EloValidationException e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new EloValidationException("Erro ao tratar o retorno do Boleto com QRCODE do bradesco: " + e.getMessage());
        }
        catch (Exception e) {
            JsonNode responseError = this.converterErroResposta(e.getMessage());
            String mensagem = e.getMessage();
            this.getMensagemErro(responseError, mensagem, integracaoBoletoPixLog);
            throw new EloValidationException("Erro ao enviar o boleto registrado com QRCODE para o Bradesco: " + e.getMessage());
        }
        finally {
            this.bradescoAutenticacaoService.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_BRADESCO_CNAB240_COM_REGISTRO;
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        String nossoNumero = this.gerarNossoNumero(boleto);
        String dv = this.gerarDVNossoNumero(boleto.getModeloBloqueto().getConvenio().getCarteira(), nossoNumero);
        boleto.setNossoNumero(nossoNumero + dv);
        boleto.setDvNossoNumero(dv);
    }

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto boleto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            Validate.notNull((Object)boleto);
            String txid = boleto.generateTxIdPix();
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            CertificadoBradescoDTO certificadoBradescoDTO = this.bradescoAutenticacaoService.getCertificado(boleto.getModeloBloqueto().getConvenio().getEntidade());
            BradescoOauthDTO oAauth = this.bradescoAutenticacaoService.getOauthBradesco(this.bradescoAutenticacaoService.urlOauthApiPix(), ParametroGeralEnum.PIX_BRADESCO_CLIENTID, ParametroGeralEnum.PIX_BRADESCO_CLIENTSECRET, IntegracaoTokenOperation.PIX);
            HttpHeaders headers = this.bradescoAutenticacaoService.criarHeaders(oAauth, certificadoBradescoDTO, integracaoBoletoPixLog);
            GerarQrCodePixBradescoRequestDTO dto = GerarQrCodePixBradescoRequestDTO.from((Bloqueto)boleto);
            String urlApiPix = String.format(URL_API_PIX, this.bradescoAutenticacaoService.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_API_PIX_URL), txid);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(urlApiPix);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.PUT);
            JsonNode response = (JsonNode)this.bradescoAutenticacaoService.getRestTemplate(certificadoBradescoDTO.getArquivoCertificado(), certificadoBradescoDTO.getSenhaCertificado(), certificadoBradescoDTO.getNomeArquivo()).exchange(urlApiPix, HttpMethod.PUT, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            if (response != null) {
                JsonNode responseEmvNode = response.path("emv");
                JsonNode responseTxId = response.path("cobv").path("txid");
                if (!responseEmvNode.isMissingNode() && !StringUtils.isEmpty((String)responseEmvNode.asText())) {
                    resultDto.setTextoQrCode(responseEmvNode.asText());
                }
                if (!responseTxId.isMissingNode() && !StringUtils.isEmpty((String)responseTxId.asText())) {
                    resultDto.setTxid(responseTxId.asText());
                }
            }
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            QrCodePixBradescoErroResponseDTO dtoErros = (QrCodePixBradescoErroResponseDTO)this.bradescoAutenticacaoService.converteErroResposta(e.getMessage(), QrCodePixBradescoErroResponseDTO.class);
            if (Objects.nonNull(dtoErros)) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setJsonResponse("");
            integracaoBoletoPixLog.setDescricaoErro("Status " + String.valueOf(e.getStatus()) + " " + e.getMessage());
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.bradescoAutenticacaoService.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_BRADESCO;
    }

    public CodigoBarrasDTO builderCodigoBarras(Bloqueto boleto, String linhaDigitavel, String codigoBarras) {
        if (StringUtils.isEmpty((String)linhaDigitavel)) {
            throw new EloValidationException("Erro preencher os campos do C\u00f3digo de Barras : Campo linha digit\u00e1vel esta sem valores.");
        }
        if (StringUtils.isEmpty((String)codigoBarras)) {
            throw new EloValidationException("Erro preencher os campos do C\u00f3digo de Barras : C\u00f3digo de barras esta sem valores.");
        }
        CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
        try {
            linhaDigitavel = StringUtils.deleteWhitespace((String)linhaDigitavel.replace(".", ""));
            codigoBarrasDTO.setLinhaDigitavel(linhaDigitavel);
            codigoBarrasDTO.setCampo1(StringUtils.substring((String)linhaDigitavel, (int)0, (int)10));
            codigoBarrasDTO.setCampo2(StringUtils.substring((String)linhaDigitavel, (int)10, (int)21));
            codigoBarrasDTO.setCampo3(StringUtils.substring((String)linhaDigitavel, (int)21, (int)32));
            codigoBarrasDTO.setCampo4(StringUtils.substring((String)linhaDigitavel, (int)32, (int)33));
            codigoBarrasDTO.setCampo5(StringUtils.substring((String)linhaDigitavel, (int)33, (int)47));
            codigoBarrasDTO.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO.setDvNossoNumero(boleto.getDvNossoNumero());
        }
        catch (Exception e) {
            throw new EloValidationException("Erro preencher os campos do C\u00f3digo de Barras: " + e.getMessage());
        }
        try {
            String codBarrasNumerico = this.converteCodigoBarrasBradesco(codigoBarras);
            codigoBarrasDTO.setCodigoBarras(StringUtils.left((String)codBarrasNumerico, (int)100));
            codigoBarrasDTO.generateCodigoBarrasFormatadoIntervalo2Of5();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro gerar o c\u00f3digo de barras formatado: " + e.getMessage());
        }
        return codigoBarrasDTO;
    }

    public void validarModeloBoletoEntidadeRegistro(Bloqueto boleto) {
        Convenio convenio = Optional.ofNullable(boleto).map(Bloqueto::getModeloBloqueto).map(ModeloBoleto::getConvenio).orElseThrow(() -> new EloValidationException("N\u00e3o existe um conv\u00eanio vinculado ao modelo de bloqueto!"));
        Optional.ofNullable(convenio.getEntidadeRegistro()).orElseThrow(() -> new EloValidationException(String.format("Necess\u00e1rio vincular a entidade para registro do boleto ao conv\u00eanio %s!", convenio.getNumeroConvenio())));
    }

    public String getMensagemErro(JsonNode responseError, String mensagem, IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        if (Objects.nonNull(responseError) && responseError.has("mensagem") && StringUtils.isNotEmpty((String)responseError.get("mensagem").asText())) {
            mensagem = responseError.get("mensagem").asText();
        }
        integracaoBoletoPixLog.setJsonResponse(responseError.toString());
        integracaoBoletoPixLog.setDescricaoErro(mensagem);
        return mensagem;
    }

    public String converteCodigoBarrasBradesco(String codigo) {
        String codigoFormat = codigo.replaceAll("[<>]*", "");
        return Stream.of(codigoFormat.split("(?<=\\G.{5})")).map(slice -> {
            String valor = (String)converterValues.get(slice);
            if (Objects.isNull(valor)) {
                throw new EloValidationException(String.format("O campo '%s' n\u00e3o p\u00f4de ser convertido para c\u00f3digo de barras, valor equivalente n\u00e3o encontrado", slice));
            }
            return valor;
        }).collect(Collectors.joining());
    }

    public void saveErroBoletoOnline(Bloqueto boleto, String stackTrace, JsonNode response) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            ErroBoletoRegistroOnline erroBoletoRegistroOnline = new ErroBoletoRegistroOnline();
            erroBoletoRegistroOnline.setRequest((byte[])Optional.ofNullable(this.request).map(String::getBytes).orElse(null));
            erroBoletoRegistroOnline.setResponse((byte[])Optional.ofNullable(response).map(JsonNode::toString).map(String::getBytes).orElse(null));
            erroBoletoRegistroOnline.setDataHoraIntegracao(LocalDateTime.now());
            erroBoletoRegistroOnline.setIdBoleto(boleto.getId());
            erroBoletoRegistroOnline.setDetalhes(stackTrace);
            return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroBoletoRegistroOnline);
        });
    }

    public String gerarNossoNumero(Bloqueto boleto) {
        Long numeroBoleto = Optional.ofNullable(boleto.getBloqueto()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado"));
        Long exercicioBoleto = Optional.ofNullable(boleto.getExercicioBloqueto()).orElseThrow(() -> new EloValidationException("Exercicio do Boleto n\u00e3o encontrado"));
        String anoIdentificador = exercicioBoleto.toString().substring(2, 4).concat(StringUtils.leftPad((String)numeroBoleto.toString(), (int)8, (String)STATUS_SUCESSO));
        return boleto.getEntidade().toString().concat(anoIdentificador);
    }

    public String gerarDVNossoNumero(String carteira, String nossoNumero) {
        if (StringUtils.isBlank((String)carteira)) {
            throw new EloValidationException("Necess\u00e1rio informar a carteira para o c\u00e1lculo do digito verificador");
        }
        if (StringUtils.isBlank((String)nossoNumero)) {
            throw new EloValidationException("Nosso N\u00famero n\u00e3o pode ser nullo para o c\u00e1lculo do digito verificador");
        }
        String vsNossoNumero = StringUtils.leftPad((String)carteira, (int)2, (String)STATUS_SUCESSO).concat(nossoNumero);
        Integer valorMultiplicador = 2;
        Integer viSoma = 0;
        for (int i = 0; i < vsNossoNumero.length(); ++i) {
            viSoma = viSoma + Character.getNumericValue(vsNossoNumero.charAt(i)) * valorMultiplicador;
            if (valorMultiplicador.equals(2)) {
                valorMultiplicador = 7;
                continue;
            }
            Integer n = valorMultiplicador;
            valorMultiplicador = valorMultiplicador - 1;
        }
        Integer viResto = viSoma % 11;
        return switch (viResto) {
            case 0 -> STATUS_SUCESSO;
            case 1 -> "P";
            default -> String.valueOf(11 - viResto);
        };
    }

    public JsonNode converterErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            ObjectNode jsonNodes = JsonNodeFactory.instance.objectNode();
            jsonNodes.put("msgErro", "Erro ao converter a exce\u00e7\u00e3o no objeto da integra\u00e7\u00e3o do boleto bradesco.");
            jsonNodes.put("cdErro", "");
            return jsonNodes;
        }
    }

    public byte[] signPkcs7(byte[] content, CMSSignedDataGenerator generator) throws Exception {
        CMSProcessableByteArray cmsdata = new CMSProcessableByteArray(content);
        CMSSignedData signedData = generator.generate((CMSTypedData)cmsdata, true);
        return signedData.getEncoded();
    }

    public KeyStore loadKeystore(byte[] certificado, String senha) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PEM", (Provider)new PemKeyStoreProvider());
        ByteArrayInputStream is = new ByteArrayInputStream(certificado);
        keyStore.load(is, senha.toCharArray());
        return keyStore;
    }

    public CMSSignedDataGenerator setUpSigner(KeyStore keystore, String senhaCertificado) throws Exception {
        int length;
        Security.addProvider((Provider)new BouncyCastleProvider());
        String SIGNATUREALGO = "Sha256WithRSA";
        Enumeration<String> aliases = keystore.aliases();
        String aliaz = "";
        while (aliases.hasMoreElements() && !keystore.isKeyEntry(aliaz = aliases.nextElement())) {
        }
        Certificate[] certChain = keystore.getCertificateChain(aliaz);
        ArrayList<Certificate> certList = new ArrayList<Certificate>();
        int n = length = certChain == null ? 0 : certChain.length;
        for (int i = 0; i < length; ++i) {
            certList.add(certChain[i]);
        }
        JcaCertStore certstore = new JcaCertStore(certList);
        Certificate cert = keystore.getCertificate(aliaz);
        ContentSigner signer = new JcaContentSignerBuilder("Sha256WithRSA").setProvider("BC").build((PrivateKey)keystore.getKey(aliaz, senhaCertificado.toCharArray()));
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(signer, (X509Certificate)cert));
        generator.addCertificates((Store)certstore);
        return generator;
    }

    @Generated
    public IntegracaoBoletoBradescoService(RestTemplate restTemplate, ObjectMapper mapper, ParametroPixRepository parametroPixRepository, PlatformTransactionManager transactionManager, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, BradescoAutenticacaoService bradescoAutenticacaoService) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
        this.parametroPixRepository = parametroPixRepository;
        this.transactionManager = transactionManager;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.bradescoAutenticacaoService = bradescoAutenticacaoService;
    }

    static {
        converterValues.put("nnWWn", "00");
        converterValues.put("NnwwN", "01");
        converterValues.put("nNwwN", "02");
        converterValues.put("NNwwn", "03");
        converterValues.put("nnWwN", "04");
        converterValues.put("NnWwn", "05");
        converterValues.put("nNWwn", "06");
        converterValues.put("nnwWN", "07");
        converterValues.put("NnwWn", "08");
        converterValues.put("nNwWn", "09");
        converterValues.put("wnNNw", "10");
        converterValues.put("WnnnW", "11");
        converterValues.put("wNnnW", "12");
        converterValues.put("WNnnw", "13");
        converterValues.put("wnNnW", "14");
        converterValues.put("WnNnw", "15");
        converterValues.put("wNNnw", "16");
        converterValues.put("wnnNW", "17");
        converterValues.put("WnnNw", "18");
        converterValues.put("wNnNw", "19");
        converterValues.put("nwNNw", "20");
        converterValues.put("NwnnW", "21");
        converterValues.put("nWnnW", "22");
        converterValues.put("NWnnw", "23");
        converterValues.put("nwNnW", "24");
        converterValues.put("NwNnw", "25");
        converterValues.put("nWNnw", "26");
        converterValues.put("nwnNW", "27");
        converterValues.put("NwnNw", "28");
        converterValues.put("nWnNw", "29");
        converterValues.put("wwNNn", "30");
        converterValues.put("WwnnN", "31");
        converterValues.put("wWnnN", "32");
        converterValues.put("WWnnn", "33");
        converterValues.put("wwNnN", "34");
        converterValues.put("WwNnn", "35");
        converterValues.put("wWNnn", "36");
        converterValues.put("wwnNN", "37");
        converterValues.put("WwnNn", "38");
        converterValues.put("wWnNn", "39");
        converterValues.put("nnWNw", "40");
        converterValues.put("NnwnW", "41");
        converterValues.put("nNwnW", "42");
        converterValues.put("NNwnw", "43");
        converterValues.put("nnWnW", "44");
        converterValues.put("NnWnw", "45");
        converterValues.put("nNWnw", "46");
        converterValues.put("nnwNW", "47");
        converterValues.put("NnwNw", "48");
        converterValues.put("nNwNw", "49");
        converterValues.put("wnWNn", "50");
        converterValues.put("WnwnN", "51");
        converterValues.put("wNwnN", "52");
        converterValues.put("WNwnn", "53");
        converterValues.put("wnWnN", "54");
        converterValues.put("WnWnn", "55");
        converterValues.put("wNWnn", "56");
        converterValues.put("wnwNN", "57");
        converterValues.put("WnwNn", "58");
        converterValues.put("wNwNn", "59");
        converterValues.put("nwWNn", "60");
        converterValues.put("NwwnN", "61");
        converterValues.put("nWwnN", "62");
        converterValues.put("NWwnn", "63");
        converterValues.put("nwWnN", "64");
        converterValues.put("NwWnn", "65");
        converterValues.put("nWWnn", "66");
        converterValues.put("nwwNN", "67");
        converterValues.put("NwwNn", "68");
        converterValues.put("nWwNn", "69");
        converterValues.put("nnNWw", "70");
        converterValues.put("NnnwW", "71");
        converterValues.put("nNnwW", "72");
        converterValues.put("NNnww", "73");
        converterValues.put("nnNwW", "74");
        converterValues.put("NnNww", "75");
        converterValues.put("nNNww", "76");
        converterValues.put("nnnWW", "77");
        converterValues.put("NnnWw", "78");
        converterValues.put("nNnWw", "79");
        converterValues.put("wnNWn", "80");
        converterValues.put("WnnwN", "81");
        converterValues.put("wNnwN", "82");
        converterValues.put("WNnwn", "83");
        converterValues.put("wnNwN", "84");
        converterValues.put("WnNwn", "85");
        converterValues.put("wNNwn", "86");
        converterValues.put("wnnWN", "87");
        converterValues.put("WnnWn", "88");
        converterValues.put("wNnWn", "89");
        converterValues.put("nwNWn", "90");
        converterValues.put("NwnwN", "91");
        converterValues.put("nWnwN", "92");
        converterValues.put("NWnwn", "93");
        converterValues.put("nwNwN", "94");
        converterValues.put("NwNwn", "95");
        converterValues.put("nWNwn", "96");
        converterValues.put("nwnWN", "97");
        converterValues.put("NwnWn", "98");
        converterValues.put("nWnWn", "99");
        converterValues.put("WWWWW", "99");
    }
}

