/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bradesco;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.integracaoboleto.DadosIntegracaoOauth;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoOauthDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoPixPagoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoPixPagoPaginacaoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoPixPagoResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.CertificadoBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.DadosWebHookBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.DocumentoBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.WebHookBradescoRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.WebHookErrosResponseBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.WebHookResponseBradescoDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoleto;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.service.integracaoboleto.bradesco.BradescoAutenticacaoService;
import br.com.elotech.tributos.service.integracaoboleto.bradesco.BradescoPixPagoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BradescoPixPagoService
extends IntegracaoBoleto
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BradescoPixPagoService.class);
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String URL_CADASTRO_WEBHOOK = "%s/boleto/cobranca-webhook/v1/cadastrar";
    private static final String URL_RECEBIMENTO_WEBHOOK = "%s/api/integracao-boleto/%d/webhook/pix";
    private static final String OAUTH_GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String OAUTH_CLIENT_SECRET = "client_secret";
    private static final String OAUTH_CLIENT_ID = "client_id";
    private static final String FILIAL_CNPJ_BENEFICIARIO = "0001";
    private static final String UTILIZA_WEBHOOK_SIM = "S";
    private static final String UTILIZA_WEBHOOK_NAO = "N";
    private static final String URL_API_PIX_CONSULTA = "/v2/pix";
    private static final String QUERY_PARAM_PAGINACAO_PAGINA_ATUAL = "paginacao.paginaAtual";
    private static final String QUERY_PARAM_PAGINACAO_ITENS_PAGINA = "paginacao.itensPorPagina";
    private static final String QUERY_PARAM_DATA_INICIO = "inicio";
    private static final String QUERY_PARAM_DATA_FIM = "fim";
    private static final DateTimeFormatter FORMATO_DATA_HORA_API = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH'%3A'mm'%3A'ss'Z'");
    private final ConfigurableEnvironment environment;
    private final ObjectMapper objectMapper;
    private final ContextService contextService;
    private final BloquetoService boletoService;
    private final DebitoParcelaService debitoParcelaService;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final TipoMensagemService tipoMensagemService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final BradescoAutenticacaoService bradescoAutenticacaoService;

    public BradescoPixPagoService(List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ConfigurableEnvironment environment, ObjectMapper objectMapper, ContextService contextService, BloquetoService boletoService, DebitoParcelaService debitoParcelaService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, TipoMensagemService tipoMensagemService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService, BradescoAutenticacaoService bradescoAutenticacaoService) {
        super(integracaoTokenServices, parametroGeralService, integracaoBoletoPixLogRepository, transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.contextService = contextService;
        this.boletoService = boletoService;
        this.debitoParcelaService = debitoParcelaService;
        this.transactionManager = transactionManager;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.bradescoAutenticacaoService = bradescoAutenticacaoService;
    }

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_BRADESCO.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog integracaoPixPagoLog = this.builderLog(convenio, dataReferencia);
        Long entidade = this.contextService.getEntidadePrincipal();
        ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
        try {
            BradescoPixPagoResponseDTO pixPagos = this.getPixPagos(dataReferencia, entidade);
            BradescoPixPagoPaginacaoDTO paginacao = pixPagos.getParametros().getPaginacao();
            integracaoPixPagoLog.setQuantidadeRegistros(paginacao.getQuantidadeTotalDeItens());
            if (paginacao.getQuantidadeTotalDeItens().equals(0)) {
                resultado.setPossuiRegistros(Boolean.FALSE);
                ImportacaoPixPagoResultadoDTO importacaoPixPagoResultadoDTO = resultado;
                return importacaoPixPagoResultadoDTO;
            }
            ArrayList itensGerados = new ArrayList();
            itensGerados.addAll(this.processarPixPagos(pixPagos.getPix(), integracaoPixPagoLog));
            if (paginacao.getQuantidadeDePaginas() > 1) {
                Integer totalPaginas = paginacao.getQuantidadeDePaginas();
                Integer pagina = 1;
                while (pagina < totalPaginas) {
                    BradescoPixPagoResponseDTO respostaPagina = this.getPixPagos(dataReferencia, pagina, entidade);
                    itensGerados.addAll(this.processarPixPagos(respostaPagina.getPix(), integracaoPixPagoLog));
                    Integer n = pagina;
                    pagina = pagina + 1;
                }
            }
            resultado.setPossuiRegistros(Boolean.valueOf(!itensGerados.isEmpty()));
            integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(itensGerados.size()));
            if (!itensGerados.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, resultado);
                resultado.setDadosLote(lote.getId());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(itensGerados, lote, sequencia);
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(integracaoPixPagoLog);
        }
        return resultado;
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog integracaoPixPagoLog) {
        log.debug("Dados Recebidos {}", (Object)pixPagos);
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_BRADESCO.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        List dadosWebHookBradescoDTO = DadosWebHookBradescoDTO.from((JsonNode)pixPagos);
        if (dadosWebHookBradescoDTO.isEmpty()) {
            integracaoPixPagoLog.setQuantidadeRegistros(Integer.valueOf(0));
            log.debug("Nao retornou pix para serem processados {}", (Object)pixPagos);
            return integracaoPixPagoLog;
        }
        LocalDate dataReferencia = this.getDataReferencia((DadosWebHookBradescoDTO)dadosWebHookBradescoDTO.get(0));
        integracaoPixPagoLog.setDataReferencia(dataReferencia);
        integracaoPixPagoLog.setQuantidadeRegistros(Integer.valueOf(dadosWebHookBradescoDTO.size()));
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processaLotePagamentoPix(convenio, integracaoPixPagoLog, dadosWebHookBradescoDTO, dataReferencia, this.contextService.getEntidadePrincipal());
        } else {
            this.processarPixPago(dadosWebHookBradescoDTO, integracaoPixPagoLog);
        }
        return integracaoPixPagoLog;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        CertificadoBradescoDTO certificadoBradescoDTO = this.bradescoAutenticacaoService.getCertificado(convenio.getEntidadeRegistro().getId());
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, certificadoBradescoDTO);
        } else {
            this.deactivePixWebhook(convenio, certificadoBradescoDTO);
        }
    }

    protected MultiValueMap<String, String> authBodyBuilder(DadosIntegracaoOauth dadosOauth) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)dadosOauth.getClientId());
        body.add((Object)"client_secret", (Object)dadosOauth.getClientSecret());
        return body;
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para solicitar arquivo de pagamento para o banco Bradesco n\u00e3o implementada.");
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long codigoSolicitacao) {
        throw new EloValidationException("Integra\u00e7\u00e3o para importar arquivo de pagamento para o banco Bradesco n\u00e3o implementada.");
    }

    public BradescoPixPagoResponseDTO getPixPagos(LocalDate data, Integer page, Long entidade) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_RECEBIDOS);
        CertificadoBradescoDTO certificadoBradescoDTO = this.bradescoAutenticacaoService.getCertificado(entidade);
        BradescoOauthDTO oauth = this.bradescoAutenticacaoService.getOauthBradesco(this.bradescoAutenticacaoService.urlOauthApiPix(), ParametroGeralEnum.PIX_BRADESCO_CONSULTA_CLIENTID, ParametroGeralEnum.PIX_BRADESCO_CONSULTA_CLIENTSECRET, IntegracaoTokenOperation.CONSULTA_PIX);
        HttpHeaders headers = this.bradescoAutenticacaoService.criarHeaders(oauth, certificadoBradescoDTO, integracaoBoletoPixLog);
        HttpEntity request = new HttpEntity(null, (MultiValueMap)headers);
        try {
            URI url = this.builderUrlPixPago(data, page);
            JsonNode body = (JsonNode)this.bradescoAutenticacaoService.getRestTemplate(certificadoBradescoDTO.getArquivoCertificado(), certificadoBradescoDTO.getSenhaCertificado(), certificadoBradescoDTO.getNomeArquivo()).exchange(url, HttpMethod.GET, request, JsonNode.class).getBody();
            integracaoBoletoPixLog.setJsonRequest(this.objectMapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(url.toString());
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.GET);
            log.debug("Buscando os pix pagos na url {}, com headers {}.", (Object)url, (Object)headers);
            log.debug("Retorno da requis\u00e7\u00e3o para buscar pix pagos : {} ", (Object)body);
            BradescoPixPagoResponseDTO bradescoPixPagoResponseDTO = (BradescoPixPagoResponseDTO)this.objectMapper.treeToValue((TreeNode)body, BradescoPixPagoResponseDTO.class);
            return bradescoPixPagoResponseDTO;
        }
        catch (JsonProcessingException e) {
            log.debug("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", (Throwable)e);
            throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", e);
        }
        catch (HttpStatusCodeException e) {
            log.debug(String.format("Erro ao recuperar a lista de pixPagos %s %s", e.getStatusCode(), e.getMessage()));
            integracaoBoletoPixLog.setDescricaoErro(String.format("%s %s", e.getStatusCode(), e.getMessage()));
            throw new RestException(e.getStatusCode(), String.format("%s: %s", e.getMessage(), e.getResponseBodyAsString()), (Throwable)e);
        }
        catch (RestException e) {
            log.debug("Exce\u00e7\u00e3o Rest . Erro ao recuperar a lista de pixPagos %s", (Throwable)e);
            integracaoBoletoPixLog.setDescricaoErro(String.format("%s %s", e.getStatus(), e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            log.debug("Exeception Erro ao recuperar a lista de pixPagos %s", (Throwable)e);
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Erro inesperado ao recuperar pix pagos", e.getMessage()), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public BradescoPixPagoResponseDTO getPixPagos(LocalDate data, Long entidade) {
        return this.getPixPagos(data, Integer.valueOf(0), entidade);
    }

    public void activatePixWebhook(Convenio convenio, CertificadoBradescoDTO dadosCertificadoDTO) {
        String urlWebHookRecebimento = String.format("%s/api/integracao-boleto/%d/webhook/pix", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId());
        this.requestPixWebHook(convenio, dadosCertificadoDTO, true, urlWebHookRecebimento, "Erro ao ativar webhook do Pix para o Bradesco");
    }

    public void deactivePixWebhook(Convenio convenio, CertificadoBradescoDTO dadosCertificadoDTO) {
        this.requestPixWebHook(convenio, dadosCertificadoDTO, false, null, "Erro ao desativar webhook do Pix para o Bradesco");
    }

    private void requestPixWebHook(Convenio convenio, CertificadoBradescoDTO dadosCertificadoDTO, boolean ativar, String urlWebHookRecebimento, String mensagemErro) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.WEBHOOK_PAGAMENTO);
        try {
            BradescoOauthDTO oauth = this.bradescoAutenticacaoService.getOauthBradesco(this.bradescoAutenticacaoService.urlOauthApiCobranca(), ParametroGeralEnum.WEBHOOK_COBRANCA_BRADESCO_CLIENTID, ParametroGeralEnum.WEBHOOK_COBRANCA_BRADESCO_CLIENTSECRET, IntegracaoTokenOperation.WEBHOOK);
            HttpHeaders headers = this.bradescoAutenticacaoService.criarHeaders(oauth, dadosCertificadoDTO, integracaoBoletoPixLog);
            String url = String.format("%s/boleto/cobranca-webhook/v1/cadastrar", this.bradescoAutenticacaoService.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_OAUTH_URL));
            DocumentoBradescoDTO documentoBradescoDTO = DocumentoBradescoDTO.builder().cpfCnpj(this.bradescoAutenticacaoService.cnpjRaiz(convenio.getEntidadeRegistro().getCnpj())).filial("0001").controle(this.bradescoAutenticacaoService.cnpjControle(convenio.getEntidadeRegistro().getCnpj())).build();
            WebHookBradescoRequestDTO dto = WebHookBradescoRequestDTO.from((DocumentoBradescoDTO)documentoBradescoDTO, (String)(ativar ? urlWebHookRecebimento : null), (String)(ativar ? "S" : "N"));
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.objectMapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            JsonNode jsonNode = (JsonNode)this.bradescoAutenticacaoService.getRestTemplate(dadosCertificadoDTO.getArquivoCertificado(), dadosCertificadoDTO.getSenhaCertificado(), dadosCertificadoDTO.getNomeArquivo()).exchange(url, HttpMethod.POST, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.objectMapper.writeValueAsString((Object)jsonNode));
            WebHookResponseBradescoDTO responseCadastroWebHook = (WebHookResponseBradescoDTO)this.objectMapper.treeToValue((TreeNode)jsonNode, WebHookResponseBradescoDTO.class);
            this.recuperarErrosWebhook(responseCadastroWebHook);
        }
        catch (HttpStatusCodeException e) {
            integracaoBoletoPixLog.setDescricaoErro(String.format("%s %s", e.getStatusCode(), e.getMessage()));
            throw new RestException(e.getStatusCode(), String.format("%s: %s", mensagemErro, e.getResponseBodyAsString()), (Throwable)e);
        }
        catch (RestException e) {
            integracaoBoletoPixLog.setDescricaoErro(String.format("%s %s", e.getStatus(), e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Erro inesperado ao %s webhook do Pix para o Bradesco: %s", ativar ? "ativar" : "desativar", e.getMessage()), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private void processaLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<DadosWebHookBradescoDTO> pixpago, LocalDate dataReferencia, Long entidade) {
        try {
            List baixaAutomaticaDetalhes = this.processarPixPagoLote(pixpago, log);
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO());
                AtomicLong sequence = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequence);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia));
    }

    public PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        pagamentoLote.setNomeArquivo(String.format("importacao_pix_%d_%s", convenio.getConvenio(), FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual)));
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    public void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    public List<BaixaAutomaticaDetalhe> processarPixPagoLote(List<DadosWebHookBradescoDTO> listPixPago, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return listPixPago.stream().map(pix -> this.processarBaixaDetalhe(pix, log, tipoMensagem)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<BaixaAutomaticaDetalhe> processarBaixaDetalhe(DadosWebHookBradescoDTO dadosWebHookBradesco, IntegracaoPixPagoLog log, TipoMensagem tipoMensagem) {
        IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
        log.getDetalhes().add(detalhe);
        try {
            return this.processarPagamento(dadosWebHookBradesco, detalhe, tipoMensagem);
        }
        catch (Exception ex) {
            return this.erroProcessamentoPix(detalhe, ex);
        }
    }

    public Optional<BaixaAutomaticaDetalhe> processarPagamento(DadosWebHookBradescoDTO dadosWebHookBradesco, IntegracaoPixPagoDetalhe detalhe, TipoMensagem tipoMensagem) {
        Optional bloquetoEvento = this.buscarBloquetoPorEvento(dadosWebHookBradesco, detalhe);
        if (bloquetoEvento.isEmpty()) {
            return Optional.empty();
        }
        Bloqueto bloqueto = (Bloqueto)bloquetoEvento.get();
        if (this.baixaAutomaticaDetalheService.existsByBoleto(bloqueto)) {
            detalhe.setObservacao(String.format("Boleto j\u00e1 importado. Boleto : %s", bloqueto.getBloqueto().toString()));
            return Optional.empty();
        }
        detalhe.setObservacao("Boleto importado com sucesso");
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = BradescoPixPagoService.builderBaixaAutomaticaDetalhe((DadosWebHookBradescoDTO)dadosWebHookBradesco, (Bloqueto)bloqueto, (TipoMensagem)tipoMensagem);
        return Optional.of(baixaAutomaticaDetalhe);
    }

    private void processarPixPago(List<DadosWebHookBradescoDTO> listPixPago, IntegracaoPixPagoLog log) {
        try {
            listPixPago.stream().map(pix -> this.processarPixPagoLote(pix, log)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> this.processarPagamentoParcelas(arg_0));
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private Optional<Bloqueto> processarPixPagoLote(DadosWebHookBradescoDTO pix, IntegracaoPixPagoLog integracaoPixPagoLog) {
        IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
        integracaoPixPagoLog.getDetalhes().add(detalhe);
        try {
            Optional bloquetoPorEvento = this.buscarBloquetoPorEvento(pix, detalhe);
            if (bloquetoPorEvento.isEmpty()) {
                return Optional.empty();
            }
            detalhe.setObservacao("Bloqueto encontrado para processamento");
            return bloquetoPorEvento;
        }
        catch (Exception ex) {
            detalhe.setMensagemErro(ex.toString());
            log.error("Erro ao processar PIX: {}", (Object)ex.getMessage(), (Object)ex);
            return Optional.empty();
        }
    }

    private void processarPagamentoParcelas(Bloqueto bloqueto) {
        bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagos(List<BradescoPixPagoDTO> pixPagos, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        List pixRecebidos = pixPagos.stream().map(DadosWebHookBradescoDTO::fromBradescoPixPago).filter(Objects::nonNull).collect(Collectors.toList());
        return pixRecebidos.stream().map(pix -> this.processarPixConsultaRecebimento(pix, log, tipoMensagem)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<BaixaAutomaticaDetalhe> processarPixConsultaRecebimento(DadosWebHookBradescoDTO pix, IntegracaoPixPagoLog log, TipoMensagem tipoMensagem) {
        IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
        log.getDetalhes().add(detalhe);
        try {
            Optional bloquetoBuscado;
            detalhe.setE2eid(pix.getEndToEndId());
            if (StringUtils.isNotBlank((String)pix.getTxid())) {
                detalhe.setTxid(pix.getTxid());
                detalhe.setBuscaPorE2E(Boolean.FALSE);
            }
            if ((bloquetoBuscado = this.buscarBloquetoPorEvento(pix, detalhe)).isEmpty()) {
                return Optional.empty();
            }
            Bloqueto boleto = (Bloqueto)bloquetoBuscado.get();
            if (this.baixaAutomaticaDetalheService.existsByBoleto(boleto)) {
                detalhe.setObservacao("Boleto j\u00e1 importado.");
                return Optional.empty();
            }
            detalhe.setObservacao("Boleto importado corretamente.");
            return Optional.of(BradescoPixPagoService.builderBaixaAutomaticaDetalhe((DadosWebHookBradescoDTO)pix, (Bloqueto)boleto, (TipoMensagem)tipoMensagem));
        }
        catch (Exception ex) {
            detalhe.setMensagemErro(ex.toString());
            BradescoPixPagoService.log.error("Ocorreu um erro ao processar pix pagos ", (Object)ex.getMessage(), (Object)ex);
            return Optional.empty();
        }
    }

    public static BaixaAutomaticaDetalhe builderBaixaAutomaticaDetalhe(DadosWebHookBradescoDTO pix, Bloqueto bloqueto, TipoMensagem tipoMensagem) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
        baixaAutomaticaDetalhe.setBoleto(bloqueto);
        baixaAutomaticaDetalhe.setNossoNumero(bloqueto.getNossoNumero());
        baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
        baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setDataVencimento(bloqueto.getDataVencimento());
        baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPago(BradescoPixPagoService.converterValorPago((String)pix.getValorPagamento()));
        baixaAutomaticaDetalhe.setValorPagoPrincipal(BradescoPixPagoService.converterValorPago((String)pix.getValorPagamento()));
        baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
        return baixaAutomaticaDetalhe;
    }

    private void salvarIntegracaoBoletoPixPagoLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public Optional<Bloqueto> buscarBloquetoPorEvento(DadosWebHookBradescoDTO dadosWebHook, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setBuscaPorE2E(Boolean.FALSE);
        switch (1.$SwitchMap$br$com$elotech$tributos$dto$enums$TipoConvenioWebHook[dadosWebHook.getTipoConvenioWebHook().ordinal()]) {
            case 1: {
                return this.buscarBloquetoPorTxid(dadosWebHook, detalhe);
            }
            case 2: {
                return this.buscarBloquetoPorNossoNumero(dadosWebHook, detalhe);
            }
        }
        detalhe.setObservacao("Tipo de evento n\u00e3o implementado.");
        return Optional.empty();
    }

    public Optional<Bloqueto> buscarBloquetoPorTxid(DadosWebHookBradescoDTO pix, IntegracaoPixPagoDetalhe detalhe) {
        String txid = pix.getTxid();
        if (StringUtils.isBlank((String)txid)) {
            detalhe.setObservacao("Pix recebido n\u00e3o possui TXID");
            return Optional.empty();
        }
        detalhe.setTxid(txid);
        Optional bloqueto = this.boletoService.findByTxid(txid);
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao(String.format("N\u00e3o foi poss\u00edvel encontrar o boleto para o txid informado. TxID %s", txid));
            return Optional.empty();
        }
        this.builderDetalhe((Bloqueto)bloqueto.get(), detalhe);
        return bloqueto;
    }

    public Optional<Bloqueto> buscarBloquetoPorNossoNumero(DadosWebHookBradescoDTO cobranca, IntegracaoPixPagoDetalhe detalhe) {
        String nossoNumero = cobranca.getNossoNumero();
        if (StringUtils.isBlank((String)nossoNumero)) {
            detalhe.setObservacao("Cobran\u00e7a recebida n\u00e3o possui Nosso N\u00famero");
            return Optional.empty();
        }
        Optional bloqueto = this.boletoService.findByNossoNumero(nossoNumero);
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao(String.format("N\u00e3o foi poss\u00edvel encontrar o boleto para o nosso n\u00famero informado. Nosso n\u00famero %s", nossoNumero));
            return Optional.empty();
        }
        this.builderDetalhe((Bloqueto)bloqueto.get(), detalhe);
        return bloqueto;
    }

    private void builderDetalhe(Bloqueto bloqueto, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setBuscaPorE2E(Boolean.FALSE);
        detalhe.setBoleto(bloqueto.getBloqueto());
        detalhe.setExercicioboleto(bloqueto.getExercicioBloqueto());
        detalhe.setEntidade(bloqueto.getEntidade());
    }

    public LocalDate getDataReferencia(DadosWebHookBradescoDTO dto) {
        String dataPagamento = dto.getDataPagamento();
        if (dataPagamento == null || dataPagamento.isEmpty()) {
            throw new EloValidationException("Data de pagamento n\u00e3o encontrada no webhook do Bradesco.");
        }
        try {
            if (dataPagamento.length() >= 10) {
                String dataAjustada = dataPagamento.substring(0, 10);
                return LocalDate.parse(dataAjustada);
            }
            throw new RestException(HttpStatus.BAD_REQUEST, "Formato de data n\u00e3o esperado: " + dataPagamento);
        }
        catch (DateTimeParseException e) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Formato de data n\u00e3o esperado: " + dataPagamento, (Throwable)e);
        }
    }

    public static BigDecimal converterValorPago(String valor) {
        if (valor == null || valor.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(valor.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Valor inv\u00e1lido: " + valor, e);
        }
    }

    public Optional<BaixaAutomaticaDetalhe> erroProcessamentoPix(IntegracaoPixPagoDetalhe detalhe, Exception ex) {
        detalhe.setMensagemErro(ex.toString());
        log.error("Ocorreu um erro ao processar pix pagos {}", (Object)ex.getMessage(), (Object)ex);
        return Optional.empty();
    }

    public void recuperarErrosWebhook(WebHookResponseBradescoDTO response) {
        if (response != null && response.getListaErros() != null && !response.getListaErros().isEmpty()) {
            String mensagemErros = BradescoPixPagoService.formatarMensagemErrosBradesco((List)response.getListaErros());
            throw new EloValidationException(String.format("Erro ao ativar webhook do pix para o Bradesco: %s", mensagemErros));
        }
    }

    public static String formatarMensagemErrosBradesco(List<WebHookErrosResponseBradescoDTO> erros) {
        return Optional.ofNullable(erros).orElse(List.of()).stream().filter(Objects::nonNull).map(BradescoPixPagoService::formatarErro).collect(Collectors.joining(" | "));
    }

    public static String formatarErro(WebHookErrosResponseBradescoDTO erro) {
        return String.format("[Erro: %s] %s", Optional.ofNullable(erro.getCodigoErro()).orElse(""), Optional.ofNullable(erro.getDescricaoErro()).orElse(""));
    }

    public IntegracaoPixPagoLog builderLog(Convenio convenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog log = new IntegracaoPixPagoLog();
        log.setConvenio(convenio.getId());
        log.setDataIntegracao(LocalDateTime.now());
        log.setDataReferencia(dataReferencia);
        log.setUsuario(SecurityUtils.getUserName());
        return log;
    }

    public URI builderUrlPixPago(LocalDate data, Integer pagina) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_API_PIX_URL);
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(String.format("/%s", "/v2/pix")).queryParam("paginacao.paginaAtual", new Object[]{pagina}).queryParam("paginacao.itensPorPagina", new Object[]{100}).queryParam("inicio", new Object[]{this.formatUtc(data.atStartOfDay())}).queryParam("fim", new Object[]{this.formatUtc(data.atTime(23, 59, 59))}).build(true).toUri();
    }

    private String formatUtc(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.of("UTC")).format(DateTimeFormatter.ISO_INSTANT);
    }

    public String localDateTimeToString(LocalDateTime data) {
        return FORMATO_DATA_HORA_API.format(data);
    }
}

