/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bradesco;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.BradescoOauthDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.CertificadoBradescoDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BradescoAutenticacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BradescoAutenticacaoService.class);
    private final ObjectMapper mapper;
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final ParametroGeralService parametroGeralService;
    private final ParametroPixRepository parametroPixRepository;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TYPE_JSON = "application/json;charset=UTF-8";
    private static final String AUTHORIZATION_BEARER_TOKEN = "Bearer";
    private static final String ACCCES_TOKEN = "access_token";
    private static final String ACCEPT_DEFAULT = "DEFAULT";
    private static final String OAUTH_GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String OAUTH_CLIENT_SECRET = "client_secret";
    private static final String OAUTH_CLIENT_ID = "client_id";
    private static final String END_POINT_OAUTH_COBRANCA = "/auth/server-mtls/v2/token";
    private static final String END_POINT_OAUTH_PIX = "/auth/server/oauth/token";

    public BradescoOauthDTO getOauthBradesco(String url, ParametroGeralEnum clientID, ParametroGeralEnum clientSecret, IntegracaoTokenOperation tipoToken) {
        return this.builderBradescoOauth(url, clientID, clientSecret, null, tipoToken);
    }

    public BradescoOauthDTO builderBradescoOauth(String url, ParametroGeralEnum clientId, ParametroGeralEnum clientSecret, String scope, IntegracaoTokenOperation operacao) {
        return BradescoOauthDTO.builder().url(url).clientId(this.getParametro(clientId)).clientSecret(this.getParametro(clientSecret)).scope(scope).codBanco(Banco.CODIGO_BRADESCO.longValue()).operacaoBanco(operacao).build();
    }

    public CertificadoBradescoDTO getCertificado(Long entidadePrincipal) {
        ParametroPix parametroPix = this.getParametroPixByEntidade(entidadePrincipal);
        return CertificadoBradescoDTO.builder().arquivoCertificado(this.getCertificadoByParametroPix(parametroPix)).senhaCertificado(this.getSenhaCertificadoByParametroPix(parametroPix)).nomeArquivo(this.getNomeCertificadoByParametroPix(parametroPix)).build();
    }

    public ParametroPix getParametroPixByEntidade(Long entidade) {
        return this.parametroPixRepository.getByEntidade(entidade);
    }

    public byte[] getCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoBradescoPix).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado o arquivo do certificado para o Bradesco"));
    }

    public String getSenhaCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoBradescoPix).orElse(null);
    }

    public String getNomeCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoBradescoPix).orElse(null);
    }

    public HttpHeaders criarHeaders(BradescoOauthDTO bradescoOauth, CertificadoBradescoDTO certificadoBradescoDTO, IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", String.format("%s %s", "Bearer", this.getAccessToken(bradescoOauth, certificadoBradescoDTO, integracaoBoletoPixLog)));
        headers.set("Content-Type", "application/json;charset=UTF-8");
        return headers;
    }

    public String getAccessToken(BradescoOauthDTO bradescoOauth, CertificadoBradescoDTO certificadoBradescoDTO, IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Long.valueOf(bradescoOauth.getCodBanco()), bradescoOauth.getOperacaoBanco());
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        JsonNode response = this.generateNewAccessToken(bradescoOauth, certificadoBradescoDTO, integracaoBoletoPixLog);
        return tokenService.saveIntegracaoToken(Long.valueOf(bradescoOauth.getCodBanco()), bradescoOauth.getOperacaoBanco(), response);
    }

    public IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept("DEFAULT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    public JsonNode generateNewAccessToken(BradescoOauthDTO bradescoOauth, CertificadoBradescoDTO certificadoBradescoDTO, IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        BradescoAutenticacaoService.validarCamposObrigatoriosToken((BradescoOauthDTO)bradescoOauth);
        String oauthUrl = bradescoOauth.getUrl();
        String clientId = bradescoOauth.getClientId();
        String clientSecret = bradescoOauth.getClientSecret();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"client_id", (Object)clientId);
        body.add((Object)"client_secret", (Object)clientSecret);
        body.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        integracaoBoletoPixLog.setJsonRequest(httpEntity.toString());
        integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
        integracaoBoletoPixLog.setUrlRequest(oauthUrl);
        try {
            JsonNode response = (JsonNode)this.getRestTemplate(certificadoBradescoDTO.getArquivoCertificado(), certificadoBradescoDTO.getSenhaCertificado(), certificadoBradescoDTO.getNomeArquivo()).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel obter o token para o Bradesco.");
            }
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            JsonNode jsonNode = response;
            return jsonNode;
        }
        catch (HttpStatusCodeException e) {
            integracaoBoletoPixLog.setJsonResponse(e.getResponseBodyAsString());
            throw new RestException(e.getStatusCode(), String.format("Erro HTTP ao obter token do Bradesco: %s", e.getResponseBodyAsString()), (Throwable)e);
        }
        catch (RestException e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(e.getStatus(), String.format("Erro ao obter token do Bradesco: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Erro inesperado ao obter token do Bradesco: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    protected String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeralEnum.name()));
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new ParametroNaoEncontradoException(e.getMessage());
        }
    }

    public RestTemplate getRestTemplate(byte[] certificado, String senhaCertificado, String nomeArquivo) {
        try {
            return RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeArquivo);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public static void validarCamposObrigatoriosToken(BradescoOauthDTO bradescoOauth) {
        BradescoAutenticacaoService.validarCampo((String)bradescoOauth.getUrl(), (String)"Url de autentica\u00e7\u00e3o n\u00e3o configurada para bradesco");
        BradescoAutenticacaoService.validarCampo((String)bradescoOauth.getClientId(), (String)"ClientID n\u00e3o configurada para o bradesco");
        BradescoAutenticacaoService.validarCampo((String)bradescoOauth.getClientSecret(), (String)"ClientSecret n\u00e3o configurada para o bradesco");
    }

    private static void validarCampo(String valor, String mensagemErro) {
        if (StringUtils.isEmpty((String)valor)) {
            throw new EloValidationException(mensagemErro);
        }
    }

    public String cnpjRaiz(String cnpj) {
        if (cnpj == null || cnpj.length() < 14) {
            throw new EloValidationException(String.format("N\u00e3o foi possivel recuperar o n\u00baraiz do CNPJ. Cnpj n\u00e3o \u00e9 v\u00e1lido. CNPJ : %s", cnpj));
        }
        return StringUtils.substring((String)cnpj, (int)0, (int)8);
    }

    public String cnpjControle(String cnpj) {
        if (cnpj == null || cnpj.length() < 14) {
            throw new EloValidationException(String.format("N\u00e3o foi possivel recuperar o n\u00bacontrole do CNPJ. Cnpj n\u00e3o \u00e9 v\u00e1lido. CNPJ : %s", cnpj));
        }
        return cnpj.substring(cnpj.length() - 2);
    }

    public String urlOauthApiCobranca() {
        return String.format("%s%s", this.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_OAUTH_URL), "/auth/server-mtls/v2/token");
    }

    public String urlOauthApiPix() {
        return String.format("%s%s", this.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_API_PIX_URL), "/auth/server/oauth/token");
    }

    public void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public <T> T converteErroResposta(String json, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(json, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    @Generated
    public BradescoAutenticacaoService(ObjectMapper mapper, List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, ParametroPixRepository parametroPixRepository, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager) {
        this.mapper = mapper;
        this.integracaoTokenServices = integracaoTokenServices;
        this.parametroGeralService = parametroGeralService;
        this.parametroPixRepository = parametroPixRepository;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
    }
}

