/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.enums.TipoConvenioWebHook;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.DadosWebHookDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.enums.StatusPagamentoSolicitacao;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.enums.StatusPagamentoWebHookCobranca;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.IntegracaoBoletoBBPayService;
import br.com.elotech.tributos.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BbPixPagoService
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BbPixPagoService.class);
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_AMERICANO = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_BR = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    public static final Integer ITENS_POR_PAGINA = 58;
    private final PagamentoLoteService pagamentoLoteService;
    private final ContextService contextService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final BloquetoService boletoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final TipoMensagemService tipoMensagemService;
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final DebitoParcelaService debitoParcelaService;
    private final IntegracaoBoletoBBPayService integracaoBoletoBBPayService;

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_BANCO_BRASIL.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        log.debug("Chegou no importarPixPago");
        ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
        IntegracaoPixPagoLog integracaoPixPagoLog = this.buildLog(convenio, dataReferencia);
        ArrayList itensGerados = new ArrayList();
        Long entidade = this.contextService.getEntidadePrincipal();
        try {
            if (!convenio.getTipoCodigoBarras().equals((Object)TipoCodigoBarras.BOLETO_BANCARIO_BB_BBPAY)) {
                throw new EloValidationException(String.format("Importa\u00e7\u00e3o de pagamentos PIX n\u00e3o disponivel para o tipo de conv\u00eanio %s ", convenio.getTipoCodigoBarras()));
            }
            this.importarPixPagoBBPAY(integracaoPixPagoLog, itensGerados, convenio, dataReferencia, resultado);
            if (!itensGerados.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, resultado, this.getNomeArquivoPixPago(convenio.getConvenio(), dataReferencia));
                resultado.setDadosLote(lote.getId());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(itensGerados, lote, sequencia);
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
        return resultado;
    }

    public ImportacaoPixPagoResultadoDTO importarPixPagoBBPAY(IntegracaoPixPagoLog integracaoPixPagoLog, List<BaixaAutomaticaDetalhe> itensGerados, Convenio convenio, LocalDate dataReferencia, ImportacaoPixPagoResultadoDTO resultado) {
        PagamentoBBPayResponseDTO response = this.integracaoBoletoBBPayService.getPixPagosBBPay(dataReferencia, Long.valueOf(convenio.getNumeroConvenio()));
        Integer totalRegistros = response.getTotalRegistros();
        integracaoPixPagoLog.setQuantidadeRegistros(Integer.valueOf(response.getTotalRegistros()));
        if (totalRegistros.equals(0)) {
            resultado.setPossuiRegistros(Boolean.FALSE);
            return resultado;
        }
        List solicitacoesPagas = DadosWebHookDTO.fromResponsePagamentosBBPAY((PagamentoBBPayResponseDTO)response);
        itensGerados.addAll(this.processarPixPagos(solicitacoesPagas, integracaoPixPagoLog));
        if (totalRegistros > ITENS_POR_PAGINA) {
            Integer totalPaginas = BbPixPagoService.calcularTotalPaginas((int)totalRegistros, (int)ITENS_POR_PAGINA);
            Integer pagina = 1;
            while (pagina < totalPaginas) {
                response = this.integracaoBoletoBBPayService.getPixPagosBBPay(dataReferencia, response.getTokenPaginacao(), Long.valueOf(convenio.getNumeroConvenio()));
                solicitacoesPagas = DadosWebHookDTO.fromResponsePagamentosBBPAY((PagamentoBBPayResponseDTO)response);
                itensGerados.addAll(this.processarPixPagos(solicitacoesPagas, integracaoPixPagoLog));
                Integer n = pagina;
                pagina = pagina + 1;
            }
        }
        resultado.setPossuiRegistros(Boolean.valueOf(!itensGerados.isEmpty()));
        integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(itensGerados.size()));
        return resultado;
    }

    public static int calcularTotalPaginas(int totalRegistros, int itensPorPagina) {
        if (itensPorPagina <= 0) {
            throw new IllegalArgumentException("O n\u00famero de itens por p\u00e1gina deve ser maior que zero.");
        }
        return (int)Math.ceil((double)totalRegistros / (double)itensPorPagina);
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        return null;
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long idSolicitacao) {
        return null;
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private void saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public List<BaixaAutomaticaDetalhe> processarPixPagos(List<DadosWebHookDTO> dadosWebHook, IntegracaoPixPagoLog pixLog) {
        log.debug("Chegou no processarPixPagos");
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return dadosWebHook.stream().map(registroWebHook -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            pixLog.getDetalhes().add(detalhe);
            try {
                Optional boleto = this.getBloquetoByTipoConvenio(registroWebHook, detalhe);
                if (boleto.isEmpty()) {
                    return null;
                }
                if (this.baixaAutomaticaDetalheService.existsByBoleto((Bloqueto)boleto.get())) {
                    detalhe.setObservacao("Boleto j\u00e1 importado.Importa\u00e7\u00e3o: " + String.valueOf(registroWebHook.getTipoConvenioWebHook()));
                    return null;
                }
                detalhe.setObservacao("Boleto importado corretamente.Importa\u00e7\u00e3o:" + String.valueOf(registroWebHook.getTipoConvenioWebHook()));
                BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
                baixaAutomaticaDetalhe.setBoleto((Bloqueto)boleto.get());
                baixaAutomaticaDetalhe.setNossoNumero(((Bloqueto)boleto.get()).getNossoNumero());
                baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setDataVencimento(((Bloqueto)boleto.get()).getDataVencimento());
                baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPago(registroWebHook.getValorPago());
                baixaAutomaticaDetalhe.setValorPagoPrincipal(registroWebHook.getValorPago());
                baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
                return baixaAutomaticaDetalhe;
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                log.error("Ocorreu um erro ao processar pix pagos para o tipo de conv\u00eanio : " + registroWebHook.getTipoConvenioWebHook().getValue(), (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Optional<Bloqueto> getBloquetoByTipoConvenio(DadosWebHookDTO dadoWebHook, IntegracaoPixPagoDetalhe detalhe) {
        Optional boleto;
        log.debug("Definindo o tipo de conv\u00eanio do Bloqueto {}", dadoWebHook.getTipoConvenioWebHook() != null ? dadoWebHook.getTipoConvenioWebHook() : "N\u00e3o possui tipo conv\u00eanio");
        switch (1.$SwitchMap$br$com$elotech$tributos$dto$enums$TipoConvenioWebHook[dadoWebHook.getTipoConvenioWebHook().ordinal()]) {
            case 1: {
                boleto = this.processarWebHookBBPay(dadoWebHook, detalhe);
                break;
            }
            case 2: {
                boleto = this.processarWebHookArrecadacaoIntegradaPix(dadoWebHook, detalhe);
                break;
            }
            case 3: {
                boleto = this.processarWebHookCobranca(dadoWebHook, detalhe);
                break;
            }
            default: {
                detalhe.setObservacao(String.format("Web Hook n\u00e3o implementado para este tipo de conv\u00eanio %s.", dadoWebHook.getTipoConvenioWebHook()));
                return Optional.empty();
            }
        }
        boleto.ifPresentOrElse(b -> {
            detalhe.setBoleto(b.getBloqueto());
            detalhe.setExercicioboleto(b.getExercicioBloqueto());
            detalhe.setEntidade(b.getEntidade());
        }, () -> detalhe.setObservacao("Boleto n\u00e3o encontrado. Importa\u00e7\u00e3o: " + String.valueOf(dadoWebHook.getTipoConvenioWebHook())));
        return boleto;
    }

    private Optional<Bloqueto> processarWebHookBBPay(DadosWebHookDTO dadoWebHook, IntegracaoPixPagoDetalhe detalhe) {
        log.debug("Chegou no processarWebHookBBPay CodigoConciliacaoSolicitacao {}", (Object)dadoWebHook.getCodigoConciliacaoSolicitacao());
        if (org.apache.commons.lang.StringUtils.isBlank((String)dadoWebHook.getCodigoConciliacaoSolicitacao())) {
            detalhe.setObservacao(String.format("WebHook n\u00e3o retornou o C\u00f3digo da Concilia\u00e7\u00e3o do pagamento do BBPAY para o tipo de conv\u00eanio %s :", TipoConvenioWebHook.BBPAY.getValue()));
            return Optional.empty();
        }
        Optional boleto = this.boletoService.findByNossoNumero(dadoWebHook.getCodigoConciliacaoSolicitacao().trim());
        detalhe.setBuscaPorE2E(Boolean.FALSE);
        detalhe.setE2eid(dadoWebHook.getEndToEndId());
        if (boleto.isPresent()) {
            detalhe.setTxid(((Bloqueto)boleto.get()).getTxidPix());
            log.debug("Recuperou o bloqueto {}", (Object)dadoWebHook.getCodigoConciliacaoSolicitacao());
            if (!this.validarPagamento((Bloqueto)boleto.get(), dadoWebHook, detalhe)) {
                return Optional.empty();
            }
        } else {
            detalhe.setMensagemErro(String.format("N\u00e3o encontrou o boleto para o C\u00f3digo de Concilia\u00e7\u00e3o %s", dadoWebHook.getCodigoConciliacaoSolicitacao()));
        }
        log.debug("Validou que \u00e9 pagamento");
        return boleto;
    }

    private Optional<Bloqueto> processarWebHookArrecadacaoIntegradaPix(DadosWebHookDTO dadoWebHook, IntegracaoPixPagoDetalhe detalhe) {
        log.debug("Chegou no processarWebHookArrecadacaoIntegradaPix txID {}", (Object)dadoWebHook.getTxid());
        if (org.apache.commons.lang.StringUtils.isBlank((String)dadoWebHook.getTxid())) {
            detalhe.setObservacao(String.format("WebHook n\u00e3o retornou o TXID do pagamento Pix para o tipo de conv\u00eanio %s :", TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getValue()));
            return Optional.empty();
        }
        Optional boleto = this.boletoService.findByTxid(dadoWebHook.getTxid());
        detalhe.setE2eid(dadoWebHook.getEndToEndId());
        detalhe.setTxid(dadoWebHook.getTxid());
        detalhe.setBuscaPorE2E(Boolean.FALSE);
        return boleto;
    }

    private Optional<Bloqueto> processarWebHookCobranca(DadosWebHookDTO dadoWebHook, IntegracaoPixPagoDetalhe detalhe) {
        log.debug("Chegou no processarWebHookCobranca IdCobran\u00e7a {}", (Object)dadoWebHook.getIdCobranca());
        if (org.apache.commons.lang.StringUtils.isBlank((String)dadoWebHook.getIdCobranca())) {
            detalhe.setObservacao(String.format("WebHook n\u00e3o retornou o ID da cobran\u00e7a do pagamento Pix para o tipo de conv\u00eanio %s :", TipoConvenioWebHook.COBRANCA_BB.getValue()));
            return Optional.empty();
        }
        Optional boleto = this.boletoService.findByNossoNumero(StringUtils.removerZerosEsquerda((String)dadoWebHook.getIdCobranca()));
        detalhe.setBuscaPorE2E(Boolean.FALSE);
        if (boleto.isPresent()) {
            log.debug("Encontrou o bloqueto {}", (Object)((Bloqueto)boleto.get()).getId());
            if (!this.validarPagamento((Bloqueto)boleto.get(), dadoWebHook, detalhe)) {
                return null;
            }
        }
        log.debug("Validou que \u00e9 pagamento");
        return boleto;
    }

    private boolean validarPagamento(Bloqueto boleto, DadosWebHookDTO dadoWebHook, IntegracaoPixPagoDetalhe detalhe) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)boleto.getTxidPix())) {
            detalhe.setObservacao(String.format("Boleto encontrado mas n\u00e3o possui TXID. Nosso N\u00famero: %s . Importa\u00e7\u00e3o: %s", dadoWebHook.getCodigoConciliacaoSolicitacao(), dadoWebHook.getTipoConvenioWebHook()));
        }
        Long statusPagamento = dadoWebHook.getStatusPagamento();
        log.debug("Chegou no validarPagamento status do pagamento {}", (Object)dadoWebHook.getStatusPagamento());
        if (!(StatusPagamentoSolicitacao.EFETIVADO.getCodigo().equals(statusPagamento) || StatusPagamentoWebHookCobranca.BAIXA_OPERACIONAL_BB.getCodigo().equals(statusPagamento) || StatusPagamentoWebHookCobranca.BAIXA_OPERACIONAL_OUTROS.getCodigo().equals(statusPagamento))) {
            detalhe.setObservacao(String.format("Boleto encontrado por\u00e9m ainda n\u00e3o est\u00e1 pago. C\u00f3digo status retornado: %s .Importa\u00e7\u00e3o: %s ", statusPagamento, dadoWebHook.getTipoConvenioWebHook()));
            log.debug("Chegou o boleto mas o status retornado pelo banco n\u00e3o \u00e9 pago %s", (Object)dadoWebHook.getStatusPagamento());
            return false;
        }
        return true;
    }

    private IntegracaoPixPagoLog buildLog(Convenio convenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog log = new IntegracaoPixPagoLog();
        log.setConvenio(convenio.getId());
        log.setDataIntegracao(LocalDateTime.now());
        log.setDataReferencia(dataReferencia);
        log.setUsuario(SecurityUtils.getUserName());
        return log;
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado, String nomeArquivo) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia, nomeArquivo));
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia, String nomeArquivo) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        pagamentoLote.setNomeArquivo(nomeArquivo);
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private String getNomeArquivoPixPago(Long convenio, LocalDate dataReferencia) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        return String.format("importacao_pix_%d_%s", convenio, FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual));
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog pixLog) {
        log.debug("Chegou no processarPixPagosWebHook do BB {}", (Object)(pixPagos != null ? "pixPagos n\u00e3o est\u00e1 nulo" : "pixPagos est\u00e1 nulo"));
        if (!convenio.getWebhookPixAtivo().booleanValue()) {
            throw new EloValidationException(String.format("WebHook n\u00e3o esta ativo para o conv\u00eanio %s ", convenio.getNumeroConvenio()));
        }
        List listDadosWebHookDTO = DadosWebHookDTO.from((JsonNode)pixPagos);
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_BANCO_BRASIL.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        LocalDate dataReferencia = this.getDataReferencia((DadosWebHookDTO)listDadosWebHookDTO.get(0));
        pixLog.setDataReferencia(dataReferencia);
        pixLog.setQuantidadeRegistros(Integer.valueOf(listDadosWebHookDTO.size()));
        ArrayList baixaAutomaticaDetalhes = new ArrayList();
        log.debug("cria lote  {}", (Object)convenio.getCriarLotePgtPix());
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processarLotePagamentoPix(convenio, pixLog, baixaAutomaticaDetalhes, listDadosWebHookDTO, dataReferencia, entidade);
        } else {
            this.processarPixPago((DadosWebHookDTO)listDadosWebHookDTO.get(0), pixLog);
        }
        return pixLog;
    }

    private void processarLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<BaixaAutomaticaDetalhe> baixaAutomaticaDetalhes, List<DadosWebHookDTO> dadosWebHook, LocalDate dataReferencia, Long entidade) {
        try {
            baixaAutomaticaDetalhes.addAll(this.processarPixPagos(dadosWebHook, log));
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO(), this.getNomeArquivoPixPago(convenio.getConvenio(), dataReferencia));
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequencia);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
    }

    private void processarPixPago(DadosWebHookDTO dadosWebHookDTO, IntegracaoPixPagoLog log) {
        try {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            Bloqueto bloqueto = this.getBloquetoByTipoConvenio(dadosWebHookDTO, detalhe).orElse(null);
            if (Objects.isNull(bloqueto)) {
                return;
            }
            bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
            log.getDetalhes().add(detalhe);
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    public LocalDate getDataReferencia(DadosWebHookDTO dadosWebHookDTO) {
        String timestamp = Optional.ofNullable(dadosWebHookDTO.getDataReferencia()).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter a data de refer\u00eancia dos pix pagos."));
        if (timestamp.contains(".")) {
            timestamp = timestamp.substring(0, timestamp.indexOf(46));
        }
        DateTimeFormatter formatter = DATE_TIME_FORMATTER_AMERICANO;
        if (dadosWebHookDTO.getTipoConvenioWebHook().equals((Object)TipoConvenioWebHook.COBRANCA_BB)) {
            formatter = DATE_TIME_FORMATTER_BR;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timestamp, formatter);
            return localDateTime.toLocalDate();
        }
        catch (DateTimeParseException e) {
            throw new EloValidationException("Erro ao converter a data de refer\u00eancia: " + e.getMessage());
        }
    }

    @Generated
    public BbPixPagoService(PagamentoLoteService pagamentoLoteService, ContextService contextService, ValidaDataMovimentacaoService validaDataMovimentacaoService, BloquetoService boletoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, TipoMensagemService tipoMensagemService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, PlatformTransactionManager transactionManager, DebitoParcelaService debitoParcelaService, IntegracaoBoletoBBPayService integracaoBoletoBBPayService) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.contextService = contextService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.boletoService = boletoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.tipoMensagemService = tipoMensagemService;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.transactionManager = transactionManager;
        this.debitoParcelaService = debitoParcelaService;
        this.integracaoBoletoBBPayService = integracaoBoletoBBPayService;
    }
}

