/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegracaoPixReceiver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoPixReceiver.class);
    private Map<Long, IntegracaoPix> services;

    public IntegracaoPixReceiver(List<IntegracaoPix> services) {
        this.services = services.stream().collect(Collectors.toMap(IntegracaoPix::getCodigoBanco, Function.identity()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Bloqueto gerarQrCodePix(Bloqueto boleto) {
        Validate.notNull((Object)boleto);
        if (StringUtils.isNotEmpty((String)boleto.getTextoQrCode())) {
            return boleto;
        }
        IntegracaoPix service = this.getService(boleto.getModeloBloqueto().getConvenio().getBanco().getId());
        log.debug("Recuperou a service para fazer a gera\u00e7\u00e3o do qrcode do boleto {}", (Object)boleto.getId());
        if (Boolean.FALSE.equals(boleto.getModeloBloqueto().getConvenio().getUtilizaPix())) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Integra\u00e7\u00e3o PIX desabilitada para o conv\u00eanio %s.", boleto.getModeloBloqueto().getConvenio().getDescricao()));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info(String.format("Iniciando a integra\u00e7\u00e3o de pix do banco %s para o boleto %d", Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getBanco).map(Banco::getDescricao).orElse(""), boleto.getId()));
        service.beforeGenerateQrCodePix(boleto);
        IntegracaoPixResponseDTO response = service.generateQrCodePix(boleto);
        service.afterGenerateQrCodePix(boleto, response);
        stopwatch.stop();
        log.info(String.format("Integra\u00e7\u00e3o de pix para o boleto %d finalizada com dura\u00e7\u00e3o de %d m %d s %d ms", boleto.getId(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        return boleto;
    }

    public ConsultaPixResponseDTO getPagamentoPix(Optional<String> txid, Optional<String> endToendIdentification, Convenio convenio) {
        Validate.notNull((Object)convenio);
        IntegracaoPix service = this.getService(convenio.getBanco().getId());
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix())) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Integra\u00e7\u00e3o PIX desabilitada para o conv\u00eanio %s.", convenio.getDescricao()));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info(String.format("Iniciando a consulta de pagamentos de pix do banco %s", Optional.ofNullable(convenio).map(Convenio::getBanco).map(Banco::getDescricao).orElse("")));
        ConsultaPixResponseDTO pagamento = service.getPagamento(txid, endToendIdentification, convenio);
        stopwatch.stop();
        log.info(String.format("Integra\u00e7\u00e3o de consulta de pagamentos de pix para o banco %d finalizada com dura\u00e7\u00e3o de %d m %d s %d ms", convenio.getBanco().getId(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        return pagamento;
    }

    public IntegracaoBoletoPixLog updateCodigoBarrasBoleto(CodigoBarrasQrCodePixItauDTO boleto) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        IntegracaoPix service = this.getService(boleto.getIdBanco());
        return service.updateCodigoBarrasBoleto(boleto);
    }

    private IntegracaoPix getService(Long banco) {
        if (!this.services.containsKey(banco)) {
            throw new IllegalArgumentException("Unknown request type: " + banco);
        }
        return (IntegracaoPix)this.services.get(banco);
    }
}

