/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ImobiliarioItbiObs;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoItbi;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.domain.TipoSituacaoImobiliarioItbi;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.IdItbiDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.itbi.ImobiliarioItbiDTO;
import br.com.elotech.tributos.dto.itbi.ProprietarioItbiDTO;
import br.com.elotech.tributos.repository.ImobiliarioItbiRepository;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.ItbiService;
import br.com.elotech.tributos.service.ParametroItbiService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.RelatorioService;
import br.com.elotech.tributos.service.TipoItbiService;
import br.com.elotech.tributos.service.exception.ImobiliarioItbiNotFound;
import br.com.elotech.tributos.ws.rest.dto.ImobiliarioItbiObsDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ItbiServiceImpl
implements ItbiService {
    private static final Integer IN_STATEMENT_MAX_LENGTH = 999;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final ImobiliarioItbiRepository imobiliarioItbiRepository;
    private final PessoaService pessoaService;
    private final TipoItbiService tipoItbiService;
    private final ParametroItbiService parametroItbiService;
    private final RelatorioService relatorioService;

    public ItbiServiceImpl(EntidadeService entidadeService, ExercicioService exercicioService, ImobiliarioItbiRepository imobiliarioItbiRepository, PessoaService pessoaService, TipoItbiService tipoItbiService, ParametroItbiService parametroItbiService, RelatorioService relatorioService) {
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.imobiliarioItbiRepository = imobiliarioItbiRepository;
        this.pessoaService = pessoaService;
        this.tipoItbiService = tipoItbiService;
        this.parametroItbiService = parametroItbiService;
        this.relatorioService = relatorioService;
    }

    public ImobiliarioItbi gerarItbi(ImobiliarioItbiDTO dto) {
        Long entidade = this.entidadeService.findEntidadePrincipal().getId();
        Long exercicio = this.exercicioService.getExercicio();
        dto.convertToUpperCase();
        ImobiliarioItbi itbi = ImobiliarioItbi.from((ImobiliarioItbiDTO)dto);
        itbi.setEntidade(entidade);
        itbi.setExercicio(exercicio);
        itbi.setDataLancamento(LocalDate.now());
        itbi.setDataSituacao(LocalDate.now());
        itbi.setDataInclusao(LocalDate.now());
        itbi.setTipoItbi((TipoItbi)this.tipoItbiService.findOne((Serializable)dto.getTipoItbi()));
        itbi.setParametroItbi(this.validateParametroItbi(dto.getParametroItbi()));
        itbi.setGuiaRecolhimento(itbi.getParametroItbi().getDivida());
        itbi.setDataVencimento(LocalDate.now().plusDays(itbi.getParametroItbi().getPrazoPagamento()));
        itbi.setSituacao(TipoSituacaoImobiliarioItbi.AGUARDANDO_TRANSFERENCIA);
        this.carregarListasProprietarios(itbi, dto);
        if (!dto.getSegmentos().isEmpty()) {
            dto.getSegmentos().forEach(arg_0 -> ((ImobiliarioItbi)itbi).addSegmento(arg_0));
        }
        itbi.validar();
        itbi.setCodigoItbi(this.imobiliarioItbiRepository.findNextCodigoItbiByExercicio(entidade, exercicio));
        return (ImobiliarioItbi)this.imobiliarioItbiRepository.save((Object)itbi);
    }

    private ParametroItbi validateParametroItbi(Long idParametroItbi) {
        if (Objects.isNull(idParametroItbi)) {
            throw new EloValidationException("O par\u00e2metro de ITBI \u00e9 obrigat\u00f3rio.");
        }
        ParametroItbi parametroItbi = (ParametroItbi)this.parametroItbiService.findById((Serializable)idParametroItbi).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar par\u00e2metro de ITBI com o id %d.", idParametroItbi)));
        if (!parametroItbi.getAtivo().booleanValue()) {
            throw new EloValidationException(String.format("O par\u00e2metro de ITBI %d n\u00e3o est\u00e1 ativo.", idParametroItbi));
        }
        return parametroItbi;
    }

    private void carregarListasProprietarios(ImobiliarioItbi itbi, ImobiliarioItbiDTO dto) {
        this.carregarProprietarios(itbi, dto.getCompradores(), TipoProprietarioItbi.COMPRADOR);
        this.carregarProprietarios(itbi, dto.getVendedores(), TipoProprietarioItbi.VENDEDOR);
        this.carregarProprietarios(itbi, dto.getAnuentes(), TipoProprietarioItbi.ANUENTE);
        this.carregarProprietarios(itbi, dto.getNovosProprietarios(), TipoProprietarioItbi.ATUAL);
    }

    private void carregarProprietarios(ImobiliarioItbi itbi, List<ProprietarioItbiDTO> proprietariosDto, TipoProprietarioItbi tipo) {
        proprietariosDto.forEach(proprietarioDto -> {
            ProprietarioItbi proprietarioItbi = ProprietarioItbi.from((ProprietarioItbiDTO)proprietarioDto);
            Pessoa pessoa = this.pessoaService.findByCnpjCpf(proprietarioDto.getCnpjCpf());
            proprietarioDto.setActiveFormOrigem("ITBI Online");
            if (Objects.nonNull(pessoa)) {
                itbi.addProprietario(proprietarioItbi, pessoa, tipo);
            } else {
                pessoa = this.carregarPessoa(proprietarioDto.toPessoaDTO());
            }
            if (TipoProprietarioItbi.COMPRADOR.equals((Object)tipo)) {
                this.pessoaService.alterarRgPessoa(pessoa, proprietarioDto.toPessoaDTO());
            }
            itbi.addProprietario(proprietarioItbi, pessoa, tipo);
        });
    }

    private Pessoa carregarPessoa(PessoaDTO pessoaDTO) {
        IncluirPessoaRequestDTO requestPessoaDTO = IncluirPessoaRequestDTO.from((PessoaDTO)pessoaDTO);
        return this.pessoaService.incluirPessoa(requestPessoaDTO);
    }

    public List<IdItbiDTO> verificarPagos(List<IdItbiDTO> listIdItbi) {
        List partitions = Lists.partition(listIdItbi.stream().map(IdItbiDTO::getIdItbi).filter(Objects::nonNull).collect(Collectors.toList()), (int)IN_STATEMENT_MAX_LENGTH);
        return partitions.stream().map(arg_0 -> ((ImobiliarioItbiRepository)this.imobiliarioItbiRepository).findIdItbiPagoById(arg_0)).flatMap(Collection::stream).map(IdItbiDTO::new).collect(Collectors.toList());
    }

    public ImobiliarioItbi findImobiliarioItbiById(Long idSequencia) {
        return (ImobiliarioItbi)this.imobiliarioItbiRepository.findById((Object)idSequencia).orElseThrow(() -> new ImobiliarioItbiNotFound(idSequencia));
    }

    public ImobiliarioItbi findImobiliarioItbiByDebito(DebitoIdDTO debitoIdDTO) {
        return this.imobiliarioItbiRepository.findImobiliarioItbiByDebito(debitoIdDTO.getEntidade(), debitoIdDTO.getExercicio(), TipoCadastro.fromValue((Long)debitoIdDTO.getTipoCadastro()), debitoIdDTO.getCadastroGeral(), debitoIdDTO.getDivida(), debitoIdDTO.getSubDivida());
    }

    public ImobiliarioItbi atualizaSituacaoItbiParaTransferido(ImobiliarioItbi imobiliarioItbi) {
        imobiliarioItbi.setSituacao(TipoSituacaoImobiliarioItbi.TRANSFERIDO);
        imobiliarioItbi.setDataSituacao(LocalDate.now());
        return (ImobiliarioItbi)this.imobiliarioItbiRepository.save((Object)imobiliarioItbi);
    }

    public ImprimirRelatorioDTO printTermoIsencao(ImobiliarioItbiDTO imobiliarioItbiDTO) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        ParametroItbi parametroItbi = (ParametroItbi)this.parametroItbiService.findById((Serializable)imobiliarioItbiDTO.getParametroItbi()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado par\u00e2metro ITBI com id %d", imobiliarioItbiDTO.getParametroItbi())));
        Relatorio relatorio = (Relatorio)this.relatorioService.findById((Serializable)RelatorioPK.builder().modulo(ModuloEnum.MODULO_TRIBUTARIO.getValue()).tipoRelatorio(TipoRelatorio.fromValue((String)parametroItbi.getTermoIsencao().getTipoRelatorio().getValue())).relatorio(Integer.valueOf(parametroItbi.getTermoIsencao().getRelatorio())).build()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar relat\u00f3rio com os par\u00e2metros: M\u00f3dulo: [%s], Tipo Relat\u00f3rio: [%s], Relat\u00f3rio: [%s].", ModuloEnum.MODULO_TRIBUTARIO.getValue(), TipoRelatorio.fromValue((String)parametroItbi.getTermoIsencao().getTipoRelatorio().getDescricao()), parametroItbi.getTermoIsencao().getRelatorio())));
        dto.setRelatorio(relatorio.getRelatorio());
        dto.setTipoRelatorio(TipoRelatorio.fromValue((String)relatorio.getTipoRelatorio().getValue()));
        dto.setFiltro(String.format(" TII.CadastroGeral = %s AND TII.TipoCadastro = %s AND TII.codigoitbi = %s", imobiliarioItbiDTO.getCadastroGeral(), imobiliarioItbiDTO.getTipoCadastro(), imobiliarioItbiDTO.getCodigoItbi()));
        dto.setSubReports(this.createSubReportDTO());
        return dto;
    }

    public ImobiliarioItbiObsDTO novaObservacao(Long idItbi, ImobiliarioItbiObsDTO obsDTO) {
        ImobiliarioItbi itbi = this.findImobiliarioItbiById(idItbi);
        if (this.jaExisteObservacao(itbi, obsDTO)) {
            return obsDTO;
        }
        itbi.addObservacao(new ImobiliarioItbiObs(obsDTO.getObservacao()));
        this.imobiliarioItbiRepository.save((Object)itbi);
        return obsDTO;
    }

    private boolean jaExisteObservacao(ImobiliarioItbi itbi, ImobiliarioItbiObsDTO obsDTO) {
        return itbi.getObservacoes().stream().anyMatch(savedObs -> Objects.equals(savedObs.getObservacao().trim(), obsDTO.getObservacao().trim()));
    }

    private SubReportDTO createSubReportDTO() {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Cabecalho", ""), new SubReportItemDTO("AdquirenteIsencao", ""), new SubReportItemDTO("TransmitenteIsencao", ""), new SubReportItemDTO("AnuenteIsencao", ""), new SubReportItemDTO("AreaConstruidaIsencao", ""), new SubReportItemDTO("ITBIIsencao", "")}));
        return subReportDTO;
    }
}

