/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.honorarios;

import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.service.DocumentoPeticaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioCdaService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GerarHonorarioPeticaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarHonorarioPeticaoService.class);
    private final GerarHonorarioCdaService gerarHonorarioCdaService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final DocumentoPeticaoService documentoPeticaoService;

    public void gerarHonorarioByLotePeticaoItem(LotePeticaoItem lotePeticaoItem, ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO, Double percentual) {
        lotePeticaoItem.getDetalhes().stream().filter(lotePeticaoItemDetalhe -> lotePeticaoItemDetalhe.getDocumento().getCancelado() == false).forEach(lotePeticaoItemDetalhe -> this.gerarHonorarioCdaService.gerarHonorarioByDocumento(lotePeticaoItemDetalhe.getDocumento(), listasNecessariasCalculaAcrescimoDTO, percentual));
    }

    @Async
    @Transactional
    public void createTarefaGerarHonorarioByPeticao(Long idPeticao, Double percentual) {
        if (Boolean.TRUE.equals(this.verificarTarefaEmExecucao(idPeticao))) {
            log.debug("Gera\u00e7\u00e3o dos d\u00e9bitos de honor\u00e1rios da peti\u00e7\u00e3o {} est\u00e1 em andamento.", (Object)idPeticao);
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaAssincronaGeracaoDebitoPeticao(idPeticao);
        try {
            this.gerarHonorarioByPeticao(idPeticao, percentual);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            String mensagemErro = String.format("Erro ao fazer a gera\u00e7\u00e3o de d\u00e9bitos de honor\u00e1rios por peti\u00e7\u00e3o. Erro: %s ", e.getMessage());
            log.error(mensagemErro, (Throwable)e);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
        }
    }

    private Boolean verificarTarefaEmExecucao(Long idPeticao) {
        return this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.GERACAO_DEBITOS_HONORARIOS_PETICAO, "ID_PETICAO", String.valueOf(idPeticao));
    }

    private void gerarHonorarioByPeticao(Long idPeticao, Double percentual) {
        ListasNecessariasCalculaAcrescimoDTO listasNecessarias = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        DocumentoDTO documentoDTO = this.documentoPeticaoService.findPeticaoDividaAtiva(idPeticao);
        documentoDTO.getDocumentosItensPeticaoDTO().stream().filter(documentoItemPeticaoDTO -> documentoItemPeticaoDTO.getCanceladoCertidao() == false).forEach(documentoItemPeticaoDTO -> this.gerarHonorarioCdaService.gerarHonorarioByDocumentoId(documentoItemPeticaoDTO.getIdDocumentoCertidao(), listasNecessarias, percentual));
    }

    @Generated
    public GerarHonorarioPeticaoService(GerarHonorarioCdaService gerarHonorarioCdaService, TarefaAssincronaService tarefaAssincronaService, CalculoAcrescimoService calculoAcrescimoService, DocumentoPeticaoService documentoPeticaoService) {
        this.gerarHonorarioCdaService = gerarHonorarioCdaService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.documentoPeticaoService = documentoPeticaoService;
    }
}

