/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.honorarios;

import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.repository.documento.peticao.LotePeticaoRepository;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioPeticaoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GerarHonorarioLoteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarHonorarioLoteService.class);
    private final GerarHonorarioPeticaoService gerarHonorarioPeticaoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final LotePeticaoRepository lotePeticaoRepository;

    @Async
    @Transactional
    public void createTarefaGerarHonorarioByLote(Long idLote, Double percentual) {
        if (Boolean.TRUE.equals(this.verificarTarefaEmExecucao(idLote))) {
            log.debug("Gera\u00e7\u00e3o dos d\u00e9bitos de honor\u00e1rios do lote {} est\u00e1 em andamento.", (Object)idLote);
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaAssincronaGeracaoDebitoLotePeticao(idLote);
        try {
            this.gerarHonorarioByLote(idLote, percentual);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            String mensagemErro = String.format("Erro ao fazer a gera\u00e7\u00e3o de d\u00e9bitos de honor\u00e1rios. Erro: %s ", e.getMessage());
            log.error(mensagemErro, (Throwable)e);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
        }
    }

    private Boolean verificarTarefaEmExecucao(Long idLote) {
        return this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.GERACAO_DEBITOS_HONORARIOS_LOTE_PETICAO, "ID_LOTE_PETICAO", String.valueOf(idLote));
    }

    private void gerarHonorarioByLote(Long idLote, Double percentual) {
        LotePeticao lotePeticao = (LotePeticao)this.lotePeticaoRepository.findOne((Object)idLote);
        ListasNecessariasCalculaAcrescimoDTO listasNecessarias = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        lotePeticao.getItens().stream().filter(lotePeticaoItem -> lotePeticaoItem.getDocumento().getCancelado() == false).forEach(lotePeticaoItem -> this.gerarHonorarioPeticaoService.gerarHonorarioByLotePeticaoItem(lotePeticaoItem, listasNecessarias, percentual));
    }

    @Generated
    public GerarHonorarioLoteService(GerarHonorarioPeticaoService gerarHonorarioPeticaoService, CalculoAcrescimoService calculoAcrescimoService, TarefaAssincronaService tarefaAssincronaService, LotePeticaoRepository lotePeticaoRepository) {
        this.gerarHonorarioPeticaoService = gerarHonorarioPeticaoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.lotePeticaoRepository = lotePeticaoRepository;
    }
}

