/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.honorarios;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CertidaoDividaAtivaDebitoHonorario;
import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaDebitoHonorarioRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.honorarios.ConfigHonorarioService;
import br.com.elotech.tributos.service.honorarios.GerarDebitoHonorarioService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GerarHonorarioCdaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarHonorarioCdaService.class);
    private final GerarDebitoHonorarioService gerarDebitoHonorarioService;
    private final DocumentoItemDividaAtivaService documentoItemDividaAtivaService;
    private final ConfigHonorarioService configHonorarioService;
    private final ContextService contextService;
    private final CertidaoDividaAtivaDebitoHonorarioRepository certidaoDividaAtivaDebitoHonorarioRepository;
    private final DebitoService debitoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DocumentoService documentoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final CalculoAcrescimoService calculoAcrescimoService;

    @Async
    @Transactional
    public void createTarefaGerarHonorarioByCertidao(Long idCertidao, Double percentual) {
        if (Boolean.TRUE.equals(this.verificarTarefaEmExecucao(idCertidao))) {
            log.debug("Gera\u00e7\u00e3o dos d\u00e9bitos de honor\u00e1rios da certid\u00e3o {} est\u00e1 em andamento.", (Object)idCertidao);
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaAssincronaGeracaoDebitoCertidao(idCertidao);
        try {
            ListasNecessariasCalculaAcrescimoDTO listasNecessarias = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
            this.gerarHonorarioByDocumentoId(idCertidao, listasNecessarias, percentual);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            String mensagemErro = String.format("Erro ao fazer a gera\u00e7\u00e3o de d\u00e9bitos de honor\u00e1rios por certid\u00e3o. Erro: %s ", e.getMessage());
            log.error(mensagemErro, (Throwable)e);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
        }
    }

    private Boolean verificarTarefaEmExecucao(Long idCertidao) {
        return this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.GERACAO_DEBITOS_HONORARIOS_CERTIDAO, "ID_CERTIDAO", String.valueOf(idCertidao));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void gerarHonorarioByDocumento(Documento documento, ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO, Double percentual) {
        if (Boolean.FALSE.equals(this.existsDebitosHonoriariosPagosbyDocumentoId(documento.getId()))) {
            Documento documentoAtualizado = this.atualizarItensDividaAtivaDocumento(documento, listasNecessariasCalculaAcrescimoDTO);
            this.gerarHonorarios(documentoAtualizado, percentual);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void gerarHonorarioByDocumentoId(Long documentoId, ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO, Double percentual) {
        if (Boolean.FALSE.equals(this.existsDebitosHonoriariosPagosbyDocumentoId(documentoId))) {
            Documento documento = this.documentoService.findDocumentoDomainById(documentoId);
            Documento documentoAtualizado = this.atualizarItensDividaAtivaDocumento(documento, listasNecessariasCalculaAcrescimoDTO);
            this.gerarHonorarios(documentoAtualizado, percentual);
        }
    }

    private void gerarHonorarios(Documento documento, Double percentual) {
        BigDecimal valorHonorario = this.getValorHonorario(documento.getValorTotalDividaAtivas(), percentual);
        if (valorHonorario.compareTo(BigDecimal.ZERO) > 0) {
            ConfigHonorario configHonorario = this.getConfigHonorario();
            CadastroGeralResumidoDTO cadastroGeralResumidoDTO = CadastroGeralResumidoDTO.from((CadastroGeral)documento.getCadastroGeral());
            this.cancelarDebitosAbertoByDocumentoBeforeCreateNewDebito(documento.getId());
            String observacaoDebito = String.format("D\u00e9bito de honor\u00e1rios oriundo da CDA %s/%s", documento.getDocumento(), documento.getExercicio());
            DebitoIdDTO debitoIdDTO = this.gerarDebitoHonorarioService.gerarDebitoHonorario(cadastroGeralResumidoDTO, valorHonorario, configHonorario, observacaoDebito);
            this.gravarHistoricoCdaDebito(documento, debitoIdDTO);
        }
    }

    public Boolean existsDebitosHonoriariosPagosbyDocumentoId(Long idDocumento) {
        return Optional.ofNullable(this.certidaoDividaAtivaDebitoHonorarioRepository.findDebitoByDocumentoId(idDocumento)).orElse(Collections.emptyList()).stream().anyMatch(Debito::hasParcelasPagas);
    }

    private void cancelarDebitosAbertoByDocumentoBeforeCreateNewDebito(Long idDocumento) {
        Optional.ofNullable(this.certidaoDividaAtivaDebitoHonorarioRepository.findDebitoByDocumentoId(idDocumento)).orElse(Collections.emptyList()).stream().filter(Debito::hasParcelasAbertas).forEach(debito -> debito.getParcelas().stream().filter(debitoParcela -> debitoParcela.getSituacaoDebito().isAberto()).forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).cancelarParcelaAberta(arg_0)));
    }

    private void gravarHistoricoCdaDebito(Documento documento, DebitoIdDTO debitoIdDTO) {
        CertidaoDividaAtivaDebitoHonorario certidaoDividaAtivaDebitoHonorario = new CertidaoDividaAtivaDebitoHonorario();
        certidaoDividaAtivaDebitoHonorario.setSequencia(this.getIncrementSequencia(documento.getId()));
        certidaoDividaAtivaDebitoHonorario.setDocumento(documento);
        certidaoDividaAtivaDebitoHonorario.setDebito(this.getDebito(debitoIdDTO));
        this.certidaoDividaAtivaDebitoHonorarioRepository.save((Object)certidaoDividaAtivaDebitoHonorario);
    }

    private Long getIncrementSequencia(Long id) {
        return this.certidaoDividaAtivaDebitoHonorarioRepository.findMaxSequenciaByDocumentoId(id) + 1L;
    }

    private Debito getDebito(DebitoIdDTO debitoIdDTO) {
        return (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
    }

    private ConfigHonorario getConfigHonorario() {
        return this.configHonorarioService.findByExercicio(this.contextService.getExercicioAtual());
    }

    private BigDecimal getValorHonorario(BigDecimal valorCda, Double percentual) {
        if (percentual > 0.0) {
            return this.calcularPorcentagem(valorCda, percentual);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calcularPorcentagem(BigDecimal valor, Double percentual) {
        return valor.multiply(BigDecimal.valueOf(percentual)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_EVEN);
    }

    public Documento atualizarItensDividaAtivaDocumento(Documento documento, ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO) {
        return this.documentoItemDividaAtivaService.atualizaItensParcelas(documento.getId(), AtualizaItensParcelasDTO.from((Documento)documento, (LocalDate)LocalDate.now()), listasNecessariasCalculaAcrescimoDTO);
    }

    @Generated
    public GerarHonorarioCdaService(GerarDebitoHonorarioService gerarDebitoHonorarioService, DocumentoItemDividaAtivaService documentoItemDividaAtivaService, ConfigHonorarioService configHonorarioService, ContextService contextService, CertidaoDividaAtivaDebitoHonorarioRepository certidaoDividaAtivaDebitoHonorarioRepository, DebitoService debitoService, DebitoParcelaService debitoParcelaService, DocumentoService documentoService, TarefaAssincronaService tarefaAssincronaService, CalculoAcrescimoService calculoAcrescimoService) {
        this.gerarDebitoHonorarioService = gerarDebitoHonorarioService;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
        this.configHonorarioService = configHonorarioService;
        this.contextService = contextService;
        this.certidaoDividaAtivaDebitoHonorarioRepository = certidaoDividaAtivaDebitoHonorarioRepository;
        this.debitoService = debitoService;
        this.debitoParcelaService = debitoParcelaService;
        this.documentoService = documentoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.calculoAcrescimoService = calculoAcrescimoService;
    }
}

