/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.honorarios;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraDebitoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GerarDebitoHonorarioService {
    private final ContextService contextService;
    private final GeraDebitoService geraDebitoService;
    private final DividaService dividaService;

    public DebitoIdDTO gerarDebitoHonorario(CadastroGeralResumidoDTO cadastro, BigDecimal valor, ConfigHonorario configHonorario, String observacaoDebito) {
        Long divida = configHonorario.getGuiaRecolhimentoHono();
        Long exercicio = this.contextService.getExercicioAtual();
        DividaTributo dividaTributo = (DividaTributo)this.getDividaTributo(divida, exercicio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo padr\u00e3o da d\u00edvida %d/%d.", divida, exercicio)));
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        tributo.setTributo(dividaTributo.getTributo().getTributo());
        tributo.setOrdem(dividaTributo.getOrdem());
        tributo.setValorTributo(valor);
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setDataVencimento(LocalDate.now().plusDays(this.getQuantidadeDiasVencimento(configHonorario)));
        parcela.setValor(valor);
        DebitoManualObservacaoDTO observacao = new DebitoManualObservacaoDTO();
        String mensagemObservacao = "D\u00e9bito de honor\u00e1rios";
        if (StringUtils.isNotBlank((String)observacaoDebito)) {
            mensagemObservacao = observacaoDebito;
        }
        observacao.setObservacao(mensagemObservacao);
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(exercicio);
        debitoManualDTO.setDataLancamento(LocalDate.now());
        debitoManualDTO.setDivida(divida);
        debitoManualDTO.setTipoCadastro(cadastro.getTipoCadastro());
        debitoManualDTO.setCadastroGeral(cadastro.getCadastroGeral());
        debitoManualDTO.setPrograma("HonorarioCdaService");
        debitoManualDTO.getTributos().add(tributo);
        debitoManualDTO.getParcelas().add(parcela);
        debitoManualDTO.getObservacoes().add(observacao);
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    private Long getQuantidadeDiasVencimento(ConfigHonorario configHonorario) {
        return Optional.ofNullable(configHonorario.getQuantidadeDiasVencimento()).orElse(0L);
    }

    public Optional<DividaTributo> getDividaTributo(Long dividaId, Long exercicio) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", dividaId, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    @Generated
    public GerarDebitoHonorarioService(ContextService contextService, GeraDebitoService geraDebitoService, DividaService dividaService) {
        this.contextService = contextService;
        this.geraDebitoService = geraDebitoService;
        this.dividaService = dividaService;
    }
}

