/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.exception;

/*
 * Exception performing whole class analysis ignored.
 */
public class NossoNumeroException
extends RuntimeException {
    public static final String ENTIDADE_NOTFOUND = "C\u00f3digo da entidade n\u00e3o foi definido";
    public static final String EXERCICIOBOLETO_NOTFOUND = "Exerc\u00edcio do boleto n\u00e3o foi definido";
    public static final String NUMEROBOLETO_NOTFOUND = "N\u00famero do boleto n\u00e3o foi definido";
    public static final String MODELOBOLETO_NOTFOUND = "Modelo do boleto n\u00e3o foi definido";
    public static final String CONVENIO_NOTFOUND = "Conv\u00eanio n\u00e3o informado para o modelo de boleto %d";
    public static final String NUMEROCONVENIO_NOTFOUND = "N\u00famero do conv\u00eanio n\u00e3o informado para o conv\u00eanio %d";
    public static final String CARTEIRA_NOTFOUND = "C\u00f3digo da carteira n\u00e3o definido para o conv\u00eanio %d";
    public static final String BANCO_NOTFOUND = "Banco n\u00e3o configurado para o conv\u00eanio %d";
    public static final String DATAEMISSAO_NOTFOUND = "Data de emiss\u00e3o do boleto n\u00e3o foi definido";
    public static final String NOSSONUMERO_NOTFOUND = "Nosso n\u00famero do boleto n\u00e3o informado";
    public static final String LINHADIGITAVEL_NOTFOUND = "Linha digit\u00e1vel do boleto n\u00e3o foi informado";
    public static final String CODIGOCEDENTE_NOTFOUND = "C\u00f3digo do cedente n\u00e3o configurado no conv\u00eanio %d";
    public static final String AGENCIA_NOTFOUND = "Numero da Ag\u00eancia n\u00e3o configurado no conv\u00eanio %d";
    public static final String CONTABANCARIA_NOTFOUND = "Conta Banc\u00e1ria n\u00e3o configurada no conv\u00eanio %d";

    public NossoNumeroException(String message) {
        super(message);
    }

    public NossoNumeroException() {
        this("Nosso n\u00famero do boleto n\u00e3o informado");
    }

    public static NossoNumeroException message(String message) {
        return new NossoNumeroException(message);
    }

    public static NossoNumeroException entidadeNotDefined() {
        return NossoNumeroException.message((String)"C\u00f3digo da entidade n\u00e3o foi definido");
    }

    public static NossoNumeroException exercicioBoletoNotFound() {
        return NossoNumeroException.message((String)"Exerc\u00edcio do boleto n\u00e3o foi definido");
    }

    public static NossoNumeroException numeroBoletoNotFound() {
        return NossoNumeroException.message((String)"N\u00famero do boleto n\u00e3o foi definido");
    }

    public static NossoNumeroException modeloBoletoNotFound() {
        return NossoNumeroException.message((String)"Modelo do boleto n\u00e3o foi definido");
    }

    public static NossoNumeroException convenioNotFound(Long modeloBoleto) {
        return NossoNumeroException.message((String)String.format("Conv\u00eanio n\u00e3o informado para o modelo de boleto %d", modeloBoleto));
    }

    public static NossoNumeroException bancoNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("Banco n\u00e3o configurado para o conv\u00eanio %d", convenio));
    }

    public static NossoNumeroException dataEmissaoNotFound() {
        return NossoNumeroException.message((String)"Data de emiss\u00e3o do boleto n\u00e3o foi definido");
    }

    public static NossoNumeroException numeroConvenioNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("N\u00famero do conv\u00eanio n\u00e3o informado para o conv\u00eanio %d", convenio));
    }

    public static NossoNumeroException carteiraNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("C\u00f3digo da carteira n\u00e3o definido para o conv\u00eanio %d", convenio));
    }

    public static NossoNumeroException linhaDigitavelNotFound() {
        return NossoNumeroException.message((String)"Linha digit\u00e1vel do boleto n\u00e3o foi informado");
    }

    public static NossoNumeroException codigoCedenteNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("C\u00f3digo do cedente n\u00e3o configurado no conv\u00eanio %d", convenio));
    }

    public static NossoNumeroException agenciaNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("Numero da Ag\u00eancia n\u00e3o configurado no conv\u00eanio %d", convenio));
    }

    public static NossoNumeroException contaBancariaNotFound(Long convenio) {
        return NossoNumeroException.message((String)String.format("Conta Banc\u00e1ria n\u00e3o configurada no conv\u00eanio %d", convenio));
    }
}

