/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.edicaoemmassa;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.domain.Isencao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.CadastroGeralEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.CampoEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.CamposEdicaoMassa;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.CondominioRepository;
import br.com.elotech.tributos.repository.EdicaoEmMassaRepository;
import br.com.elotech.tributos.repository.ImobiliariaRepository;
import br.com.elotech.tributos.repository.IsencaoRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.repository.LoteamentoRepository;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.repository.SituacaoImobiliarioRepository;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import br.com.elotech.tributos.service.edicaoemmassa.EdicaoEmMassaImobiliarioService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EdicaoEmMassaImobiliarioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdicaoEmMassaImobiliarioService.class);
    private final RespostaRepository respostaRepository;
    private final LogradouroRepository logradouroRepository;
    private final BairroRepository bairroRepository;
    private final LoteamentoRepository loteamentoRepository;
    private final CondominioRepository condominioRepository;
    private final ImobiliariaRepository imobiliariaRepository;
    private final PessoaRepository pessoaRepository;
    private final IsencaoRepository isencaoRepository;
    private final SituacaoImobiliarioRepository situacaoImobiliarioRepository;
    private final EdicaoEmMassaRepository edicaoEmMassaRepository;

    public void validateCamposParaEdicao(EdicaoEmMassaFiltroDTO filtro) {
        filtro.getCamposValues().forEach(campo -> {
            if (Objects.isNull(campo.getCampo().getOrigemCampo())) {
                return;
            }
            switch (1.$SwitchMap$br$com$elotech$tributos$enums$OrigemCampo[campo.getCampo().getOrigemCampo().ordinal()]) {
                case 1: {
                    this.validateLogradouro(campo);
                    break;
                }
                case 2: {
                    this.validateBairro(campo);
                    break;
                }
                case 3: {
                    this.validateSituacao(campo);
                    break;
                }
                case 5: {
                    this.validateCondominio(campo, filtro);
                }
            }
        });
    }

    private void validateCondominio(CamposEdicaoMassa campo, EdicaoEmMassaFiltroDTO filtro) {
        Long id = Long.valueOf(campo.getValor());
        Condominio condominio = (Condominio)this.condominioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Comdom\u00ednio %d n\u00e3o encontrado", id)));
        List<CadastroGeralEdicaoEmMassaDTO> imobiliarios = this.edicaoEmMassaRepository.findCadastrosImobiliariosWithFilter(filtro).stream().filter(CadastroGeralEdicaoEmMassaDTO::shouldValidateCondominio).collect(Collectors.toList());
        ArrayList violations = new ArrayList();
        imobiliarios.forEach(imobiliario -> {
            if (!Objects.equals(imobiliario.getSetorInscricaoCadastral(), condominio.getSetorCodigo()) || !Objects.equals(imobiliario.getDistritoInscricaoCadastral(), condominio.getDistritoCodigo())) {
                String message = String.format("Imobili\u00e1rio %d est\u00e1 no distrito %s e setor %s", imobiliario.getCadastroGeral(), imobiliario.getDistritoInscricaoCadastral(), imobiliario.getSetorInscricaoCadastral());
                String suggestion = String.format("Regularize para o distrito %s e setor %s para utilizar o condom\u00ednio %d - %s", condominio.getDistritoCodigo(), condominio.getSetorCodigo(), condominio.getCondominio(), condominio.getDescricao());
                violations.add(new EloViolation(message, suggestion));
            }
        });
        if (!violations.isEmpty()) {
            throw new EloValidationException(String.format("Os imobili\u00e1rios informados n\u00e3o est\u00e3o no distrito %s e setor %s. Regularize eles para utilizar o condom\u00ednio %d.", condominio.getDistritoCodigo(), condominio.getSetorCodigo(), condominio.getCondominio()), violations);
        }
    }

    private void validateSituacao(CamposEdicaoMassa campo) {
        this.situacaoImobiliarioRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Situa\u00e7\u00e3o %s n\u00e3o encontrada", campo.getValor())));
    }

    private void validateBairro(CamposEdicaoMassa campo) {
        this.bairroRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o encontrado", campo.getValor())));
    }

    private void validateLogradouro(CamposEdicaoMassa campo) {
        this.logradouroRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s n\u00e3o encontrado", campo.getValor())));
    }

    public void handleChangeCadastro(EdicaoEmMassaFiltroDTO filtro, CadastroImobiliario cadastro) {
        filtro.getCamposValues().forEach(campo -> this.handleChangeCadastro(cadastro, campo));
    }

    private void handleChangeCadastro(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        if (Objects.nonNull(campo.getCampo().getOrigemCampo())) {
            switch (1.$SwitchMap$br$com$elotech$tributos$enums$OrigemCampo[campo.getCampo().getOrigemCampo().ordinal()]) {
                case 1: {
                    this.handleChangeLogradouro(cadastro, campo);
                    break;
                }
                case 2: {
                    this.handleChangeBairro(cadastro, campo);
                    break;
                }
                case 3: {
                    this.handleChangeSituacaoImobiliario(cadastro, campo);
                    break;
                }
                case 4: {
                    this.handleChangeLoteamento(cadastro, campo);
                    break;
                }
                case 5: {
                    this.handleChangeCondominio(cadastro, campo);
                    break;
                }
                case 6: {
                    this.handleChangeImobiliaria(cadastro, campo);
                    break;
                }
                case 7: {
                    this.handleChangePessoa(cadastro, campo);
                    break;
                }
                case 8: {
                    this.handleChangeIsencao(cadastro, campo);
                    break;
                }
                case 9: {
                    this.handleChangeComplemento(cadastro, campo);
                    break;
                }
                case 10: {
                    this.handleChangeNumero(cadastro, campo);
                    break;
                }
                case 11: {
                    this.handleChangeFaceQuadra(cadastro, campo);
                    break;
                }
                case 12: {
                    this.handleChangeMatricula(cadastro, campo);
                    break;
                }
                case 13: {
                    this.handleChangeDataMatricula(cadastro, campo);
                    break;
                }
                case 14: {
                    this.handleChangeLivro(cadastro, campo);
                    break;
                }
                case 15: {
                    this.handleChangeFolha(cadastro, campo);
                    break;
                }
                case 16: {
                    this.handleChangeCartorio(cadastro, campo);
                    break;
                }
                case 17: {
                    this.handleChangeAreaLote(cadastro, campo);
                    break;
                }
                case 18: {
                    this.handleChangeAreaUtilLote(cadastro, campo);
                    break;
                }
                case 19: {
                    this.handleChangeAreaPrivativa(cadastro, campo);
                    break;
                }
                case 20: {
                    this.handleChangeAreaComum(cadastro, campo);
                    break;
                }
                case 21: {
                    this.handleChangeAreaTotalConstruida(cadastro, campo);
                    break;
                }
                case 22: {
                    this.handleChangeProfundidadeMedia(cadastro, campo);
                    break;
                }
                case 23: {
                    this.handleChangeAnoAliquotaProgressiva(cadastro, campo);
                    break;
                }
                case 24: {
                    this.handleChangeSuspensoEmissao(cadastro, campo);
                    break;
                }
                case 25: {
                    this.handleChangeCorrespondenciaLocal(cadastro, campo);
                    break;
                }
                case 26: {
                    this.handleChangeCaucionado(cadastro, campo);
                    break;
                }
                case 27: {
                    this.handleChangeImovelProprio(cadastro, campo);
                    break;
                }
                case 28: {
                    this.handleChangeLimitaCercaMuro(cadastro, campo);
                    break;
                }
                case 29: {
                    this.handleChangeCep(cadastro, campo);
                    break;
                }
                case 30: {
                    this.handleChangeLongitude(cadastro, campo);
                    break;
                }
                case 31: {
                    this.handleChangeLatitude(cadastro, campo);
                    break;
                }
                default: {
                    log.info("Origem do campo n\u00e3o encontrada, para o cadastro de id: {} e campo: {}", (Object)cadastro.getId(), (Object)campo.getCampo().getId());
                    break;
                }
            }
        } else {
            this.handleChangeRespostaTerreno(cadastro, campo);
        }
    }

    private void handleChangeRespostaTerreno(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        RespostaTerreno resposta = this.respostaRepository.getRespostasTerrenoFilterByCampo(cadastro.getId(), campo.getCampo().getId()).stream().findFirst().orElse(new RespostaTerreno());
        resposta.setCadastroImobiliario(cadastro);
        resposta.setCampo(CampoEdicaoEmMassaDTO.toEntity((CampoEdicaoEmMassaDTO)campo.getCampo()));
        resposta.setValor(campo.getValor());
        if (!campo.getCampo().getAlternativas().isEmpty()) {
            resposta.setAlternativa((Alternativa)campo.getCampo().getAlternativas().stream().filter(alt -> alt.getId().equals(Long.valueOf(campo.getValor()))).findFirst().orElse(null));
        }
        this.respostaRepository.save((Object)resposta);
    }

    private void handleChangeLatitude(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setLatitude(campo.getValor());
    }

    private void handleChangeLongitude(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setLongitude(campo.getValor());
    }

    private void handleChangeCep(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setCep(Long.valueOf(campo.getValor()));
    }

    private void handleChangeLimitaCercaMuro(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setLimitaCercaMuro(SimNao.toBoolean((String)campo.getValor()));
    }

    private void handleChangeImovelProprio(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setImovelProprio(SimNao.toBoolean((String)campo.getValor()));
    }

    private void handleChangeCaucionado(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setCaucionado(SimNao.toBoolean((String)campo.getValor()));
    }

    private void handleChangeCorrespondenciaLocal(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setCorrespondenciaLocal(SimNao.toBoolean((String)campo.getValor()));
    }

    private void handleChangeSuspensoEmissao(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setSuspensoEmissao(SimNao.toBoolean((String)campo.getValor()));
    }

    private void handleChangeAnoAliquotaProgressiva(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAnoAliquotaProgressiva(Long.valueOf(campo.getValor()));
    }

    private void handleChangeProfundidadeMedia(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setProfundidadeMedia(new BigDecimal(campo.getValor()));
    }

    private void handleChangeAreaTotalConstruida(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAreaTotalConstruida(new BigDecimal(campo.getValor()));
    }

    private void handleChangeAreaComum(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAreaComum(new BigDecimal(campo.getValor()));
    }

    private void handleChangeAreaPrivativa(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAreaPrivativa(new BigDecimal(campo.getValor()));
    }

    private void handleChangeAreaUtilLote(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAreaUtilLote(new BigDecimal(campo.getValor()));
    }

    private void handleChangeAreaLote(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setAreaLote(new BigDecimal(campo.getValor()));
    }

    private void handleChangeCartorio(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setCartorio(campo.getValor());
    }

    private void handleChangeFolha(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setFolha(campo.getValor());
    }

    private void handleChangeLivro(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setLivro(campo.getValor());
    }

    private void handleChangeDataMatricula(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setDataMatricula(LocalDate.parse(campo.getValor()));
    }

    private void handleChangeMatricula(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setMatricula(campo.getValor());
    }

    private void handleChangeFaceQuadra(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setFaceQuadra(campo.getValor());
    }

    private void handleChangeNumero(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setNumero(campo.getValor());
    }

    private void handleChangeComplemento(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        cadastro.setComplemento(campo.getValor());
    }

    private void handleChangeIsencao(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        Long id = Long.valueOf(campo.getValor());
        Isencao isencao = (Isencao)this.isencaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Isen\u00e7\u00e3o com id %d n\u00e3o encontrada", id)));
        if (cadastro.getCadastroGeralIsencoes().isEmpty()) {
            CadastroGeralIsencao newIsencao = new CadastroGeralIsencao();
            newIsencao.setCadastroGeral((CadastroGeral)cadastro);
            newIsencao.setIsencao(isencao);
            cadastro.getCadastroGeralIsencoes().add(newIsencao);
            return;
        }
        cadastro.getCadastroGeralIsencoes().forEach(i -> {
            if (Boolean.TRUE.equals(i.isAtiva())) {
                i.setIsencao(isencao);
                i.setChanged(Boolean.TRUE);
            }
        });
    }

    private void handleChangePessoa(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        Long id = Long.valueOf(campo.getValor());
        Pessoa pessoa = (Pessoa)this.pessoaRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Pessoa com id %d n\u00e3o encontrada", id)));
        cadastro.setPessoa(pessoa);
        cadastro.getProprietarios().forEach(p -> {
            if (Boolean.TRUE.equals(p.isPrincipal())) {
                p.setPessoa(pessoa);
                p.setChanged(Boolean.TRUE);
            }
        });
    }

    private void handleChangeImobiliaria(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.imobiliariaRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setImobiliaria(arg_0));
    }

    private void handleChangeCondominio(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.condominioRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setCondominio(arg_0));
    }

    private void handleChangeLoteamento(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.loteamentoRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setLoteamento(arg_0));
    }

    private void handleChangeSituacaoImobiliario(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.situacaoImobiliarioRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setSituacaoImobiliario(arg_0));
    }

    private void handleChangeBairro(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.bairroRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setBairro(arg_0));
    }

    private void handleChangeLogradouro(CadastroImobiliario cadastro, CamposEdicaoMassa campo) {
        this.logradouroRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setLogradouro(arg_0));
    }

    @Generated
    public EdicaoEmMassaImobiliarioService(RespostaRepository respostaRepository, LogradouroRepository logradouroRepository, BairroRepository bairroRepository, LoteamentoRepository loteamentoRepository, CondominioRepository condominioRepository, ImobiliariaRepository imobiliariaRepository, PessoaRepository pessoaRepository, IsencaoRepository isencaoRepository, SituacaoImobiliarioRepository situacaoImobiliarioRepository, EdicaoEmMassaRepository edicaoEmMassaRepository) {
        this.respostaRepository = respostaRepository;
        this.logradouroRepository = logradouroRepository;
        this.bairroRepository = bairroRepository;
        this.loteamentoRepository = loteamentoRepository;
        this.condominioRepository = condominioRepository;
        this.imobiliariaRepository = imobiliariaRepository;
        this.pessoaRepository = pessoaRepository;
        this.isencaoRepository = isencaoRepository;
        this.situacaoImobiliarioRepository = situacaoImobiliarioRepository;
        this.edicaoEmMassaRepository = edicaoEmMassaRepository;
    }
}

