/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ecarta;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.oxy.repository.dto.ModeloArquivoFileDTO;
import br.com.elotech.reportexecutor.client.ModeloArquivoExecutorFeignClient;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ecarta.ComunicadoECarta;
import br.com.elotech.tributos.domain.ecarta.MatrizECarta;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaContext;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaDTO;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaResponseDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.service.ecarta.ComunicadoECartaService;
import br.com.elotech.tributos.service.ecarta.MatrizECartaService;
import br.com.elotech.tributos.util.ByteMultipartFile;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExportacaoECartaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportacaoECartaService.class);
    private static final String TMP_COMUNICADOS = "tmpComunicados";
    private static final String NOME_ARQUIVO = "e-Carta_%s_%d_servico";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TXT_EXTENSION = ".txt";
    private static final String PDF_EXTENSION = ".pdf";
    private static final String PREFIXO_PDF = "e-Carta_%s_%d";
    private static final Long QTDE_MAX_ARQUIVOS_DEFAULT = 10000L;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final MatrizECartaService matrizECartaService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final Optional<ModeloArquivoExecutorFeignClient> modeloArquivoExecutorFeignClient;
    private final ComunicadoECartaService comunicadoECartaService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;

    @Async
    @Transactional
    public void exportarComunicadosECartaTarefa(ExportacaoECartaDTO exportacaoECartaDTO, UserSecurityDTO userSecurityDTO) {
        log.debug("Cria\u00e7\u00e3o da tarefa EXPORTACAO_COMUNICADO_ECARTA para do Comunicado {}", (Object)exportacaoECartaDTO.getComunicadoId());
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaExportacaoComunicadoECarta(exportacaoECartaDTO.getComunicadoId().toString());
        Long tarefa = execucao.getTarefaAssincrona().getId();
        Optional notificacaoId = this.notificacaoService.send("Exportanto Lote para o ECarta", String.format("Iniciando exporta\u00e7\u00e3o para o ECarta %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        try {
            log.debug("Iniciando a Exporta\u00e7\u00e3o do Comunicado [entidade:{}, exercicio:{}, comunicadoId:{} para o ECarta]", new Object[]{exportacaoECartaDTO.getComunicadoId().getEntidade(), exportacaoECartaDTO.getComunicadoId().getExercicio(), exportacaoECartaDTO.getComunicadoId().getIdComunicado()});
            this.exportarComunicadosECarta(exportacaoECartaDTO);
            log.debug("Finalizada com Sucesso a Exporta\u00e7\u00e3o do Comunicado para o ECarta da Tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada Exporta\u00e7\u00e3o do Comunicado para o ECarta", String.format("Finalizada com Sucesso a Exporta\u00e7\u00e3o do Comunicado para o ECarta da Tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
        }
        catch (Exception e) {
            log.debug("Ocorreu um erro na Exporta\u00e7\u00e3o do Comunicado para o ECarta da Tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.notificacaoService.send("Erro na Exporta\u00e7\u00e3o do Comunicado para o ECarta", String.format("Ocorreu um erro na Exporta\u00e7\u00e3o do Comunicado para o ECarta da Tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    public List<ExportacaoECartaResponseDTO> exportarComunicadosECarta(ExportacaoECartaDTO exportacaoECartaDTO) {
        MatrizECarta matrizECarta = (MatrizECarta)this.matrizECartaService.findById((Serializable)exportacaoECartaDTO.getMatrizECarta()).orElseThrow(() -> new EloValidationException(String.format("Matriz do E-Carta %d n\u00e3o encontrada.", exportacaoECartaDTO.getMatrizECarta())));
        if (Objects.isNull(matrizECarta.getModeloArquivoExportacao())) {
            throw new EloValidationException(String.format("Modelo de Arquivo n\u00e3o Configurado no Cadastro da Matriz %d", exportacaoECartaDTO.getMatrizECarta()));
        }
        return this.processarComunicados(exportacaoECartaDTO, matrizECarta);
    }

    private List<ExportacaoECartaResponseDTO> processarComunicados(ExportacaoECartaDTO exportacaoECartaDTO, MatrizECarta matrizECarta) {
        Long qtdeMaxComunicados = this.getQtdeMaxArquivos(matrizECarta);
        ArrayList<ExportacaoECartaResponseDTO> arquivosGerados = new ArrayList<ExportacaoECartaResponseDTO>();
        String tmpdir = "";
        String fileNameBase = "";
        String zipName = "";
        String txtName = "";
        Long numeroLote = 0L;
        List comunicadosList = this.comunicadoCadastroService.findByRsql(exportacaoECartaDTO.getComunicadoId().getEntidade(), exportacaoECartaDTO.getComunicadoId().getExercicio(), exportacaoECartaDTO.getComunicadoId().getIdComunicado(), "", Sort.by((String[])new String[]{"id.sequencia"}));
        if (comunicadosList.isEmpty()) {
            throw new EloValidationException("N\u00e3o h\u00e1 Comunicados para Exporta\u00e7\u00e3o para o ECarta.");
        }
        ArrayList<Long> sequencias = new ArrayList<Long>();
        for (ComunicadoCadastro comunicadoCadastro : comunicadosList) {
            if (sequencias.isEmpty()) {
                tmpdir = this.createTempDir();
                numeroLote = this.sequenceGeneratorRepository.getNextVal("S05ECARTALOTE");
                fileNameBase = String.format(NOME_ARQUIVO, matrizECarta.getMatriz(), numeroLote);
                zipName = fileNameBase.concat(ZIP_EXTENSION);
                txtName = fileNameBase.concat(TXT_EXTENSION);
            }
            if (Boolean.TRUE.equals(matrizECarta.getGeraArquivoComplementar()) && (Boolean.FALSE.equals(matrizECarta.getPdfUnico()) || sequencias.isEmpty())) {
                String nomeArquivo = this.getNomeArquivoComunicado(comunicadoCadastro, matrizECarta, numeroLote);
                byte[] comunicadoImpresso = this.imprimirComunicado(comunicadoCadastro);
                this.saveToFile(tmpdir.concat("/").concat(nomeArquivo), comunicadoImpresso);
            }
            sequencias.add(comunicadoCadastro.getId().getSequencia());
            if ((long)sequencias.size() != qtdeMaxComunicados) continue;
            ExportacaoECartaContext context = ExportacaoECartaContext.builder().exportacaoECartaDTO(exportacaoECartaDTO).matrizECarta(matrizECarta).tmpdir(tmpdir).txtName(txtName).sequencias(sequencias).zipName(zipName).comunicado(comunicadoCadastro.getId().getComunicado()).numeroLote(numeroLote).build();
            arquivosGerados.add(this.gerarArquivos(context));
            sequencias.clear();
        }
        if (!sequencias.isEmpty()) {
            ExportacaoECartaContext context = ExportacaoECartaContext.builder().exportacaoECartaDTO(exportacaoECartaDTO).matrizECarta(matrizECarta).tmpdir(tmpdir).txtName(txtName).sequencias(sequencias).zipName(zipName).comunicado(((ComunicadoCadastro)comunicadosList.get(0)).getId().getComunicado()).numeroLote(numeroLote).build();
            arquivosGerados.add(this.gerarArquivos(context));
        }
        return arquivosGerados;
    }

    private Long getQtdeMaxArquivos(MatrizECarta matrizECarta) {
        return Objects.nonNull(matrizECarta.getQtdeMaximaArquivos()) && matrizECarta.getQtdeMaximaArquivos() > 0L ? matrizECarta.getQtdeMaximaArquivos() : QTDE_MAX_ARQUIVOS_DEFAULT;
    }

    private ExportacaoECartaResponseDTO gerarArquivos(ExportacaoECartaContext context) {
        this.saveToFile(context.getTmpdir().concat("/").concat(context.getTxtName()), this.gerarModeloArquivo(context));
        byte[] zip = FileUtils.zipBytesByPath((String)context.getTmpdir());
        this.saveToFile(context.getTmpdir().concat("/").concat(context.getZipName()), zip);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("exportacaoComunicadoECarta", String.format("%d_%d_%d", context.getExportacaoECartaDTO().getComunicadoId().getEntidade(), context.getExportacaoECartaDTO().getComunicadoId().getExercicio(), context.getExportacaoECartaDTO().getComunicadoId().getIdComunicado()));
        ArquivoDTO arquivoDTO = this.uploadToS3(context.getZipName(), zip, metadata);
        this.saveComunicadoECarta(context, arquivoDTO.getId());
        ExportacaoECartaResponseDTO response = new ExportacaoECartaResponseDTO();
        response.setNomeArquivo(context.getZipName());
        response.setIdArquivoS3(arquivoDTO.getId());
        response.setLinkS3(this.getUrlDownload(arquivoDTO).getUrlAssinada());
        return response;
    }

    private byte[] imprimirComunicado(ComunicadoCadastro comunicadoCadastro) {
        return this.comunicadoCadastroService.print(comunicadoCadastro.getId().getComunicado().getId().getEntidade(), comunicadoCadastro.getId().getComunicado().getId().getExercicio(), comunicadoCadastro.getId().getComunicado().getId().getIdComunicado(), comunicadoCadastro.getId().getSequencia());
    }

    private void saveComunicadoECarta(ExportacaoECartaContext context, Long idArquivoS3) {
        ComunicadoECarta comunicadoECarta = new ComunicadoECarta();
        comunicadoECarta.setComunicado(context.getComunicado());
        comunicadoECarta.setLote(context.getNumeroLote());
        comunicadoECarta.setMatriz(context.getMatrizECarta().getMatriz());
        comunicadoECarta.setIdArquivoS3(idArquivoS3);
        comunicadoECarta.setDataGeracao(LocalDate.now());
        this.comunicadoECartaService.save((EloEntity)comunicadoECarta, null);
    }

    private ArquivoUrl getUrlDownload(ArquivoDTO arquivoDTO) {
        return this.arquivoStorageFeignClient.getUrlDownload(arquivoDTO.getFullPath(), arquivoDTO.getNome());
    }

    private byte[] gerarModeloArquivo(ExportacaoECartaContext context) {
        log.debug("Iniciando comunica\u00e7\u00e3o com a API do Report Executor para gerar o Modelo Arquivo: {}", (Object)context.getMatrizECarta().getModeloArquivoExportacao());
        if (this.modeloArquivoExecutorFeignClient.isEmpty()) {
            throw new EloValidationException("ModeloArquivoExecutor FeignClient n\u00e3o configurado");
        }
        ModeloArquivoFileDTO response = ((ModeloArquivoExecutorFeignClient)this.modeloArquivoExecutorFeignClient.get()).executeByCodigo(context.getMatrizECarta().getModeloArquivoExportacao(), this.buildParametros(context));
        log.debug("Finalizando comunica\u00e7\u00e3o com a API do Report Exercutor para o Modelo Arquivo: {}", (Object)context.getMatrizECarta().getModeloArquivoExportacao());
        return response.getContent();
    }

    private Map<String, Object> buildParametros(ExportacaoECartaContext context) {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("Entidade", context.getExportacaoECartaDTO().getComunicadoId().getEntidade());
        parametros.put("Exercicio", context.getExportacaoECartaDTO().getComunicadoId().getExercicio());
        parametros.put("IdComunicado", context.getExportacaoECartaDTO().getComunicadoId().getIdComunicado());
        parametros.put("ParamMatriz", context.getMatrizECarta().getMatriz());
        parametros.put("SequenciaInicial", context.getPrimeiraSequencia());
        parametros.put("SequenciaFinal", context.getUltimaSequencia());
        parametros.put("ParamPdfUnico", context.getMatrizECarta().getPdfUnico());
        parametros.put("ParamNumeroLote", context.getNumeroLote());
        parametros.put("ParamDescricaoExportacao", context.getExportacaoECartaDTO().getDescricaoConteudo());
        parametros.put("ParamCartaoPostagem", context.getMatrizECarta().getCartaoPostagem());
        parametros.put("ParamNumeroContrato", context.getMatrizECarta().getContrato());
        parametros.put("ParamGeraArquivoComplementar", context.getMatrizECarta().getGeraArquivoComplementar());
        return parametros;
    }

    private ArquivoDTO uploadToS3(String fileName, byte[] fileContent, HashMap<String, String> metadata) {
        ByteMultipartFile byteMultipartFile = new ByteMultipartFile(fileContent, ContentType.APPLICATION_ZIP.getDescricao());
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, fileName, SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/ExportacaoECarta", LocalDate.now(), ContentType.APPLICATION_ZIP.getDescricao(), null, null, metadata);
        return this.arquivoStorageFeignClient.createWithFile(arquivoDTO, (MultipartFile)byteMultipartFile);
    }

    private String getNomeArquivoComunicado(ComunicadoCadastro comunicado, MatrizECarta matriz, Long lote) {
        String prefixo = String.format(PREFIXO_PDF, matriz.getMatriz(), lote);
        if (Boolean.TRUE.equals(matriz.getPdfUnico())) {
            return prefixo.concat("_1_1_complementar").concat(PDF_EXTENSION);
        }
        return String.format("%s_%d_%d_%d_1_complementar", prefixo, comunicado.getId().getSequencia(), comunicado.getCadastroGeral().getTipoCadastro().getValue(), comunicado.getCadastroGeral().getCadastroGeral()).concat(PDF_EXTENSION);
    }

    private void saveToFile(String fileName, byte[] fileContent) {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            fos.write(fileContent);
        }
        catch (Exception e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Ocorreu um erro ao salvar o arquivo %s: %s", fileName, e.getMessage()), (Throwable)e);
        }
    }

    private String createTempDir() {
        String tmpdir;
        try {
            tmpdir = Files.createTempDirectory(TMP_COMUNICADOS, new FileAttribute[0]).toFile().getAbsolutePath();
        }
        catch (Exception e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Ocorreu um erro ao criar a pasta tempor\u00e1ria %s: %s", TMP_COMUNICADOS, e.getMessage()), (Throwable)e);
        }
        return tmpdir;
    }

    @Generated
    public ExportacaoECartaService(ComunicadoCadastroService comunicadoCadastroService, MatrizECartaService matrizECartaService, SequenceGeneratorRepository sequenceGeneratorRepository, ArquivoStorageFeignClient arquivoStorageFeignClient, Optional<ModeloArquivoExecutorFeignClient> modeloArquivoExecutorFeignClient, ComunicadoECartaService comunicadoECartaService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.matrizECartaService = matrizECartaService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.modeloArquivoExecutorFeignClient = modeloArquivoExecutorFeignClient;
        this.comunicadoECartaService = comunicadoECartaService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

