/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ecarta;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.ecarta.ComunicadoECarta;
import br.com.elotech.tributos.dto.ecarta.ComunicadoECartaDTO;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaResponseDTO;
import br.com.elotech.tributos.repository.ecarta.ComunicadoECartaRepository;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoECartaService
extends CrudService<ComunicadoECarta, Long> {
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final ComunicadoECartaRepository comunicadoECartaRepository;

    public ExportacaoECartaResponseDTO getArquivoExportado(Long id) {
        ArquivoDTO arquivoDTO = this.arquivoStorageFeignClient.findOne(id);
        ExportacaoECartaResponseDTO response = new ExportacaoECartaResponseDTO();
        response.setNomeArquivo(arquivoDTO.getNome());
        response.setIdArquivoS3(arquivoDTO.getId());
        response.setLinkS3(this.getUrlDownload(arquivoDTO).getUrlAssinada());
        return response;
    }

    public List<ComunicadoECartaDTO> findByComunicado(ComunicadoId comunicadoId) {
        return this.comunicadoECartaRepository.findByComunicadoId(comunicadoId).stream().map(ComunicadoECartaDTO::from).collect(Collectors.toList());
    }

    private ArquivoUrl getUrlDownload(ArquivoDTO arquivoDTO) {
        return this.arquivoStorageFeignClient.getUrlDownload(arquivoDTO.getFullPath(), arquivoDTO.getNome());
    }

    @Generated
    public ComunicadoECartaService(ArquivoStorageFeignClient arquivoStorageFeignClient, ComunicadoECartaRepository comunicadoECartaRepository) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.comunicadoECartaRepository = comunicadoECartaRepository;
    }
}

