/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.domain.documento.cda.ValidacaoDadosContribuintesDTO;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemPessoaRepository;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import br.com.elotech.tributos.util.EnderecoUtils;
import br.com.elotech.tributos.util.LongUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LoteCdaItemPessoaService
extends CrudService<LoteCdaItemPessoa, Long> {
    private final LoteCdaService loteCdaService;
    private final LoteCdaItemPessoaRepository loteCdaItemPessoaRepository;
    private final TransactionTemplate transactionTemplate;

    public ValidacaoDadosContribuintesDTO revalidarDadosContribuintes(Long idLote) {
        ValidacaoDadosContribuintesDTO dadosContribuintesLoteDTO = new ValidacaoDadosContribuintesDTO();
        LoteCda loteCda = (LoteCda)this.loteCdaService.findOne((Serializable)idLote);
        List pessoasParaValidar = loteCda.getItens().stream().flatMap(item -> item.getItemPessoas().stream()).toList();
        for (LoteCdaItemPessoa loteCdaItemPessoa : pessoasParaValidar) {
            Pessoa pessoa = loteCdaItemPessoa.getPessoa();
            EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
            boolean isValidCnpjCpf = pessoa.isValidCnpjCpf();
            ValidacaoDadosContribuintesDTO dadosContribuintesItemDTO = new ValidacaoDadosContribuintesDTO();
            this.countInvalidCnpjCpf(dadosContribuintesItemDTO, isValidCnpjCpf);
            this.countInvalidEndereco(dadosContribuintesItemDTO, enderecoPrincipal);
            loteCdaItemPessoa.setValido(Boolean.valueOf(dadosContribuintesItemDTO.isValid()));
            loteCdaItemPessoa.setMensagemInvalida(dadosContribuintesItemDTO.getInvalidMessage());
            this.countInvalidCnpjCpf(dadosContribuintesLoteDTO, isValidCnpjCpf);
            this.countInvalidEndereco(dadosContribuintesLoteDTO, enderecoPrincipal);
        }
        if (!dadosContribuintesLoteDTO.isValid()) {
            this.transactionTemplate.execute(status -> {
                this.loteCdaItemPessoaRepository.saveAll((Iterable)pessoasParaValidar);
                return null;
            });
        }
        return dadosContribuintesLoteDTO;
    }

    private void countInvalidCnpjCpf(ValidacaoDadosContribuintesDTO dadosInvalidos, boolean isValidCnpjCpf) {
        if (!isValidCnpjCpf) {
            dadosInvalidos.setQtdeCpfCnpjInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeCpfCnpjInvalido())));
        }
    }

    private void countInvalidEndereco(ValidacaoDadosContribuintesDTO dadosInvalidos, EnderecoPessoa endereco) {
        if (Objects.isNull(endereco)) {
            dadosInvalidos.setQtdeEnderecoPrincipalInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeEnderecoPrincipalInvalido())));
            return;
        }
        this.countInvalidNumero(dadosInvalidos, endereco.getNumero());
        this.countInvalidLogradouro(dadosInvalidos, endereco.getLogradouro());
        this.countInvalidBairro(dadosInvalidos, endereco.getBairro());
        this.countInvalidCep(dadosInvalidos, endereco.getCep());
        this.countInvalidCidade(dadosInvalidos, endereco.getCidade());
        this.countInvalidUnidadeFederacao(dadosInvalidos, (String)Optional.ofNullable(endereco.getCidade()).map(Cidade::getUnidadeFederacao).orElse(null));
    }

    private void countInvalidNumero(ValidacaoDadosContribuintesDTO dadosInvalidos, String numero) {
        if (StringUtils.isBlank((CharSequence)numero)) {
            dadosInvalidos.setQtdeNumeroEnderecoInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeNumeroEnderecoInvalido())));
        }
    }

    private void countInvalidLogradouro(ValidacaoDadosContribuintesDTO dadosInvalidos, Logradouro logradouro) {
        if (Objects.isNull(logradouro)) {
            dadosInvalidos.setQtdeLogradouroInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeLogradouroInvalido())));
        }
    }

    private void countInvalidBairro(ValidacaoDadosContribuintesDTO dadosInvalidos, Bairro bairro) {
        if (Objects.isNull(bairro)) {
            dadosInvalidos.setQtdeBairroInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeBairroInvalido())));
        }
    }

    private void countInvalidCep(ValidacaoDadosContribuintesDTO dadosInvalidos, Long cep) {
        if (!EnderecoUtils.isValidCep((Long)cep)) {
            dadosInvalidos.setQtdeCepInvalido(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeCepInvalido())));
        }
    }

    private void countInvalidCidade(ValidacaoDadosContribuintesDTO dadosInvalidos, Cidade cidade) {
        if (Objects.isNull(cidade)) {
            dadosInvalidos.setQtdeCidadeInvalida(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeCidadeInvalida())));
        }
    }

    private void countInvalidUnidadeFederacao(ValidacaoDadosContribuintesDTO dadosInvalidos, String unidadeFederacao) {
        if (StringUtils.isBlank((CharSequence)unidadeFederacao)) {
            dadosInvalidos.setQtdeUnidadeFederacaoInvalida(Long.valueOf(LongUtils.incrementAndGet((Long)dadosInvalidos.getQtdeUnidadeFederacaoInvalida())));
        }
    }

    @Generated
    public LoteCdaItemPessoaService(LoteCdaService loteCdaService, LoteCdaItemPessoaRepository loteCdaItemPessoaRepository, TransactionTemplate transactionTemplate) {
        this.loteCdaService = loteCdaService;
        this.loteCdaItemPessoaRepository = loteCdaItemPessoaRepository;
        this.transactionTemplate = transactionTemplate;
    }
}

