/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.dto.documento.cda.DeleteCDASimulacaoItemDetalheDTO;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemDetalheRepository;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemService;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoteCdaItemDetalheService {
    private final LoteCdaItemDetalheRepository loteCdaItemDetalheRepository;
    private final LoteCdaItemService loteCdaItemService;

    public void deletePorParcela(DeleteCDASimulacaoItemDetalheDTO dto) {
        SituacaoLoteCda situacaoLote = this.loteCdaItemService.getSituacaoLoteByItemId(dto.getIdItem());
        if (Objects.isNull(situacaoLote)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar detalhe do item");
        }
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)situacaoLote)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover detalhes de item de lote com situa\u00e7\u00e3o diferente de %s", SituacaoLoteCda.SIMULACAO_GERADA.getDescricao()));
        }
        List itemsToRemove = this.loteCdaItemDetalheRepository.findAllByParcelaAndIdItem(dto.getIdItem(), dto.getEntidade(), dto.getExercicio(), dto.getDivida(), dto.getSubDivida(), dto.getParcela());
        this.loteCdaItemDetalheRepository.deleteAll((Iterable)itemsToRemove);
    }

    public LoteCdaItemDetalhe findByDocumentoItemDividaAtiva(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        return this.loteCdaItemDetalheRepository.findByDocumentoItemDividaAtiva(documentoItemDividaAtiva.getDocumento().getEntidade(), documentoItemDividaAtiva.getExercicioDebito(), documentoItemDividaAtiva.getTipoCadastro(), documentoItemDividaAtiva.getCadastroGeral(), documentoItemDividaAtiva.getCodigoDivida(), documentoItemDividaAtiva.getSubDivida(), documentoItemDividaAtiva.getParcela(), documentoItemDividaAtiva.getTributo(), documentoItemDividaAtiva.getDocumento().getId());
    }

    public void saveAll(List<LoteCdaItemDetalhe> loteCdaItemDetalhes) {
        this.loteCdaItemDetalheRepository.saveAll(loteCdaItemDetalhes);
    }

    @Generated
    public LoteCdaItemDetalheService(LoteCdaItemDetalheRepository loteCdaItemDetalheRepository, LoteCdaItemService loteCdaItemService) {
        this.loteCdaItemDetalheRepository = loteCdaItemDetalheRepository;
        this.loteCdaItemService = loteCdaItemService;
    }
}

