/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoResponsavel;
import br.com.elotech.tributos.domain.DocumentoResponsavelId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalProfissao;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.TipoResponsavel;
import br.com.elotech.tributos.repository.ProfissionalRepository;
import br.com.elotech.tributos.repository.projeto.ProjetoRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentoResponsavelService
extends CrudService<DocumentoResponsavel, DocumentoResponsavelId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentoResponsavelService.class);
    private final ProjetoRepository projetoRepository;
    private final ProfissionalRepository profissionalRepository;

    public List<DocumentoResponsavel> createResponsavelByDocumento(Documento documento) {
        if (!this.isPossuiProjeto(documento)) {
            return List.of();
        }
        Projeto projeto = this.getProjeto(documento);
        if (projeto == null) {
            return List.of();
        }
        return projeto.getResponsaveis().stream().map(responsavelProjeto -> {
            DocumentoResponsavel responsavel = new DocumentoResponsavel();
            Long idPessoa = Optional.ofNullable(responsavelProjeto.getPessoa()).map(Pessoa::getId).orElse(null);
            Long idTipoResponsavel = Optional.ofNullable(responsavelProjeto.getTipoResponsavel()).map(TipoResponsavel::getId).orElse(null);
            responsavel.setDocumento(documento);
            responsavel.setPessoa(idPessoa);
            responsavel.setTipoResponsavel(idTipoResponsavel);
            responsavel.setObservacao(responsavelProjeto.getObservacao());
            Long sequenciaProfissional = this.getSequenciaProfissionalPrincipal(idPessoa);
            responsavel.setSequenciaProfissional(sequenciaProfissional);
            return responsavel;
        }).toList();
    }

    private boolean isPossuiProjeto(Documento documento) {
        return Objects.nonNull(documento.getEntidade()) && Objects.nonNull(documento.getExercicioProjeto()) && Objects.nonNull(documento.getNumeroProjeto());
    }

    private Projeto getProjeto(Documento documento) {
        ProjetoPK projetoPK = ProjetoPK.from((Long)documento.getEntidade(), (Long)documento.getExercicioProjeto(), (Long)documento.getNumeroProjeto());
        return (Projeto)this.projetoRepository.findOne((Object)projetoPK);
    }

    private Long getSequenciaProfissionalPrincipal(Long pessoaId) {
        return this.profissionalRepository.findByIdPessoaId(pessoaId).map(Profissional::getProfissaoPrincipal).map(ProfissionalProfissao::getSequencia).orElse(null);
    }

    @Generated
    public DocumentoResponsavelService(ProjetoRepository projetoRepository, ProfissionalRepository profissionalRepository) {
        this.projetoRepository = projetoRepository;
        this.profissionalRepository = profissionalRepository;
    }
}

