/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import javax.validation.Valid;
import org.springframework.stereotype.Service;

@Service
public class CertidaoEncerramentoService {
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoService documentoService;

    public CertidaoEncerramentoService(CadastroMobiliarioService cadastroMobiliarioService, GeraDocumentoService geraDocumentoService, DocumentoService documentoService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoService = documentoService;
    }

    private void validateSituacaoMobiliario(SituacaoMobiliario situacaoMobiliario, String descricaoTipoCadastro, Long cadastroGeral) {
        if (!situacaoMobiliario.getTipoSituacaoMobiliario().isEncerrado().booleanValue()) {
            throw new EloValidationException(String.format("Cadastro %s: %d est\u00e1 com situa\u00e7\u00e3o '%s'! Para a emiss\u00e3o da certid\u00e3o de encerramento, o cadastro deve possuir situa\u00e7\u00e3o do tipo 'Encerrado'", descricaoTipoCadastro, cadastroGeral, situacaoMobiliario.getDescricao()));
        }
    }

    public DocumentoDTO save(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.findCadastroMobiliarioById(documentoGenericoDTO.getIdCadastro());
        SituacaoMobiliario situacaoMobiliario = cadastroMobiliario.getSituacaoAtual();
        this.validateSituacaoMobiliario(situacaoMobiliario, cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral());
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroMobiliario, (TipoDocumentoEnum)TipoDocumentoEnum.CERTIDAO_ENCERRAMENTO));
        documento.setSituacaoCadastral(situacaoMobiliario.getDescricao());
        Documento saved = (Documento)this.documentoService.save((EloEntity)documento, null);
        return DocumentoDTO.from((Documento)saved);
    }

    public DocumentoGenericoDTO getInitialValues(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.CERTIDAO_ENCERRAMENTO);
    }

    public DocumentoDTO editar(Long id, @Valid DocumentoGenericoDTO dto) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.findCadastroMobiliarioById(dto.getIdCadastro());
        SituacaoMobiliario situacaoMobiliario = cadastroMobiliario.getSituacaoAtual();
        this.validateSituacaoMobiliario(situacaoMobiliario, cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral());
        dto.setSituacaoCadastral(situacaoMobiliario.getDescricao());
        return this.documentoService.editar(id, dto);
    }
}

