/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.datacorrecao;

import br.com.elotech.tributos.service.datacorrecao.CalculoDataCorrecao;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class CalculoDataCorrecaoPadrao
implements CalculoDataCorrecao {
    private static final Long ZERO = 0L;
    private static final Long UM = 1L;
    private LocalDate dataProximaCorrecao;
    private Boolean parceladoOuReparcelado = Boolean.FALSE;
    private LocalDate dataAtual;
    private LocalDate dataLancamento;
    private LocalDate dataVencimentoPrimeiraParcela;
    private LocalDate dataVencimentoParcela;

    public CalculoDataCorrecaoPadrao(Boolean parceladoOuReparcelado, LocalDate dataLancamento, LocalDate dataVencimentoPrimeiraParcela, LocalDate dataVencimentoParcela, LocalDate dataAtual) {
        this.parceladoOuReparcelado = parceladoOuReparcelado;
        this.dataLancamento = dataLancamento;
        this.dataVencimentoPrimeiraParcela = dataVencimentoPrimeiraParcela;
        this.dataVencimentoParcela = dataVencimentoParcela;
        this.dataAtual = dataAtual;
    }

    public void defineDataInicialParaCorrecao() {
        this.setDataProximaCorrecao(LocalDate.of(this.dataAtual.getYear(), this.dataVencimentoPrimeiraParcela.getMonthValue(), 1));
    }

    protected Boolean parceladoAMenosDeUmMesEEntradaJaVenceu() {
        return DateUtils.monthsBetween((LocalDate)this.dataLancamento, (LocalDate)this.dataAtual).equals(ZERO) && this.dataVencimentoPrimeiraParcela.isAfter(this.dataAtual);
    }

    protected Boolean anoDaEntradaEMaiorQueOAnoCorrente() {
        return this.dataVencimentoPrimeiraParcela.getYear() > this.dataAtual.getYear();
    }

    protected Boolean foiCorrigidoEsteMes() {
        return this.dataProximaCorrecao.getYear() == this.dataAtual.getYear() && this.dataProximaCorrecao.getMonthValue() == this.dataAtual.getMonthValue();
    }

    protected Boolean dataProximaCorrecaoAindaEMenorQueADataAtual() {
        return this.dataProximaCorrecao.isBefore(this.dataAtual) || this.dataProximaCorrecao.isEqual(this.dataAtual);
    }

    protected Boolean parcelaNaoEstaVencida() {
        return this.dataVencimentoParcela.isEqual(this.dataAtual) || this.dataVencimentoParcela.isAfter(this.dataAtual);
    }

    public LocalDate defaultResult() {
        return null;
    }

    public LocalDate ajustaDataDeCorrecaoFinal() {
        return null;
    }

    public LocalDate calculaData() {
        if (Boolean.FALSE.equals(this.parceladoOuReparcelado)) {
            return this.defaultResult();
        }
        if (Objects.isNull(this.dataAtual)) {
            this.setDataAtual(LocalDate.now());
        }
        this.defineDataInicialParaCorrecao();
        if (Boolean.TRUE.equals(this.parceladoAMenosDeUmMesEEntradaJaVenceu())) {
            this.dataProximaCorrecao = this.dataProximaCorrecao.plusYears(UM);
        }
        if (Boolean.TRUE.equals(this.anoDaEntradaEMaiorQueOAnoCorrente())) {
            this.dataProximaCorrecao = this.dataProximaCorrecao.plusYears(UM);
        }
        if (Boolean.TRUE.equals(this.foiCorrigidoEsteMes())) {
            this.dataProximaCorrecao = this.dataProximaCorrecao.plusYears(UM);
        }
        if (Boolean.TRUE.equals(this.dataProximaCorrecaoAindaEMenorQueADataAtual())) {
            this.dataProximaCorrecao = this.dataProximaCorrecao.plusYears(UM);
        }
        return this.ajustaDataDeCorrecaoFinal();
    }

    @Generated
    public LocalDate getDataProximaCorrecao() {
        return this.dataProximaCorrecao;
    }

    @Generated
    public void setDataProximaCorrecao(LocalDate dataProximaCorrecao) {
        this.dataProximaCorrecao = dataProximaCorrecao;
    }

    @Generated
    public void setDataAtual(LocalDate dataAtual) {
        this.dataAtual = dataAtual;
    }

    @Generated
    public LocalDate getDataAtual() {
        return this.dataAtual;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimentoPrimeiraParcela() {
        return this.dataVencimentoPrimeiraParcela;
    }

    @Generated
    public void setDataVencimentoPrimeiraParcela(LocalDate dataVencimentoPrimeiraParcela) {
        this.dataVencimentoPrimeiraParcela = dataVencimentoPrimeiraParcela;
    }

    @Generated
    public LocalDate getDataVencimentoParcela() {
        return this.dataVencimentoParcela;
    }

    @Generated
    public void setDataVencimentoParcela(LocalDate dataVencimentoParcela) {
        this.dataVencimentoParcela = dataVencimentoParcela;
    }
}

