/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.datacorrecao;

import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.datacorrecao.CalculoDataCorrecaoDataLimiteVencimentoBloquetoParcelado;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;

public class BuscaDataVencimentoBloqueto {
    private LocalDate dataEmissaoBloqueto;
    private LocalDate dataVencimentoParcela;
    private LocalDate dataPrimeiraParcela;
    private LocalDate dataLancamentoDebito;
    private Boolean parcelado = Boolean.FALSE;
    private Boolean reparcelado = Boolean.FALSE;
    private Long numeroDiasDataVencimento;
    private LocalDate dataAtual;
    private LocalDate dataVencimentoBloqueto;
    private Boolean salarioMinimo = Boolean.FALSE;
    private Boolean calculaDataVencimentoCorrecao = Boolean.FALSE;
    private LocalDate dataCorrecao;
    private DiaUtilService diaUtilService;
    private Boolean geraBoletoEmDiasUteis = Boolean.FALSE;
    private Boolean correcaoPorVencimento = Boolean.FALSE;
    private LocalDate dataProximaCorrecao;

    private void defineProximaCorrecao() {
        if (Boolean.TRUE.equals(this.salarioMinimo)) {
            this.dataProximaCorrecao = null;
            return;
        }
        CalculoDataCorrecaoDataLimiteVencimentoBloquetoParcelado calculoDataCorrecao = new CalculoDataCorrecaoDataLimiteVencimentoBloquetoParcelado(Boolean.valueOf(Boolean.TRUE.equals(this.parcelado) || Boolean.TRUE.equals(this.reparcelado)), this.dataLancamentoDebito, this.dataPrimeiraParcela, this.dataVencimentoParcela, this.dataAtual);
        this.dataProximaCorrecao = calculoDataCorrecao.calculaData();
        if (Objects.isNull(this.dataProximaCorrecao) && this.dataPrimeiraParcela.getMonthValue() == this.dataEmissaoBloqueto.getMonthValue() && this.dataPrimeiraParcela.isBefore(this.dataEmissaoBloqueto)) {
            this.correcaoPorVencimento = Boolean.TRUE;
            int dia = DateUtils.isValidDate((int)this.dataEmissaoBloqueto.getYear(), (int)this.dataEmissaoBloqueto.getMonthValue(), (int)this.dataPrimeiraParcela.getDayOfMonth()) ? this.dataPrimeiraParcela.getDayOfMonth() : LocalDate.of(this.dataEmissaoBloqueto.getYear(), this.dataEmissaoBloqueto.getMonthValue(), 1).lengthOfMonth();
            this.dataProximaCorrecao = LocalDate.of(this.dataEmissaoBloqueto.getYear(), this.dataEmissaoBloqueto.getMonthValue(), dia);
        }
        if (Objects.nonNull(this.dataProximaCorrecao) && this.dataProximaCorrecao.isBefore(this.dataEmissaoBloqueto)) {
            this.dataProximaCorrecao = Objects.nonNull(this.dataCorrecao) ? this.dataCorrecao : null;
        } else if (Objects.nonNull(this.dataProximaCorrecao) && Objects.nonNull(this.dataCorrecao)) {
            this.dataProximaCorrecao = DateUtils.menorData((LocalDate[])new LocalDate[]{this.dataCorrecao, this.dataProximaCorrecao});
        }
        this.dataCorrecao = this.dataProximaCorrecao;
    }

    private LocalDate getDataBloqueto(LocalDate dataEmissaoBloqueto, Long numeroDiasDataVencimento, LocalDate dataAtualCalculo) {
        LocalDate retorno = dataAtualCalculo.plusDays(numeroDiasDataVencimento);
        if (retorno.isBefore(dataEmissaoBloqueto)) {
            retorno = dataEmissaoBloqueto;
        }
        return retorno;
    }

    private LocalDate buscaDataVencimentoParcela() {
        LocalDate retorno = this.dataVencimentoParcela;
        if (Boolean.FALSE.equals(this.diaUtilService.diaUtil(retorno)) && Boolean.TRUE.equals(this.geraBoletoEmDiasUteis)) {
            retorno = this.diaUtilService.diaUtilProximo(retorno);
        }
        return this.checkByDataCorrecao(retorno);
    }

    private Boolean possuiDiaUtilAteFimDoMes(LocalDate dataInicio) {
        LocalDate iterationDate = dataInicio;
        LocalDate ultimoDiaMes = dataInicio.with(TemporalAdjusters.lastDayOfMonth());
        Boolean retorno = Boolean.FALSE;
        while (Boolean.FALSE.equals(retorno) && (iterationDate.isBefore(ultimoDiaMes) || iterationDate.isEqual(ultimoDiaMes))) {
            retorno = this.diaUtilService.diaUtil(iterationDate);
            iterationDate = iterationDate.plusDays(1L);
        }
        return retorno;
    }

    private LocalDate getUltimoDiaUtilMes(LocalDate dataEmissaoBloqueto) {
        LocalDate lastDayOfMonth = dataEmissaoBloqueto.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate retorno = Boolean.TRUE.equals(this.diaUtilService.diaUtil(lastDayOfMonth)) ? lastDayOfMonth : (dataEmissaoBloqueto.isEqual(lastDayOfMonth) ? this.diaUtilService.diaUtilAnterior(dataEmissaoBloqueto.plusMonths(1L)) : (Boolean.FALSE.equals(this.possuiDiaUtilAteFimDoMes(dataEmissaoBloqueto)) ? this.diaUtilService.diaUtilProximo(dataEmissaoBloqueto) : this.diaUtilService.diaUtilAnterior(lastDayOfMonth)));
        return retorno;
    }

    private LocalDate checkByDataCorrecao(LocalDate data) {
        LocalDate retorno = data;
        if (Boolean.FALSE.equals(this.calculaDataVencimentoCorrecao)) {
            return retorno;
        }
        if (Objects.nonNull(this.dataProximaCorrecao) && (data.isAfter(this.dataProximaCorrecao) || data.isEqual(this.dataProximaCorrecao))) {
            LocalDate temporaryDate;
            LocalDate temporaryDateBeforeCorrecao = Boolean.TRUE.equals(this.correcaoPorVencimento) ? (this.dataProximaCorrecao.isEqual(this.dataEmissaoBloqueto) ? data : this.dataProximaCorrecao.minusDays(1L)) : this.dataProximaCorrecao;
            retorno = Boolean.FALSE.equals(this.diaUtilService.diaUtil(temporaryDateBeforeCorrecao)) ? ((temporaryDate = this.diaUtilService.diaUtilAnterior(temporaryDateBeforeCorrecao)).isEqual(this.dataEmissaoBloqueto) || temporaryDate.isAfter(this.dataEmissaoBloqueto) ? temporaryDate : this.diaUtilService.diaUtilProximo(temporaryDateBeforeCorrecao)) : temporaryDateBeforeCorrecao;
        }
        return retorno;
    }

    public LocalDate findDate() {
        LocalDate dataVencimentoBloqueto;
        if (Boolean.TRUE.equals(this.calculaDataVencimentoCorrecao)) {
            this.defineProximaCorrecao();
            dataVencimentoBloqueto = this.dataEmissaoBloqueto;
        } else {
            dataVencimentoBloqueto = this.getDataBloqueto(this.dataEmissaoBloqueto, this.numeroDiasDataVencimento, this.dataAtual);
        }
        LocalDate novoVencimentoParcela = this.buscaDataVencimentoParcela();
        if (novoVencimentoParcela.isBefore(dataVencimentoBloqueto)) {
            if (Boolean.TRUE.equals(this.calculaDataVencimentoCorrecao)) {
                dataVencimentoBloqueto = this.getUltimoDiaUtilMes(this.dataEmissaoBloqueto);
            }
            this.dataVencimentoBloqueto = Objects.isNull(this.dataVencimentoBloqueto) ? dataVencimentoBloqueto : DateUtils.menorData((LocalDate[])new LocalDate[]{this.dataVencimentoBloqueto, dataVencimentoBloqueto});
        } else {
            this.dataVencimentoBloqueto = Objects.isNull(this.dataVencimentoBloqueto) ? (Boolean.TRUE.equals(this.calculaDataVencimentoCorrecao) || dataVencimentoBloqueto.isBefore(novoVencimentoParcela) ? novoVencimentoParcela : dataVencimentoBloqueto) : (Boolean.TRUE.equals(this.calculaDataVencimentoCorrecao) || dataVencimentoBloqueto.isBefore(novoVencimentoParcela) ? DateUtils.menorData((LocalDate[])new LocalDate[]{this.dataVencimentoBloqueto, novoVencimentoParcela}) : DateUtils.menorData((LocalDate[])new LocalDate[]{this.dataVencimentoBloqueto, dataVencimentoBloqueto}));
        }
        return this.checkByDataCorrecao(this.dataVencimentoBloqueto);
    }

    @Generated
    public BuscaDataVencimentoBloqueto() {
    }

    @Generated
    public void setDataEmissaoBloqueto(LocalDate dataEmissaoBloqueto) {
        this.dataEmissaoBloqueto = dataEmissaoBloqueto;
    }

    @Generated
    public void setDataVencimentoParcela(LocalDate dataVencimentoParcela) {
        this.dataVencimentoParcela = dataVencimentoParcela;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setDataLancamentoDebito(LocalDate dataLancamentoDebito) {
        this.dataLancamentoDebito = dataLancamentoDebito;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setNumeroDiasDataVencimento(Long numeroDiasDataVencimento) {
        this.numeroDiasDataVencimento = numeroDiasDataVencimento;
    }

    @Generated
    public void setDataAtual(LocalDate dataAtual) {
        this.dataAtual = dataAtual;
    }

    @Generated
    public void setDataVencimentoBloqueto(LocalDate dataVencimentoBloqueto) {
        this.dataVencimentoBloqueto = dataVencimentoBloqueto;
    }

    @Generated
    public void setSalarioMinimo(Boolean salarioMinimo) {
        this.salarioMinimo = salarioMinimo;
    }

    @Generated
    public void setCalculaDataVencimentoCorrecao(Boolean calculaDataVencimentoCorrecao) {
        this.calculaDataVencimentoCorrecao = calculaDataVencimentoCorrecao;
    }

    @Generated
    public void setDataCorrecao(LocalDate dataCorrecao) {
        this.dataCorrecao = dataCorrecao;
    }

    @Generated
    public void setDiaUtilService(DiaUtilService diaUtilService) {
        this.diaUtilService = diaUtilService;
    }

    @Generated
    public void setGeraBoletoEmDiasUteis(Boolean geraBoletoEmDiasUteis) {
        this.geraBoletoEmDiasUteis = geraBoletoEmDiasUteis;
    }
}

