/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contencioso;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoHistorico;
import br.com.elotech.tributos.domain.ContenciosoHistoricoId;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.repository.ContenciosoHistoricoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ContenciosoHistoricoService
extends CrudService<ContenciosoHistorico, ContenciosoHistoricoId> {
    private final ContenciosoHistoricoRepository repository;
    private static final DateTimeFormatter HORA_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public void createAndSaveHistorico(Contencioso contencioso, SituacaoContenciosoDebito parecer, MotivoDeducao motivoDeducao) {
        ContenciosoHistorico historico = this.buildHistoricoFromContencioso(contencioso, parecer, motivoDeducao);
        this.repository.save((Object)historico);
    }

    private ContenciosoHistorico buildHistoricoFromContencioso(Contencioso contencioso, SituacaoContenciosoDebito parecer, MotivoDeducao motivoDeducao) {
        ContenciosoHistorico historico = new ContenciosoHistorico();
        historico.setId(this.generateHistoricoId(contencioso.getId()));
        historico.setData(LocalDate.now());
        historico.setHora(this.formatHoraAtual());
        historico.setSituacao(contencioso.getSituacao());
        historico.setSituacaoContencioso(contencioso.getSituacaoContencioso());
        historico.setInstancia(contencioso.getInstancia());
        historico.setObservacao(contencioso.getObservacao());
        historico.setUsuario(SecurityUtils.getUserAise());
        historico.setEntidade(contencioso.getEntidade());
        historico.setExercicioProcesso(contencioso.getExercicioProcesso());
        historico.setIdProcesso(contencioso.getIdProcesso());
        historico.setProcessoSei(contencioso.getProcessoSei());
        historico.setParecerista(contencioso.getParecerista());
        historico.setParecer(parecer);
        historico.setMotivoDeducao(motivoDeducao);
        historico.setProcessoSei(contencioso.getProcessoSei());
        historico.setExercicioProcessoSegundaInstancia(contencioso.getExercicioProcessoSegundaInstancia());
        historico.setObservacaoSegundaInstancia(contencioso.getObservacaoSegundaInstancia());
        historico.setProcessoSeiSegundaInstancia(contencioso.getProcessoSeiSegundaInstancia());
        historico.setIdProcessoSegundaInstancia(contencioso.getIdProcessoSegundaInstancia());
        return historico;
    }

    private ContenciosoHistoricoId generateHistoricoId(Long contenciosoId) {
        Long sequencia = this.getNextSequencia(contenciosoId);
        return ContenciosoHistoricoId.of((Long)contenciosoId, (Long)sequencia);
    }

    private Long getNextSequencia(Long contenciosoId) {
        Long maxSequencia = this.repository.findMaxSequenciaByIdContencioso(contenciosoId);
        return maxSequencia + 1L;
    }

    private String formatHoraAtual() {
        return HORA_FORMATTER.format(LocalDateTime.now());
    }

    public List<ContenciosoHistorico> findByContenciosoId(Long idContencioso) {
        return this.repository.findByContenciosoId(idContencioso);
    }

    @Generated
    public ContenciosoHistoricoService(ContenciosoHistoricoRepository repository) {
        this.repository = repository;
    }
}

