/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contencioso;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.enums.OpcoesExararDebito;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class AcaoExararAbstract {
    protected ContenciosoRepository contenciosoRepository;
    protected CancelamentoDebitoService cancelamentoDebitoService;
    protected DebitoParcelaService debitoParcelaService;
    protected SituacaoParcelaService situacaoParcelaService;

    protected void validaContenciosoEmAberto(Contencioso contencioso) {
        List<ContenciosoSituacaoEnum> situacoesPermitidas = Arrays.asList(ContenciosoSituacaoEnum.ABERTO, ContenciosoSituacaoEnum.EM_SEGUNDA_INSTANCIA);
        if (!situacoesPermitidas.contains(contencioso.getSituacao())) {
            throw new EloValidationException("Contencioso deve estar com a situa\u00e7\u00e3o ABERTO ou EM SEGUNDA INSTANCIA para poder ser exarado");
        }
    }

    protected void atualizaStatusDoContenciosoEParcelas(ContenciosoDebitosExararDTO dto, Contencioso contencioso, List<ContenciosoDebitoDTO> contenciosoDebitosDTOSelected, OpcoesExararDebito opcoesExararDebito) {
        List<ContenciosoDebito> contenciosoDebitosSelected = contencioso.getDebitos().stream().filter(d -> contenciosoDebitosDTOSelected.stream().anyMatch(arg_0 -> ((ContenciosoDebito)d).equalsToDto(arg_0))).collect(Collectors.toList());
        contenciosoDebitosSelected.forEach(debitoContencioso -> {
            debitoContencioso.setSituacao(dto.getParecer());
            debitoContencioso.setMotivoParecer(dto.getMotivoParecer());
            debitoContencioso.getParcelas().forEach(parcela -> this.updateSituacaoParcelaAntiga(parcela, contencioso, opcoesExararDebito));
        });
    }

    protected void updateSituacaoParcelaAntiga(ContenciosoDebitoParcela parcela, Contencioso contencioso, OpcoesExararDebito opcoesExararDebito) {
        Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(parcela.getId().getEntidade(), parcela.getId().getExercicio(), parcela.getId().getTipoCadastro().getValue(), parcela.getId().getCadastroGeral(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getParcela());
        debitoParcela.ifPresent(e -> {
            if (parcela.getSituacaoAtual().getTipoSituacaoParcela() == TipoSituacaoParcela.RECURSO_ADMINISTRATIVO || parcela.getSituacaoAtual().getTipoSituacaoParcela() == TipoSituacaoParcela.SUBJUDICE) {
                SituacaoParcela novaSituacao = this.generateNovaSituacao(parcela, contencioso, opcoesExararDebito);
                e.setSituacaoDebito(novaSituacao);
                e.setDataSituacao(LocalDate.now());
                this.debitoParcelaService.save((EloEntity)e, null);
            }
        });
    }

    protected TipoEventoSituacaoParcelaEnum generateSituacao(Contencioso contencioso, OpcoesExararDebito opcoesExararDebito, ContenciosoDebitoParcela contenciosoDebitoParcela) {
        return contencioso.getInstancia() == 2L && opcoesExararDebito.equals((Object)OpcoesExararDebito.MANTER_DEBITO) ? TipoEventoSituacaoParcelaEnum.fromValue((Long)contenciosoDebitoParcela.getSituacaoFimPrimeiraInstancia().getId()) : TipoEventoSituacaoParcelaEnum.fromValue((Long)contenciosoDebitoParcela.getSituacaoDebito().getId());
    }

    protected SituacaoParcela generateNovaSituacao(ContenciosoDebitoParcela contenciosoDebitoParcela, Contencioso contencioso, OpcoesExararDebito opcoesExararDebito) {
        TipoEventoSituacaoParcelaEnum situacao = this.generateSituacao(contencioso, opcoesExararDebito, contenciosoDebitoParcela);
        return this.situacaoParcelaService.getNovaSituacaoParcela(situacao, contenciosoDebitoParcela.getSituacaoAtual());
    }

    protected void encerraContenciosoSeNenhumDebitoAguardaParecer(Contencioso contencioso) {
        if (contencioso.getDebitos().stream().noneMatch(e -> SituacaoContenciosoDebito.AGUARDANDOPARECER.equals((Object)e.getSituacao()))) {
            contencioso.setSituacao(ContenciosoSituacaoEnum.ENCERRADO);
        }
    }

    @Generated
    public AcaoExararAbstract(ContenciosoRepository contenciosoRepository, CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaService debitoParcelaService, SituacaoParcelaService situacaoParcelaService) {
        this.contenciosoRepository = contenciosoRepository;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoParcelaService = debitoParcelaService;
        this.situacaoParcelaService = situacaoParcelaService;
    }
}

