/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contencioso;

import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.enums.OpcoesExararDebito;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.contencioso.AcaoExararAbstract;
import br.com.elotech.tributos.service.contencioso.AcaoExararCancelarDebito;
import br.com.elotech.tributos.service.contencioso.AcaoExararManterDebito;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AcaoDeferir
extends AcaoExararAbstract
implements AcaoExararCancelarDebito,
AcaoExararManterDebito {
    protected AcaoDeferir(ContenciosoRepository contenciosoRepository, CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaService debitoParcelaService, SituacaoParcelaService situacaoParcelaService) {
        super(contenciosoRepository, cancelamentoDebitoService, debitoParcelaService, situacaoParcelaService);
    }

    public Contencioso exararCancelarDebito(ContenciosoDebitosExararDTO dto, Contencioso contencioso) {
        this.validaContenciosoEmAberto(contencioso);
        List contenciosoDebitosDTOSelected = dto.getDebitos().stream().filter(ContenciosoDebitoDTO::isSelected).collect(Collectors.toList());
        this.atualizaStatusDoContenciosoEParcelas(dto, contencioso, contenciosoDebitosDTOSelected, OpcoesExararDebito.CANCELAR_DEBITO);
        this.cancelaParcelaPorParcela(dto, contenciosoDebitosDTOSelected);
        this.encerraContenciosoSeNenhumDebitoAguardaParecer(contencioso);
        return (Contencioso)this.contenciosoRepository.save((Object)contencioso);
    }

    public Contencioso exararManterDebito(ContenciosoDebitosExararDTO dto, Contencioso contencioso) {
        this.validaContenciosoEmAberto(contencioso);
        List contenciosoDebitosDTOSelected = dto.getDebitos().stream().filter(ContenciosoDebitoDTO::isSelected).collect(Collectors.toList());
        this.atualizaStatusDoContenciosoEParcelas(dto, contencioso, contenciosoDebitosDTOSelected, OpcoesExararDebito.MANTER_DEBITO);
        this.encerraContenciosoSeNenhumDebitoAguardaParecer(contencioso);
        return (Contencioso)this.contenciosoRepository.save((Object)contencioso);
    }

    private void cancelaParcelaPorParcela(ContenciosoDebitosExararDTO dto, List<ContenciosoDebitoDTO> contenciosoDebitosDTOSelected) {
        CancelamentoParcelasFormDTO cancelamentoParcelasDTO = CancelamentoParcelasFormDTO.from((ContenciosoDebitosExararDTO)dto);
        contenciosoDebitosDTOSelected.forEach(debitoDTO -> debitoDTO.getParcelas().forEach(parcela -> {
            if (parcela.isSelected().booleanValue()) {
                CancelamentoDebitoParcelaDTO cancelamentoParcelaDTO = CancelamentoDebitoParcelaDTO.from((ContenciosoDebitoDTO)debitoDTO, (ContenciosoDebitoParcela)parcela);
                cancelamentoParcelasDTO.getParcelas().add(cancelamentoParcelaDTO);
            }
        }));
        if (SituacaoContenciosoDebito.DEFERIDO.equals((Object)dto.getParecer())) {
            this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamentoParcelasDTO);
        }
    }
}

