/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.request;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSConfigDTO;
import br.com.elotech.tributos.integration.cenprotms.generated.AutenticarRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.ConsultarTituloRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.DevedorConsultar;
import br.com.elotech.tributos.integration.cenprotms.generated.DividaConsultar;
import br.com.elotech.tributos.util.DateUtils;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public class CenprotMSRequestBuilder {
    private static final DateTimeFormatter DATE_FORMATTER = DateUtils.DATE_TIME_FORMATTER_FORMATO_BRASILEIRO_BARRAS;

    public ConsultarTituloRequestData criarConsultaRequest(Protesto protesto) {
        ConsultarTituloRequestData request = new ConsultarTituloRequestData();
        DevedorConsultar devedor = new DevedorConsultar();
        devedor.setDocumento(this.somenteNumeros(protesto.getDocumento().getPessoa().getCnpjCpf()));
        request.setDevedor(devedor);
        DividaConsultar divida = new DividaConsultar();
        divida.setNumero(String.format("%d/%d", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio()));
        divida.setNossoNumero(String.format("%d%d%d", protesto.getExercicio(), protesto.getDocumento().getTipoDocumento(), protesto.getDocumento().getDocumento()));
        divida.setEspecie("CDA");
        divida.setVencimento(protesto.getDocumento().getDataEmissao().format(DATE_FORMATTER));
        request.setDivida(divida);
        return request;
    }

    public static AutenticarRequestData criarAutenticarRequest(CenprotMSConfigDTO config) {
        AutenticarRequestData request = new AutenticarRequestData();
        request.setUsuario(config.getUsuario());
        request.setSenha(config.getSenha());
        request.setApresentante(config.getApresentante());
        return request;
    }

    private String somenteNumeros(String valor) {
        return Optional.ofNullable(valor).map(v -> v.replaceAll("\\D", "")).orElse(null);
    }
}

