/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.processor;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.enums.cenprot.SituacaoProtestoCenprotMS;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloResponseData;
import br.com.elotech.tributos.integration.cenprotms.generated.StatusResponse;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.cenprotms.builder.CenprotMSRetornoBuilder;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvioResponseProcessor
implements CenprotMSResponseProcessor<EnviarTituloResponseData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvioResponseProcessor.class);
    private static final CenprotMSRetornoBuilder retornoBuilder = new CenprotMSRetornoBuilder();
    private final ProtestoService protestoService;

    public CenprotMSRetornoDTO processar(Protesto protesto, EnviarTituloResponseData response) {
        if (response == null) {
            throw new EloValidationException("Resposta do CENPROTMS \u00e9 nula");
        }
        StatusResponse status = response.getResposta();
        CenprotMSRetornoDTO retorno = retornoBuilder.criarRetornoComStatus(protesto, status, (Object)response);
        if (status != null && status.isStatus()) {
            this.processarEnvioSucesso(protesto, retorno);
        } else {
            this.processarEnvioErro(protesto, status, retorno);
        }
        this.protestoService.save((EloEntity)protesto, null);
        return retorno;
    }

    public ProcessorType getTipo() {
        return ProcessorType.ENVIAR_TITULO;
    }

    private void processarEnvioSucesso(Protesto protesto, CenprotMSRetornoDTO retorno) {
        SituacaoProtestoCenprotMS novaSituacao = SituacaoProtestoCenprotMS.ENVIADO_CENPROT;
        protesto.setSituacaoCenprotMS(novaSituacao);
        retorno.setMensagem("T\u00edtulo enviado com sucesso para CENPROTMS");
        log.info("Protesto {} enviado com sucesso para CENPROTMS, situa\u00e7\u00e3o atualizada para: {}", (Object)protesto.getId(), (Object)novaSituacao.getDescricao());
    }

    private void processarEnvioErro(Protesto protesto, StatusResponse status, CenprotMSRetornoDTO retorno) {
        String mensagemErro = status != null && status.getMensagem() != null ? status.getMensagem() : "Erro desconhecido";
        String codigoErro = status != null && status.getCodigo() != null ? status.getCodigo() : "";
        retorno.setMensagem(String.format("Erro ao enviar para CENPROTMS [%s]: %s", codigoErro, mensagemErro));
        log.error("Erro ao enviar protesto {} para CENPROTMS [{}]: {}", new Object[]{protesto.getId(), codigoErro, mensagemErro});
    }

    @Generated
    public EnvioResponseProcessor(ProtestoService protestoService) {
        this.protestoService = protestoService;
    }
}

