/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.processor;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.enums.cenprot.SituacaoProtestoCenprotMS;
import br.com.elotech.tributos.integration.cenprotms.generated.ConsultarTituloResponseData;
import br.com.elotech.tributos.integration.cenprotms.generated.StatusResponse;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.cenprotms.CenprotMSStatusMapper;
import br.com.elotech.tributos.service.cenprotms.builder.CenprotMSRetornoBuilder;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ConsultaResponseProcessor
implements CenprotMSResponseProcessor<List<ConsultarTituloResponseData>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaResponseProcessor.class);
    private static final CenprotMSStatusMapper statusMapper = new CenprotMSStatusMapper();
    private static final CenprotMSRetornoBuilder retornoBuilder = new CenprotMSRetornoBuilder();
    private final ProtestoService protestoService;

    public CenprotMSRetornoDTO processar(Protesto protesto, List<ConsultarTituloResponseData> responseList) {
        if (!ConsultaResponseProcessor.isResponseListValida(responseList)) {
            return retornoBuilder.criarRetornoErro(protesto, "T\u00edtulo n\u00e3o encontrado no CENPROTMS");
        }
        ConsultarTituloResponseData response = responseList.getFirst();
        StatusResponse status = response.getResposta();
        CenprotMSRetornoDTO retorno = retornoBuilder.criarRetornoComStatus(protesto, status, (Object)response);
        if (status != null && status.isStatus()) {
            this.processarConsultaSucesso(protesto, response, retorno);
        }
        return retorno;
    }

    public ProcessorType getTipo() {
        return ProcessorType.CONSULTA_TITULO;
    }

    private void processarConsultaSucesso(Protesto protesto, ConsultarTituloResponseData response, CenprotMSRetornoDTO retorno) {
        retorno.setMensagem("Consulta realizada com sucesso");
        String statusCenprotMS = this.extrairStatusDaResposta(response);
        if (statusCenprotMS != null) {
            this.atualizarSituacaoSeNecessario(protesto, statusCenprotMS, retorno);
        }
    }

    private void atualizarSituacaoSeNecessario(Protesto protesto, String statusCenprotMS, CenprotMSRetornoDTO retorno) {
        SituacaoProtestoCenprotMS novaSituacao;
        SituacaoProtestoCenprotMS situacaoAtual = protesto.getSituacaoCenprotMS();
        if (statusMapper.deveAtualizarSituacao(situacaoAtual, novaSituacao = statusMapper.mapearStatusCenprotMS(statusCenprotMS))) {
            protesto.setSituacaoCenprotMS(novaSituacao);
            this.protestoService.save((EloEntity)protesto, null);
            String descricaoMudanca = statusMapper.obterDescricaoMudanca(situacaoAtual, novaSituacao);
            retorno.setMensagem(retorno.getMensagem() + " - " + descricaoMudanca);
        }
    }

    private String extrairStatusDaResposta(ConsultarTituloResponseData response) {
        if (response == null) {
            return null;
        }
        return response.getResposta().getCodigo();
    }

    public static boolean isResponseListValida(List<ConsultarTituloResponseData> responseList) {
        return responseList != null && !responseList.isEmpty();
    }

    @Generated
    public ConsultaResponseProcessor(ProtestoService protestoService) {
        this.protestoService = protestoService;
    }
}

