/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.client;

import br.com.elotech.tributos.exception.cenprot.CenprotMSConnectionException;
import br.com.elotech.tributos.integration.cenprotms.generated.ProtestoInterface;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenprotMSClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSClient.class);
    private static final Integer DEFAULT_TIMEOUT = 30000;
    private static final String SOAP_NAMESPACE = "http://grupobst.com.br/services";
    private static final String SERVICE_NAME = "services";
    private static final String TIMEOUT_PROPERTY_SUN_CONNECT = "com.sun.xml.ws.connect.timeout";
    private static final String TIMEOUT_PROPERTY_SUN_REQUEST = "com.sun.xml.ws.request.timeout";
    private static final String TIMEOUT_PROPERTY_JAVAX_CONNECTION = "javax.xml.ws.client.connectionTimeout";
    private static final String TIMEOUT_PROPERTY_JAVAX_RECEIVE = "javax.xml.ws.client.receiveTimeout";
    private ProtestoInterface protestoInterface;

    public void configurar(String wsdlUrl, Integer timeout) {
        if (wsdlUrl == null || wsdlUrl.isBlank()) {
            throw new IllegalArgumentException("WSDL URL n\u00e3o pode ser vazia");
        }
        Integer timeoutFinal = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.protestoInterface = this.inicializarCliente(wsdlUrl, timeoutFinal);
    }

    public ProtestoInterface getProtestoInterface() {
        if (this.protestoInterface == null) {
            throw new IllegalStateException("Cliente CENPROTMS n\u00e3o configurado");
        }
        return this.protestoInterface;
    }

    private ProtestoInterface inicializarCliente(String wsdlUrl, Integer timeout) {
        try {
            log.debug("Inicializando cliente SOAP CENPROTMS: {}", (Object)wsdlUrl);
            URL wsdl = URI.create(wsdlUrl).toURL();
            QName serviceName = new QName(SOAP_NAMESPACE, SERVICE_NAME);
            Service service = Service.create((URL)wsdl, (QName)serviceName);
            ProtestoInterface client = (ProtestoInterface)service.getPort(ProtestoInterface.class);
            this.configurarWebServiceClient(client, wsdlUrl, timeout);
            log.info("Cliente SOAP CENPROTMS inicializado com sucesso");
            return client;
        }
        catch (Exception e) {
            log.error("Erro ao inicializar cliente SOAP CENPROTMS", (Throwable)e);
            throw new CenprotMSConnectionException("Falha na inicializa\u00e7\u00e3o do cliente SOAP CENPROTMS", (Throwable)e);
        }
    }

    private void configurarWebServiceClient(ProtestoInterface client, String wsdlUrl, Integer timeout) {
        BindingProvider bindingProvider = (BindingProvider)client;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put(TIMEOUT_PROPERTY_SUN_CONNECT, timeout);
        requestContext.put(TIMEOUT_PROPERTY_SUN_REQUEST, timeout);
        requestContext.put(TIMEOUT_PROPERTY_JAVAX_CONNECTION, timeout);
        requestContext.put(TIMEOUT_PROPERTY_JAVAX_RECEIVE, timeout);
        String endpoint = wsdlUrl.replace("?wsdl", "");
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint);
    }
}

