/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.builder;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.integration.cenprotms.generated.StatusResponse;

public class CenprotMSRetornoBuilder {
    public CenprotMSRetornoDTO criarRetornoComStatus(Protesto protesto, StatusResponse status, Object dadosRetorno) {
        return CenprotMSRetornoDTO.builder().titulo(this.gerarDescricaoTitulo(protesto)).sucesso(status != null && status.isStatus()).status(status).dadosRetorno(dadosRetorno).mensagem(this.obterMensagem(status)).build();
    }

    public CenprotMSRetornoDTO criarRetornoErro(Protesto protesto, String mensagem) {
        return CenprotMSRetornoDTO.builder().titulo(this.gerarDescricaoTitulo(protesto)).sucesso(false).mensagem(mensagem).build();
    }

    private String gerarDescricaoTitulo(Protesto protesto) {
        return String.format("CDA %d/%d - Protesto %d/%d", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio(), protesto.getProtesto(), protesto.getExercicio());
    }

    private String obterMensagem(StatusResponse status) {
        if (status == null) {
            return "Resposta do CENPROTMS sem informa\u00e7\u00f5es de status";
        }
        if (status.isStatus()) {
            return "Opera\u00e7\u00e3o realizada com sucesso";
        }
        String codigo = status.getCodigo() != null ? status.getCodigo() : "SEM_CODIGO";
        String mensagem = status.getMensagem() != null ? status.getMensagem() : "Sem detalhes";
        return String.format("Erro [%s]: %s", codigo, mensagem);
    }
}

