/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.auth;

import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManager;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CenprotMSTokenManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSTokenManager.class);
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int TOKEN_BUFFER_HOURS = 1;
    private Optional<TokenData> currentTokenData = Optional.empty();

    public Optional<String> getValidToken() {
        return this.currentTokenData.filter(arg_0 -> this.isTokenValid(arg_0)).map(TokenData::getToken);
    }

    public void setToken(String token, String validadeString, String usuario) {
        if (token == null || token.isBlank()) {
            log.warn("Token vazio recebido, n\u00e3o armazenando");
            return;
        }
        LocalDateTime expiry = this.parseValidadeToken(validadeString);
        this.currentTokenData = Optional.of(TokenData.builder().token(token).expiry(expiry).usuario(usuario).build());
    }

    private boolean isTokenValid(TokenData tokenData) {
        return Optional.ofNullable(tokenData).map(TokenData::getExpiry).map(expiry -> expiry.minusHours(1L)).map(expiryWithBuffer -> LocalDateTime.now().isBefore((ChronoLocalDateTime<?>)expiryWithBuffer)).orElse(false);
    }

    private LocalDateTime parseValidadeToken(String validadeString) {
        return Optional.ofNullable(validadeString).map(String::trim).filter(s -> !s.isEmpty()).map(s -> {
            try {
                return LocalDateTime.parse(s, FORMATTER);
            }
            catch (DateTimeParseException e) {
                log.error("Erro ao parsear validade do token: '{}'", s, (Object)e);
                throw new IllegalArgumentException("Formato de data inv\u00e1lido: " + s, e);
            }
        }).orElseThrow(() -> new IllegalArgumentException("String de validade n\u00e3o pode ser vazia ou nula"));
    }

    public void clearToken() {
        this.currentTokenData = Optional.empty();
    }
}

