/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms.auth;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.cenprot.CenprotMSConfigDTO;
import br.com.elotech.tributos.integration.cenprotms.generated.AutenticarRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.AutenticarResponseData;
import br.com.elotech.tributos.integration.cenprotms.generated.StatusResponse;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManager;
import br.com.elotech.tributos.service.cenprotms.client.CenprotMSClient;
import br.com.elotech.tributos.service.cenprotms.request.CenprotMSRequestBuilder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CenprotMSAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSAuthService.class);
    private final ParametroGeralService parametroGeralService;

    public boolean isCenprotMSHabilitado() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CENPROTMS_HABILITADO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private void validateConfig() {
        if (!this.isCenprotMSHabilitado()) {
            throw new EloValidationException("CENPROTMS n\u00e3o est\u00e1 habilitado nos par\u00e2metros do sistema");
        }
    }

    private CenprotMSConfigDTO getConfig() {
        this.validateConfig();
        String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
        return CenprotMSConfigDTO.builder().wsdlUrl(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CENPROTMS_URL_WEBSERVICE, modulo)).usuario(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CENPROTMS_USUARIO, modulo)).senha(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CENPROTMS_SENHA, modulo)).apresentante(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CENPROTMS_APRESENTANTE, modulo)).timeout(this.parametroGeralService.getParamValueAsInteger(ParametroGeralEnum.CENPROTMS_TIMEOUT, modulo)).build();
    }

    public String obterTokenValido(CenprotMSClient client, CenprotMSTokenManager tokenManager) {
        return tokenManager.getValidToken().orElseGet(() -> this.autenticar(client, tokenManager));
    }

    public String autenticar(CenprotMSClient client, CenprotMSTokenManager tokenManager) {
        try {
            CenprotMSConfigDTO config = this.getConfig();
            log.debug("Iniciando autentica\u00e7\u00e3o CENPROTMS - Usu\u00e1rio: {}", (Object)config.getUsuario());
            client.configurar(config.getWsdlUrl(), config.getTimeout());
            AutenticarRequestData credenciais = CenprotMSRequestBuilder.criarAutenticarRequest((CenprotMSConfigDTO)config);
            AutenticarResponseData response = client.getProtestoInterface().autenticar(credenciais);
            return this.processarRespostaAutenticacao(response, config.getUsuario(), tokenManager);
        }
        catch (Exception e) {
            log.error("Erro na autentica\u00e7\u00e3o CENPROTMS", (Throwable)e);
            tokenManager.clearToken();
            throw new EloValidationException("Falha na autentica\u00e7\u00e3o com CENPROTMS: " + e.getMessage());
        }
    }

    private String processarRespostaAutenticacao(AutenticarResponseData response, String usuario, CenprotMSTokenManager tokenManager) {
        this.validateResponse(response);
        String token = response.getToken();
        String validade = response.getValidade();
        tokenManager.setToken(token, validade, usuario);
        log.info("Autentica\u00e7\u00e3o CENPROTMS realizada com sucesso");
        log.debug("Token: {}..., Validade: {}", (Object)token.substring(0, Math.min(10, token.length())), (Object)validade);
        return token;
    }

    private void validateResponse(AutenticarResponseData response) {
        if (response == null) {
            throw new EloValidationException("Resposta de autentica\u00e7\u00e3o inv\u00e1lida");
        }
        StatusResponse status = response.getResposta();
        if (status != null && !status.isStatus()) {
            String codigo = status.getCodigo() != null ? status.getCodigo() : "";
            String mensagem = status.getMensagem() != null ? status.getMensagem() : "Erro desconhecido";
            throw new EloValidationException(String.format("Autentica\u00e7\u00e3o CENPROTMS negada [%s]: %s", codigo, mensagem));
        }
        if (response.getToken() == null || response.getToken().isBlank()) {
            throw new EloValidationException("Token n\u00e3o retornado pela autentica\u00e7\u00e3o CENPROTMS");
        }
    }

    @Generated
    public CenprotMSAuthService(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }
}

