/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.enums.cenprot.TipoSistemaProtesto;
import br.com.elotech.tributos.service.ParametroProtestoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CenprotMSValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSValidationService.class);
    private final ParametroProtestoService parametroProtestoService;

    public void validarCenprotMSDisponivel() {
        TipoSistemaProtesto sistemaAtivo = this.parametroProtestoService.getSistemaProtestoAtivo();
        if (sistemaAtivo == TipoSistemaProtesto.CRA) {
            throw new EloValidationException("Sistema CRA est\u00e1 ativo. Desative o CRA antes de usar CENPROTMS.");
        }
        if (sistemaAtivo == TipoSistemaProtesto.NENHUM) {
            throw new EloValidationException("Nenhum sistema de protesto est\u00e1 ativo. Ative o CENPROTMS nos par\u00e2metros.");
        }
    }

    public void validarProtestoParaEnvio(Protesto protesto) {
        if (protesto == null) {
            throw new EloValidationException("Protesto \u00e9 obrigat\u00f3rio");
        }
        if (protesto.getDocumento() == null) {
            throw new EloValidationException(String.format("Protesto %d/%d n\u00e3o possui documento vinculado", protesto.getProtesto(), protesto.getExercicio()));
        }
        if (protesto.getDocumento().getDocumentoItemDividaAtivas().isEmpty()) {
            throw new EloValidationException(String.format("CDA %d/%d n\u00e3o possui itens de d\u00edvida ativa", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio()));
        }
        if (protesto.getDocumento().getDocumentoPessoas().isEmpty()) {
            throw new EloValidationException(String.format("CDA %d/%d n\u00e3o possui devedores", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio()));
        }
    }

    @Generated
    public CenprotMSValidationService(ParametroProtestoService parametroProtestoService) {
        this.parametroProtestoService = parametroProtestoService;
    }
}

