/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloResponseData;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSAuthService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManager;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManagerProvider;
import br.com.elotech.tributos.service.cenprotms.client.CenprotMSClient;
import br.com.elotech.tributos.service.cenprotms.client.CenprotMSClientProvider;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessorFactory;
import br.com.elotech.tributos.util.cenprot.CenprotMSTituloMapper;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CenprotMSEnvioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSEnvioService.class);
    private final CenprotMSAuthService authService;
    private final CenprotMSResponseProcessorFactory processorFactory;
    private final CenprotMSTituloMapper tituloMapper;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final CenprotMSClientProvider clientProvider;
    private final CenprotMSTokenManagerProvider tokenManagerProvider;

    public CenprotMSRetornoDTO enviarTitulo(Protesto protesto) {
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        return this.enviarTituloComCache(protesto, listas);
    }

    public CenprotMSRetornoDTO enviarTituloComCache(Protesto protesto, ListasNecessariasCalculaAcrescimoDTO listas) {
        log.info("Enviando t\u00edtulo para CENPROTMS - Protesto ID: {}", (Object)protesto.getId());
        if (Objects.nonNull(protesto.getSituacaoCenprotMS())) {
            throw new EloValidationException("Protesto j\u00e1 foi enviado para o sistema de protestos");
        }
        CenprotMSClient client = this.clientProvider.criarCliente();
        CenprotMSTokenManager tokenManager = this.tokenManagerProvider.criarTokenManager();
        try {
            String token = this.authService.obterTokenValido(client, tokenManager);
            EnviarTituloRequestData request = this.tituloMapper.toEnviarTituloRequest(protesto, listas);
            List responseList = client.getProtestoInterface().enviarTitulo(token, List.of(request));
            if (responseList == null || responseList.isEmpty()) {
                throw new EloValidationException("Resposta do CENPROTMS \u00e9 inv\u00e1lida");
            }
            CenprotMSResponseProcessor processor = this.processorFactory.obterProcessador(ProcessorType.ENVIAR_TITULO);
            CenprotMSRetornoDTO resultado = processor.processar(protesto, (Object)((EnviarTituloResponseData)responseList.getFirst()));
            log.info("Envio realizado com sucesso - Protesto ID: {}", (Object)protesto.getId());
            return resultado;
        }
        catch (Exception e) {
            log.error("Erro ao enviar t\u00edtulo para CENPROTMS - Protesto ID: {}", (Object)protesto.getId(), (Object)e);
            throw new EloValidationException("Falha ao enviar t\u00edtulo para CENPROTMS: " + e.getMessage());
        }
    }

    @Generated
    public CenprotMSEnvioService(CenprotMSAuthService authService, CenprotMSResponseProcessorFactory processorFactory, CenprotMSTituloMapper tituloMapper, CalculoAcrescimoService calculoAcrescimoService, CenprotMSClientProvider clientProvider, CenprotMSTokenManagerProvider tokenManagerProvider) {
        this.authService = authService;
        this.processorFactory = processorFactory;
        this.tituloMapper = tituloMapper;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.clientProvider = clientProvider;
        this.tokenManagerProvider = tokenManagerProvider;
    }
}

