/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cenprotms;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.integration.cenprotms.generated.ConsultarTituloRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.ConsultarTituloResponseData;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSAuthService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManager;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSTokenManagerProvider;
import br.com.elotech.tributos.service.cenprotms.client.CenprotMSClient;
import br.com.elotech.tributos.service.cenprotms.client.CenprotMSClientProvider;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessorFactory;
import br.com.elotech.tributos.service.cenprotms.request.CenprotMSRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CenprotMSConsultaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSConsultaService.class);
    private static final CenprotMSRequestBuilder requestBuilder = new CenprotMSRequestBuilder();
    private final CenprotMSAuthService authService;
    private final CenprotMSResponseProcessorFactory processorFactory;
    private final DiaUtilService diaUtilService;
    private final CenprotMSClientProvider clientProvider;
    private final CenprotMSTokenManagerProvider tokenManagerProvider;

    @Transactional
    public CenprotMSRetornoDTO consultarTitulo(Protesto protesto) {
        log.info("Consultando t\u00edtulo no CENPROTMS - Protesto ID: {}", (Object)protesto.getId());
        CenprotMSClient client = this.clientProvider.criarCliente();
        CenprotMSTokenManager tokenManager = this.tokenManagerProvider.criarTokenManager();
        return this.executarConsulta(protesto, client, tokenManager);
    }

    public CenprotMSRetornoDTO consultarTituloSemTransacao(Protesto protesto) {
        try {
            log.info("Consultando t\u00edtulo no CENPROTMS sem transa\u00e7\u00e3o - Protesto ID: {}", (Object)protesto.getId());
            CenprotMSClient client = this.clientProvider.criarCliente();
            CenprotMSTokenManager tokenManager = this.tokenManagerProvider.criarTokenManager();
            return this.executarConsulta(protesto, client, tokenManager);
        }
        catch (Exception e) {
            log.error("Erro ao consultar t\u00edtulo no CENPROTMS - Protesto ID: {}", (Object)protesto.getId(), (Object)e);
            return CenprotMSRetornoDTO.builder().titulo(this.gerarDescricaoTitulo(protesto)).sucesso(false).mensagem("Falha ao consultar t\u00edtulo no CENPROTMS: " + e.getMessage()).build();
        }
    }

    private CenprotMSRetornoDTO executarConsulta(Protesto protesto, CenprotMSClient client, CenprotMSTokenManager tokenManager) {
        try {
            String token = this.authService.obterTokenValido(client, tokenManager);
            ConsultarTituloRequestData request = requestBuilder.criarConsultaRequest(protesto);
            List responseList = client.getProtestoInterface().consultarTitulo(token, "S", "N", "N", List.of(request));
            CenprotMSResponseProcessor processor = this.processorFactory.obterProcessador(ProcessorType.CONSULTA_TITULO);
            CenprotMSRetornoDTO resultado = processor.processar(protesto, (Object)responseList);
            log.info("Consulta realizada com sucesso - Protesto ID: {}", (Object)protesto.getId());
            return resultado;
        }
        catch (Exception e) {
            log.error("Erro ao consultar t\u00edtulo no CENPROTMS - Protesto ID: {}", (Object)protesto.getId(), (Object)e);
            throw new EloValidationException("Falha ao consultar t\u00edtulo no CENPROTMS: " + e.getMessage());
        }
    }

    @Transactional
    public List<CenprotMSRetornoDTO> consultarTitulos(List<Protesto> protestos) {
        log.info("Consultando {} t\u00edtulos no CENPROTMS", (Object)protestos.size());
        CenprotMSClient client = this.clientProvider.criarCliente();
        CenprotMSTokenManager tokenManager = this.tokenManagerProvider.criarTokenManager();
        try {
            String token = this.authService.obterTokenValido(client, tokenManager);
            List<ConsultarTituloRequestData> requests = protestos.stream().map(arg_0 -> ((CenprotMSRequestBuilder)requestBuilder).criarConsultaRequest(arg_0)).toList();
            List responseList = client.getProtestoInterface().consultarTitulo(token, "S", "N", "N", requests);
            return this.processarRespostasLote(protestos, responseList);
        }
        catch (Exception e) {
            log.error("Erro ao consultar t\u00edtulos em lote no CENPROTMS", (Throwable)e);
            return this.consultarIndividualmente(protestos);
        }
    }

    private List<CenprotMSRetornoDTO> processarRespostasLote(List<Protesto> protestos, List<ConsultarTituloResponseData> responseList) {
        ArrayList<CenprotMSRetornoDTO> retornos = new ArrayList<CenprotMSRetornoDTO>();
        CenprotMSResponseProcessor processor = this.processorFactory.obterProcessador(ProcessorType.CONSULTA_TITULO);
        for (int i = 0; i < protestos.size() && i < responseList.size(); ++i) {
            List<ConsultarTituloResponseData> singleResponse = List.of(responseList.get(i));
            CenprotMSRetornoDTO retorno = processor.processar(protestos.get(i), singleResponse);
            retornos.add(retorno);
        }
        log.info("Consultados {} t\u00edtulos no CENPROTMS com sucesso", (Object)retornos.size());
        return retornos;
    }

    private List<CenprotMSRetornoDTO> consultarIndividualmente(List<Protesto> protestos) {
        return protestos.stream().map(arg_0 -> this.consultarTituloSemTransacao(arg_0)).toList();
    }

    private String gerarDescricaoTitulo(Protesto protesto) {
        return String.format("CDA %d/%d - Protesto %d/%d", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio(), protesto.getProtesto(), protesto.getExercicio());
    }

    @Generated
    public CenprotMSConsultaService(CenprotMSAuthService authService, CenprotMSResponseProcessorFactory processorFactory, DiaUtilService diaUtilService, CenprotMSClientProvider clientProvider, CenprotMSTokenManagerProvider tokenManagerProvider) {
        this.authService = authService;
        this.processorFactory = processorFactory;
        this.diaUtilService = diaUtilService;
        this.clientProvider = clientProvider;
        this.tokenManagerProvider = tokenManagerProvider;
    }
}

