/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import br.com.elotech.tributos.repository.simam.MovimentacaoMensalCustomRepositoryImpl;
import br.com.elotech.tributos.service.RetencaoContabilService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MovimentacaoMensalJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final MovimentacaoMensalCustomRepositoryImpl movimentacaoMensalCustomRepository;
    @Qualifier(value="movimentacaoMensalBatchJob")
    private final Job movimentacaoMensalBatchJob;
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;
    private final RetencaoContabilService retencaoContabilService;

    public MovimentacaoMensalJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, Job movimentacaoMensalBatchJob, MovimentacaoMensalCustomRepositoryImpl movimentacaoMensalCustomRepository, ImplantacaoSaldoRepository implantacaoSaldoRepository, RetencaoContabilService retencaoContabilService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.movimentacaoMensalBatchJob = movimentacaoMensalBatchJob;
        this.movimentacaoMensalCustomRepository = movimentacaoMensalCustomRepository;
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
        this.retencaoContabilService = retencaoContabilService;
    }

    public JobExecution startJob(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio, boolean substituirCargaExistente) {
        this.validaSeExisteJobNaoFinalizadoComMesmoFiltro(dataInicial, dataFinal, entidade, exercicio);
        this.retencaoContabilService.validaParametroLeiAtoRetencao();
        if (substituirCargaExistente) {
            this.movimentacaoMensalCustomRepository.clearMovimentacao(entidade, dataInicial, dataFinal);
        }
        JobParameters jobParameters = this.createJobParameter(dataInicial, dataFinal, entidade, exercicio, this.resolveIdControle(dataInicial, exercicio));
        return this.startMovimentacaoMensalJob(jobParameters);
    }

    private Long resolveIdControle(LocalDate dataInicial, Long exercicio) {
        return Month.JANUARY.equals(dataInicial.getMonth()) ? this.implantacaoSaldoRepository.findLastIdByExercicio(exercicio) : null;
    }

    private void validaSeExisteJobNaoFinalizadoComMesmoFiltro(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio) {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_MOVIMENTACAO_MENSAL.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))) && entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
    }

    private JobParameters createJobParameter(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio, Long idControleImplantacaoSaldo) {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial));
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addDate("dataReferencia", new Date());
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("idControle", idControleImplantacaoSaldo);
        return jobParametersBuilder.toJobParameters();
    }

    private JobExecution startMovimentacaoMensalJob(JobParameters parameters) {
        try {
            return this.jobLauncher.run(this.movimentacaoMensalBatchJob, parameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new EloValidationException("Job Movimenta\u00e7\u00e3o Mensal j\u00e1 est\u00e1 sendo executado");
        }
        catch (JobRestartException e) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel reiniciar o Job Movimenta\u00e7\u00e3o Mensal");
        }
        catch (JobParametersInvalidException e) {
            throw new EloValidationException("Par\u00e2metros para o Job Movimenta\u00e7\u00e3o Mensal est\u00e1 inv\u00e1lido. Verifique!");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reinicicar o Job Movimenta\u00e7\u00e3o Mensal, pois foi conclu\u00eddo com sucesso");
        }
    }
}

