/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ImplantacaoSaldoMovimentacaoMensalJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    @Qualifier(value="implantacaoSaldoMovimentacaoMensalBatchJob")
    private final Job implantacaoSaldoMovimentacaoMensalBatchJob;
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;

    public JobExecution startJob(Long exercicio, Long entidade) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL.getTipo()).stream().anyMatch(job -> entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        Long idControle = this.implantacaoSaldoRepository.findLastIdByExercicio(exercicio);
        if ((long)idControle.compareTo(0L) == 0L) {
            throw new EloValidationException(String.format("\u00c9 necess\u00e1rio gerar os dados para implanta\u00e7\u00e3o de saldo do exerc\u00edcio %d.", exercicio));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addString("implantacaoSaldo", "true");
        jobParametersBuilder.addLong("idControle", idControle);
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.implantacaoSaldoMovimentacaoMensalBatchJob, jobParametersBuilder.toJobParameters());
    }

    @Generated
    public ImplantacaoSaldoMovimentacaoMensalJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, Job implantacaoSaldoMovimentacaoMensalBatchJob, ImplantacaoSaldoRepository implantacaoSaldoRepository) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.implantacaoSaldoMovimentacaoMensalBatchJob = implantacaoSaldoMovimentacaoMensalBatchJob;
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
    }
}

