/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.protesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.GerarProtestoRemessaDTO;
import br.com.elotech.tributos.enums.cenprot.TipoSistemaProtesto;
import br.com.elotech.tributos.service.ParametroProtestoService;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.ProtestoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GerarProtestoRemessaJobStarter {
    private static final String ID_PROTESTO_REMESSA = "idProtestoRemessa";
    private static final String GERAR_PROTESTO_REMESSA_DTO = "gerarProtestoRemessaDTO";
    private final ObjectMapper objectMapper;
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job gerarProtestoRemessaBatchJob;
    private final ProtestoRemessaService protestoRemessaService;
    private final ProtestoService protestoService;
    private final ParametroProtestoService parametroProtestoService;

    public GerarProtestoRemessaJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="gerarProtestoRemessaBatchJob") Job gerarProtestoRemessaBatchJob, ProtestoRemessaService protestoRemessaService, ProtestoService protestoService, ParametroProtestoService parametroProtestoService) {
        this.objectMapper = objectMapper;
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.gerarProtestoRemessaBatchJob = gerarProtestoRemessaBatchJob;
        this.protestoRemessaService = protestoRemessaService;
        this.protestoService = protestoService;
        this.parametroProtestoService = parametroProtestoService;
    }

    public JobExecution startJob(GerarProtestoRemessaDTO gerarProtestoRemessaDTO) {
        this.validarCRADisponivel();
        this.protestoService.validateProtestosParaGerarRemessa(gerarProtestoRemessaDTO);
        String jobParamterGerarProtestoRemessaDTO = this.getStringFrom(gerarProtestoRemessaDTO);
        this.validateJobRunningWith(jobParamterGerarProtestoRemessaDTO);
        try {
            JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
            jobParametersBuilder.addLong(ID_PROTESTO_REMESSA, this.protestoRemessaService.createAndSave().getId());
            jobParametersBuilder.addString(GERAR_PROTESTO_REMESSA_DTO, jobParamterGerarProtestoRemessaDTO);
            return this.jobLauncher.run(this.gerarProtestoRemessaBatchJob, jobParametersBuilder.toJobParameters());
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao iniciar job de gera\u00e7\u00e3o da remessa de protestos para o CRA. " + e.getMessage());
        }
    }

    private String getStringFrom(GerarProtestoRemessaDTO gerarProtestoRemessaDTO) {
        try {
            return this.objectMapper.writeValueAsString((Object)gerarProtestoRemessaDTO);
        }
        catch (JsonProcessingException jpe) {
            throw new EloValidationException("Erro ao converter objeto em string. " + jpe.getMessage());
        }
    }

    private void validateJobRunningWith(String jobParamterGerarProtestoRemessaDTO) {
        boolean hasJobRunning = this.jobExplorer.findRunningJobExecutions(JobType.GERAR_PROTESTO_REMESSA.getTipo()).stream().anyMatch(jobExecution -> Objects.equals(jobParamterGerarProtestoRemessaDTO, jobExecution.getJobParameters().getString(GERAR_PROTESTO_REMESSA_DTO)));
        if (hasJobRunning) {
            throw new EloValidationException("J\u00e1 existe uma gera\u00e7\u00e3o de remessa de protesto em execu\u00e7\u00e3o para os protestos selecionados.");
        }
    }

    private void validarCRADisponivel() {
        TipoSistemaProtesto sistemaAtivo = this.parametroProtestoService.getSistemaProtestoAtivo();
        if (sistemaAtivo == TipoSistemaProtesto.CENPROTMS) {
            throw new EloValidationException("Sistema CENPROTMS est\u00e1 ativo. Desative o CENPROTMS antes de usar CRA.");
        }
    }
}

