/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.JobType;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SimulacaoCalculoJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job simulacaoCalculoBatchJob;
    private final CalculoService calculoService;

    public SimulacaoCalculoJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="simulacaoCalculoBatchJob") Job simulacaoCalculoBatchJob, CalculoService calculoService) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.simulacaoCalculoBatchJob = simulacaoCalculoBatchJob;
        this.calculoService = calculoService;
    }

    public JobExecution startJob(Long idCalculo, String filtroCadastroBuilt) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        if (this.existsJobWithSameIdCalculo(idCalculo, JobType.SIMULACAO_CALCULO).booleanValue()) {
            throw new EloValidationException(String.format("A simula\u00e7\u00e3o do c\u00e1lculo %d j\u00e1 est\u00e1 em processamento.", idCalculo));
        }
        if (this.existsJobWithSameIdCalculo(idCalculo, JobType.GERACAO_DEBITO_CALCULO).booleanValue()) {
            throw new EloValidationException(String.format("O c\u00e1lculo %s j\u00e1 possui outra tarefa de gera\u00e7\u00e3o de d\u00e9bitos em processamento.", idCalculo));
        }
        Calculo calculo = this.calculoService.findCalculoById(idCalculo);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idCalculo", idCalculo);
        jobParametersBuilder.addString("filtroCadastro", filtroCadastroBuilt);
        jobParametersBuilder.addDate("data", new Date());
        jobParametersBuilder.addString("tipoDivida", calculo.getTipoDivida().getCodigo());
        return this.jobLauncher.run(this.simulacaoCalculoBatchJob, jobParametersBuilder.toJobParameters());
    }

    private Boolean existsJobWithSameIdCalculo(Long idCalculo, JobType jobType) {
        return this.jobExplorer.findRunningJobExecutions(jobType.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroIdCalculo = jobExecution.getJobParameters().getLong("idCalculo");
            return idCalculo.equals(parametroIdCalculo);
        });
    }
}

