/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.service.ContextService;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GeracaoDebitoCalculoJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job geracaoDebitoCalculoBatchJob;
    private final CalculoService calculoService;
    private final ContextService contextService;

    public GeracaoDebitoCalculoJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="geracaoDebitoCalculoBatchJob") Job geracaoDebitoCalculoBatchJob, CalculoService calculoService, ContextService contextService) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.geracaoDebitoCalculoBatchJob = geracaoDebitoCalculoBatchJob;
        this.calculoService = calculoService;
        this.contextService = contextService;
    }

    public JobExecution startJob(Long idCalculo) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        if (this.existsJobWithSameIdCalculo(idCalculo, JobType.GERACAO_DEBITO_CALCULO).booleanValue()) {
            throw new EloValidationException(String.format("A gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d j\u00e1 est\u00e1 em processamento.", idCalculo));
        }
        if (this.existsJobWithSameIdCalculo(idCalculo, JobType.SIMULACAO_CALCULO).booleanValue()) {
            throw new EloValidationException(String.format("O c\u00e1lculo %s j\u00e1 possui outra tarefa de simula\u00e7\u00e3o de c\u00e1lculo em processamento.", idCalculo));
        }
        Calculo calculo = this.calculoService.updateCalculoParaGerarDebitos(idCalculo);
        Long entidade = this.contextService.getEntidadePrincipal();
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idCalculo", calculo.getId());
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.geracaoDebitoCalculoBatchJob, jobParametersBuilder.toJobParameters());
    }

    private Boolean existsJobWithSameIdCalculo(Long idCalculo, JobType jobType) {
        return this.jobExplorer.findRunningJobExecutions(jobType.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroIdCalculo = jobExecution.getJobParameters().getLong("idCalculo");
            return idCalculo.equals(parametroIdCalculo);
        });
    }
}

