/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import br.com.elotech.tributos.service.edicaoemmassa.EdicaoEmMassaImobiliarioService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;

@Service
public class EdicaoEmMassaJobStarter {
    private final JobExplorer jobExplorer;
    private final Job edicaoEmMassaBatchJob;
    private final JobLauncher jobLauncher;
    private final ObjectMapper objectMapper;
    private final EdicaoEmMassaImobiliarioService edicaoEmMassaImobiliarioService;

    public JobExecution startJob(EdicaoEmMassaFiltroDTO filtro, TipoEdicaoEmMassa tipo) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        if (filtro.getCamposValues().isEmpty()) {
            throw new EloValidationException("Nenhum campo foi informado para a altera\u00e7\u00e3o em massa.");
        }
        String filtroString = this.objectMapper.writeValueAsString((Object)filtro);
        this.validateExisteJobComMesmosParametros(filtro, tipo);
        this.edicaoEmMassaImobiliarioService.validateCamposParaEdicao(filtro);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addString("filtro", filtroString);
        jobParametersBuilder.addString("tipo", tipo.toString());
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.edicaoEmMassaBatchJob, jobParametersBuilder.toJobParameters());
    }

    protected void validateExisteJobComMesmosParametros(EdicaoEmMassaFiltroDTO filtro, TipoEdicaoEmMassa tipo) {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.EDICAO_EM_MASSA.getTipo()).stream().anyMatch(jobExecution -> {
            try {
                String parametroTipoString = jobExecution.getJobParameters().getString("tipo");
                String parametroFiltroString = jobExecution.getJobParameters().getString("filtro");
                EdicaoEmMassaFiltroDTO parametroFiltro = (EdicaoEmMassaFiltroDTO)this.objectMapper.readValue(parametroFiltroString, EdicaoEmMassaFiltroDTO.class);
                TipoEdicaoEmMassa parametroTipo = TipoEdicaoEmMassa.valueOf((String)parametroTipoString);
                return parametroTipo.equals((Object)tipo) && parametroFiltro.equals((Object)filtro);
            }
            catch (JsonProcessingException e) {
                throw new EloValidationException("Erro ao converter JSON em um objeto. " + e.getMessage());
            }
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException("J\u00e1 existe um job de altera\u00e7\u00e3o em massa em execu\u00e7\u00e3o com os mesmos par\u00e2metros.");
        }
    }

    @Generated
    public EdicaoEmMassaJobStarter(JobExplorer jobExplorer, Job edicaoEmMassaBatchJob, JobLauncher jobLauncher, ObjectMapper objectMapper, EdicaoEmMassaImobiliarioService edicaoEmMassaImobiliarioService) {
        this.jobExplorer = jobExplorer;
        this.edicaoEmMassaBatchJob = edicaoEmMassaBatchJob;
        this.jobLauncher = jobLauncher;
        this.objectMapper = objectMapper;
        this.edicaoEmMassaImobiliarioService = edicaoEmMassaImobiliarioService;
    }
}

