/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ContenciosoRecalculoBoletoJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job contenciosoRecalculoBoletoBatchJob;
    private final ObjectMapper objectMapper;

    public ContenciosoRecalculoBoletoJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="contenciosoRecalculoBoletoBatchJob") Job contenciosoRecalculoBoletoBatchJob, ObjectMapper objectMapper) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.contenciosoRecalculoBoletoBatchJob = contenciosoRecalculoBoletoBatchJob;
        this.objectMapper = objectMapper;
    }

    public JobExecution startJob(Long idContencioso, List<Long> debitosRecalculo, List<Long> formasDePagamento, Boolean gerarCarne) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, IOException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.CONTENCIOSO_RECALCULO_BOLETO.getTipo()).stream().anyMatch(jobExecution -> {
            Long id = jobExecution.getJobParameters().getLong("idContencioso");
            return id.equals(idContencioso);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("J\u00e1 existe uma gera\u00e7\u00e3o de boleto/carn\u00ea para o contencioso %d.", idContencioso));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idContencioso", idContencioso);
        jobParametersBuilder.addString("debitosRecalculo", this.objectMapper.writeValueAsString(debitosRecalculo));
        jobParametersBuilder.addString("formasDePagamento", this.objectMapper.writeValueAsString(formasDePagamento));
        jobParametersBuilder.addString("gerarCarne", gerarCarne.toString());
        String nomeArquivo = String.format("boleto-carne-%d-%s.zip", idContencioso, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        jobParametersBuilder.addString("nomeArquivo", nomeArquivo);
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.contenciosoRecalculoBoletoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

