/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoDebito;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoHistorico;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoHistoricoId;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoCancelamentoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoDTO;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoRecursoAdministrativo;
import br.com.elotech.tributos.repository.autoinfracao.AutoInfracaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoDebitoService;
import br.com.elotech.tributos.service.contencioso.ContenciosoHistoricoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import br.com.elotech.tributos.service.projeto.ProjetoService;
import br.com.elotech.tributos.util.ContenciosoUtils;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AutoInfracaoService
extends CrudService<AutoInfracao, Long> {
    private final ContenciosoHistoricoService contenciosoHistoricoService;
    private final CadastroGeralService cadastroGeralService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final AutoInfracaoDebitoService autoInfracaoDebitoService;
    private final AutoInfracaoRepository autoInfracaoRepository;
    private final ProjetoService projetoService;
    private final ContextService contextService;

    public AutoInfracaoDTO findDto(Long id) {
        AutoInfracao autoInfracao = (AutoInfracao)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", id)));
        AutoInfracaoDTO dto = AutoInfracaoDTO.from((AutoInfracao)autoInfracao);
        if (Objects.nonNull(autoInfracao.getContencioso())) {
            dto.setHistoricoContencioso(this.contenciosoHistoricoService.findByContenciosoId(autoInfracao.getContencioso().getId()));
        }
        return dto;
    }

    public AutoInfracao save(AutoInfracaoDTO dto) {
        CadastroGeral cadastroGeral = this.resolveCadastroGeral(dto.getCadastroGeral());
        Projeto projeto = this.resolveProjeto(dto.getIdProjeto());
        AutoInfracao auto = dto.toEntity();
        if (auto.getValorTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException("O valor total do auto deve ser maior que zero.");
        }
        auto.setEntidade(this.contextService.getEntidadePrincipal());
        auto.setData(LocalDate.now());
        auto.setDataSituacao(LocalDateTime.now());
        auto.setSituacao(SituacaoAutoInfracao.NORMAL);
        auto.setSituacaoRecursoAdministrativo1(SituacaoRecursoAdministrativo.DEFERIDO);
        auto.setSituacaoRecursoAdministrativo2(SituacaoRecursoAdministrativo.DEFERIDO);
        auto.setUsuario(SecurityUtils.getUserAise());
        auto.setCadastroGeral(cadastroGeral);
        auto.setPessoa(cadastroGeral.getPessoa());
        auto.setProjeto(projeto);
        AutoInfracaoHistorico historico = this.createHistorico(auto, SituacaoAutoInfracao.NORMAL);
        auto.getHistoricos().add(historico);
        return (AutoInfracao)this.save((EloEntity)auto, null);
    }

    public AutoInfracao update(Long idAuto, AutoInfracaoDTO dto) {
        AutoInfracao autoInfracao = (AutoInfracao)this.findById((Serializable)idAuto).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", idAuto)));
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel editar o auto de infra\u00e7\u00e3o %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        boolean deveCancelarDebitoAnterior = Objects.nonNull(autoInfracao.getDebito()) && dto.alterouValoresDebito(autoInfracao);
        autoInfracao = dto.toEntity(autoInfracao);
        if (deveCancelarDebitoAnterior) {
            if (Objects.isNull(dto.getMotivoDeducaoAlteracaoDebito())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel editar o auto de infra\u00e7\u00e3o %d/%d pois \u00e9 necess\u00e1rio informar o motivo de dedu\u00e7\u00e3o ao alterar os valores um auto com d\u00e9bito gerado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
            }
            MotivoDeducao motivoEstorno = this.resolveMotivoDeducao(dto.getMotivoDeducaoAlteracaoDebito());
            this.autoInfracaoDebitoService.cancelarDebitoAutoInfracao(autoInfracao, motivoEstorno, null);
            Debito debito = this.autoInfracaoDebitoService.gerarDebito(autoInfracao, Boolean.FALSE);
            autoInfracao.setDebito(debito);
            autoInfracao.setIdDebito(debito.getId());
            autoInfracao.getDebitos().add(new AutoInfracaoDebito(autoInfracao, debito));
            autoInfracao.setSituacao(SituacaoAutoInfracao.REVISADO);
            autoInfracao.setDataSituacao(LocalDateTime.now());
            autoInfracao.getHistoricos().add(this.createHistorico(autoInfracao, SituacaoAutoInfracao.REVISADO));
        }
        return (AutoInfracao)this.save((EloEntity)autoInfracao, null);
    }

    private AutoInfracaoHistorico createHistorico(AutoInfracao auto, SituacaoAutoInfracao situacao) {
        AutoInfracaoHistoricoId id = new AutoInfracaoHistoricoId();
        id.setSequencia(auto.getProximaSequenciaHistorico());
        AutoInfracaoHistorico historico = new AutoInfracaoHistorico();
        historico.setId(id);
        historico.setAutoInfracao(auto);
        historico.setData(LocalDateTime.now());
        historico.setSituacao(situacao);
        historico.setUsuario(SecurityUtils.getUserAise());
        historico.setHora(DateUtils.localDateTimeToHoraFormatoBrasileiro((LocalDateTime)historico.getData()));
        return historico;
    }

    private CadastroGeral resolveCadastroGeral(CadastroGeralResumidoDTO cadastroResumido) {
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(cadastroResumido.getTipoCadastro(), cadastroResumido.getCadastroGeral()).orElseThrow(() -> new CadastroNaoEncontradoException(cadastroResumido.getTipoCadastro(), cadastroResumido.getCadastroGeral()));
    }

    private Projeto resolveProjeto(ProjetoPK id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return (Projeto)this.projetoService.findById((Serializable)id).orElseThrow(() -> new ProjetoNotFoundException(id));
    }

    public AutoInfracao gerarDebito(Long idAuto) {
        AutoInfracao autoInfracao;
        Debito debito = this.autoInfracaoDebitoService.gerarDebito(autoInfracao, Boolean.valueOf(!this.contenciosoCancelouDebito(autoInfracao = (AutoInfracao)this.findById((Serializable)idAuto).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", idAuto))))));
        autoInfracao.setDebito(debito);
        autoInfracao.setIdDebito(debito.getId());
        autoInfracao.getDebitos().add(new AutoInfracaoDebito(autoInfracao, debito));
        return (AutoInfracao)this.save((EloEntity)autoInfracao, null);
    }

    public void addNewDebitoWithEntityManager(Long idOldDebito, Long idNewDebito) {
        if (Objects.isNull(idOldDebito)) {
            return;
        }
        this.findByDebito(idOldDebito).ifPresent(autoInfracao -> {
            Debito debito = (Debito)this.getEm().getReference(Debito.class, (Object)idNewDebito);
            autoInfracao.setDebito(debito);
            autoInfracao.setIdDebito(idNewDebito);
            autoInfracao.getDebitos().add(new AutoInfracaoDebito(autoInfracao, debito));
            this.save((EloEntity)autoInfracao, null);
        });
    }

    private boolean contenciosoCancelouDebito(AutoInfracao autoInfracao) {
        if (Objects.isNull(autoInfracao.getContencioso())) {
            return Boolean.FALSE;
        }
        return ContenciosoUtils.isDeferido((List)this.contenciosoHistoricoService.findByContenciosoId(autoInfracao.getContencioso().getId()));
    }

    public AutoInfracao cancelarAutoInfracao(Long id, AutoInfracaoCancelamentoDTO cancelamentoDTO) {
        AutoInfracao autoInfracao = (AutoInfracao)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", id)));
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel cancelar o auto de infra\u00e7\u00e3o %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (autoInfracao.getSituacao().isRecurso()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel cancelar o auto de infra\u00e7\u00e3o %d/%d pois ele se encontra em recurso administrativo.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        MotivoDeducao motivoCancelamento = this.resolveMotivoDeducao(cancelamentoDTO.getMotivoCancelamento());
        if (Objects.nonNull(autoInfracao.getDebito())) {
            this.autoInfracaoDebitoService.cancelarDebitoAutoInfracao(autoInfracao, motivoCancelamento, cancelamentoDTO.getObservacao());
        }
        autoInfracao.setSituacao(SituacaoAutoInfracao.CANCELADO);
        autoInfracao.setDataSituacao(LocalDateTime.now());
        autoInfracao.setIdProcessoCancelamento(cancelamentoDTO.getNumeroProcesso());
        autoInfracao.setExercicioCancelamento(cancelamentoDTO.getExercicioProcesso());
        autoInfracao.setMotivoCancelamento(motivoCancelamento);
        autoInfracao.setObservacaoCancelamento(cancelamentoDTO.getObservacao());
        autoInfracao.setProcessoSeiCancelamento(cancelamentoDTO.getProcessoSei());
        autoInfracao.getHistoricos().add(this.createHistorico(autoInfracao, SituacaoAutoInfracao.CANCELADO));
        return (AutoInfracao)this.save((EloEntity)autoInfracao, null);
    }

    private MotivoDeducao resolveMotivoDeducao(Long motivoDeducao) {
        return (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)motivoDeducao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o motivo dedu\u00e7\u00e3o %d.", motivoDeducao)));
    }

    public Boolean validaAlteracaoValores(Long idAuto, @Valid AutoInfracaoDTO dto) {
        AutoInfracao autoInfracao = (AutoInfracao)this.findById((Serializable)idAuto).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", idAuto)));
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel editar o auto de infra\u00e7\u00e3o %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        return Objects.nonNull(autoInfracao.getDebito()) && dto.alterouValoresDebito(autoInfracao);
    }

    private void setSituacaoAutoInfracaoByInstancia(Contencioso contencioso, AutoInfracao autoInfracao) {
        if (contencioso.getInstancia() == 2L) {
            autoInfracao.setSituacao(SituacaoAutoInfracao.RECURSO_ADMINISTRATIVO_2);
        } else {
            autoInfracao.setSituacao(SituacaoAutoInfracao.RECURSO_ADMINISTRATIVO_1);
        }
    }

    private void setSituacaoHistoricoAutoIngracaoByInstancia(Contencioso contencioso, AutoInfracao autoInfracao) {
        if (contencioso.getInstancia() == 2L) {
            autoInfracao.getHistoricos().add(this.createHistorico(autoInfracao, SituacaoAutoInfracao.RECURSO_ADMINISTRATIVO_2));
        } else {
            autoInfracao.getHistoricos().add(this.createHistorico(autoInfracao, SituacaoAutoInfracao.RECURSO_ADMINISTRATIVO_1));
        }
    }

    public AutoInfracao vincularContencioso(Long idAutoInfracao, Contencioso contencioso) {
        AutoInfracao autoInfracao = (AutoInfracao)this.findById((Serializable)idAutoInfracao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", idAutoInfracao)));
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel vincular o contencioso ao auto %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        autoInfracao.setContencioso(contencioso);
        this.setSituacaoAutoInfracaoByInstancia(contencioso, autoInfracao);
        autoInfracao.setDataSituacao(LocalDateTime.now());
        this.setSituacaoHistoricoAutoIngracaoByInstancia(contencioso, autoInfracao);
        return (AutoInfracao)this.save((EloEntity)autoInfracao, null);
    }

    public Optional<AutoInfracao> atualizarAutoAposExararContencioso(Contencioso contenciosoSaved, SituacaoContenciosoDebito parecer, Boolean cancelouDebito) {
        return this.autoInfracaoRepository.findByContencioso(contenciosoSaved).map(autoInfracao -> {
            autoInfracao.setSituacaoRecursoAdministrativo1(SituacaoRecursoAdministrativo.from((SituacaoContenciosoDebito)parecer));
            autoInfracao.setDataSituacao(LocalDateTime.now());
            autoInfracao.setSituacao(SituacaoAutoInfracao.NORMAL);
            autoInfracao.getHistoricos().add(this.createHistorico(autoInfracao, SituacaoAutoInfracao.NORMAL));
            if (cancelouDebito.booleanValue()) {
                autoInfracao.setDebito(null);
            }
            return (AutoInfracao)this.save((EloEntity)autoInfracao, null);
        });
    }

    public Optional<AutoInfracao> findByDebito(Long idDebito) {
        return this.autoInfracaoRepository.findByDebito(idDebito);
    }

    @Generated
    public AutoInfracaoService(ContenciosoHistoricoService contenciosoHistoricoService, CadastroGeralService cadastroGeralService, MotivoDeducaoService motivoDeducaoService, AutoInfracaoDebitoService autoInfracaoDebitoService, AutoInfracaoRepository autoInfracaoRepository, ProjetoService projetoService, ContextService contextService) {
        this.contenciosoHistoricoService = contenciosoHistoricoService;
        this.cadastroGeralService = cadastroGeralService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.autoInfracaoDebitoService = autoInfracaoDebitoService;
        this.autoInfracaoRepository = autoInfracaoRepository;
        this.projetoService = projetoService;
        this.contextService = contextService;
    }
}

