/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoDebito;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoPenalidade;
import br.com.elotech.tributos.domain.autoinfracao.NotificacaoFiscalizacao;
import br.com.elotech.tributos.domain.autoinfracao.TipoAutoInfracao;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import br.com.elotech.tributos.repository.autoinfracao.AutoInfracaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoDebitoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AutoInfracaoDebitoService {
    private final AutoInfracaoRepository autoInfracaoRepository;
    private final GeraDebitoService geraDebitoService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final DebitoService debitoService;
    private final ContextService contextService;
    private final ParcelamentoService parcelamentoService;
    private final DebitoObservacaoService debitoObservacaoService;

    public Debito gerarDebito(AutoInfracao autoInfracao, Boolean validaDebitoExistente) {
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o d\u00e9bito para o auto de infra\u00e7\u00e3o %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (validaDebitoExistente.booleanValue() && (Objects.nonNull(autoInfracao.getDebito()) || this.autoInfracaoRepository.existsDebito(autoInfracao.getId()))) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o d\u00e9bito para o auto de infra\u00e7\u00e3o %d/%d pois j\u00e1 existe um d\u00e9bito para este.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        this.validateBeforeDebito(autoInfracao);
        Long exercicio = (Long)this.resolveExercicioDebito(autoInfracao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel definir o exerc\u00edcio do d\u00e9bito do auto %d/%d. Verifique os dados do tipo de auto.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio())));
        TipoAutoInfracao tipoAutoInfracao = autoInfracao.getTipoAutoInfracao();
        LocalDate dataReferencia = Objects.isNull(autoInfracao.getNotificacao()) ? autoInfracao.getData() : autoInfracao.getDataEntregaNotificacao();
        BigDecimal percentualDesconto = tipoAutoInfracao.getPermiteDesconto() != false && tipoAutoInfracao.getDescontoAutomatico() != false ? tipoAutoInfracao.getPercentualDesconto() : BigDecimal.ZERO;
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(exercicio);
        debitoManualDTO.setDataLancamento(dataReferencia);
        debitoManualDTO.setTipoCadastro(autoInfracao.getCadastroGeral().getTipoCadastro());
        debitoManualDTO.setCadastroGeral(autoInfracao.getCadastroGeral().getCadastroGeral());
        debitoManualDTO.setDivida(tipoAutoInfracao.getDivida().getDivida());
        debitoManualDTO.setUsuario(SecurityUtils.getUserAise());
        debitoManualDTO.setPrograma("Auto de Infra\u00e7\u00e3o");
        debitoManualDTO.getObservacoes().add(DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pelo auto de infra\u00e7\u00e3o %d/%d.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio())));
        debitoManualDTO.setTributos(this.buildTributos(autoInfracao));
        debitoManualDTO.setValorDescontoAuto(percentualDesconto);
        debitoManualDTO.setValidaPermissaoDivida(Boolean.FALSE);
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setDataVencimento(autoInfracao.getDataVencimento());
        debitoManualDTO.setParcelas(Collections.singletonList(parcela));
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoManualDTO);
        return (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
    }

    private List<DebitoManualTributoDTO> buildTributos(AutoInfracao autoInfracao) {
        ArrayList tributos = new ArrayList();
        tributos.add(this.buildTributo(autoInfracao, "principal", autoInfracao.getTipoAutoInfracao().getTributo(), autoInfracao.getValorAuto().subtract(autoInfracao.getValorCreditoImposto())));
        tributos.add(this.buildTributo(autoInfracao, "juros", autoInfracao.getTipoAutoInfracao().getJuros(), autoInfracao.getValorJuros()));
        tributos.add(this.buildTributo(autoInfracao, "multa", autoInfracao.getTipoAutoInfracao().getMulta(), autoInfracao.getValorMulta()));
        tributos.add(this.buildTributo(autoInfracao, "corre\u00e7\u00e3o", autoInfracao.getTipoAutoInfracao().getCorrecao(), autoInfracao.getValorCorrecao().subtract(autoInfracao.getValorCreditoCorrecao())));
        List tributosPenalidades = autoInfracao.getPenalidades().stream().map(arg_0 -> this.buildTributoFromPenalidade(arg_0)).collect(Collectors.toList());
        tributos.addAll(tributosPenalidades);
        return tributos.stream().flatMap(Optional::stream).collect(Collectors.groupingBy(DebitoManualTributoDTO::getTributo, Collectors.reducing((accum, element) -> {
            accum.setValorTributo(accum.getValorTributo().add(element.getValorTributo()));
            return accum;
        }))).values().stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<DebitoManualTributoDTO> buildTributo(AutoInfracao autoInfracao, String tipo, Tributo tributo, BigDecimal valor) {
        if (valor.compareTo(BigDecimal.ZERO) == 0) {
            return Optional.empty();
        }
        if (Objects.isNull(tributo)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o d\u00e9bito para o auto %d/%d pois o tributo %s n\u00e3o foi cadastrado no tipo de auto de infra\u00e7\u00e3o %d - %s.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio(), tipo, autoInfracao.getTipoAutoInfracao().getId(), autoInfracao.getTipoAutoInfracao().getDescricao()));
        }
        DebitoManualTributoDTO dto = new DebitoManualTributoDTO();
        dto.setTributo(tributo.getTributo());
        dto.setValorTributo(valor);
        return Optional.of(dto);
    }

    private Optional<DebitoManualTributoDTO> buildTributoFromPenalidade(AutoInfracaoPenalidade penalidade) {
        if (penalidade.getValor().compareTo(BigDecimal.ZERO) == 0) {
            return Optional.empty();
        }
        if (Objects.isNull(penalidade.getPenalidade().getTributo())) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o d\u00e9bito para o auto %d/%d pois o tributo n\u00e3o foi cadastrado na penalidade %d/%d - %s", penalidade.getAutoInfracao().getAutoInfracaoFiscal(), penalidade.getPenalidade().getDivida().getExercicio(), penalidade.getPenalidade().getId().getPenalidade(), penalidade.getPenalidade().getId().getExercicio(), penalidade.getPenalidade().getDescricao()));
        }
        DebitoManualTributoDTO dto = new DebitoManualTributoDTO();
        dto.setTributo(penalidade.getPenalidade().getTributo().getTributo());
        dto.setValorTributo(penalidade.getValor());
        return Optional.of(dto);
    }

    private Optional<Long> resolveExercicioDebito(AutoInfracao autoInfracao) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$autoinfracao$OrigemExercicioDebito[autoInfracao.getTipoAutoInfracao().getOrigemExercicioDebito().ordinal()]) {
            case 1: {
                return Optional.of(autoInfracao.getExercicio());
            }
            case 2: {
                return Optional.ofNullable(autoInfracao.getDataEntregaNotificacao()).map(LocalDate::getYear).map(Long::valueOf);
            }
            case 3: {
                return Optional.ofNullable(autoInfracao.getNotificacao()).map(NotificacaoFiscalizacao::getExercicio);
            }
            case 4: {
                return Optional.ofNullable(autoInfracao.getExercicioProcesso());
            }
        }
        return Optional.empty();
    }

    private void validateBeforeDebito(AutoInfracao autoInfracao) {
        SituacaoMobiliario situacaoMobiliario;
        Boolean isSuspensoOuCancelado;
        if (TipoCadastro.MOBILIARIO.equals((Object)autoInfracao.getCadastroGeral().getTipoCadastro()) && (isSuspensoOuCancelado = Optional.ofNullable(situacaoMobiliario = ((CadastroMobiliario)autoInfracao.getCadastroGeral()).getSituacaoAtual()).map(SituacaoMobiliario::getTipoSituacaoMobiliario).map(tipoSituacao -> tipoSituacao.isSuspenso() != false || tipoSituacao.isInativo() != false).orElse(Boolean.FALSE)).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o d\u00e9bito para o auto de infra\u00e7\u00e3o %d/%d pois o cadastro mobili\u00e1rio est\u00e1 suspenso ou cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
    }

    public CancelamentoDebito cancelarDebitoAutoInfracao(AutoInfracao autoInfracao, MotivoDeducao motivoDeducao, String observacao) {
        Debito debito = autoInfracao.getDebitos().stream().map(AutoInfracaoDebito::getDebito).filter(d -> d.getParcelas().stream().anyMatch(p -> p.getSituacaoDebito().isAberto())).max(Comparator.comparing(Debito::getSubDivida)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel cancelar o d\u00e9bito do auto de infra\u00e7\u00e3o %d/%d pois as parcelas n\u00e3o est\u00e3o abertas.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio())));
        this.validateParcelamento(debito);
        CancelamentoParcelasFormDTO cancelamentoDebitosDTO = new CancelamentoParcelasFormDTO();
        cancelamentoDebitosDTO.setDataCancelamento(LocalDate.now());
        cancelamentoDebitosDTO.setEntidade(this.contextService.getEntidadePrincipal());
        cancelamentoDebitosDTO.setExercicio(this.contextService.getExercicioAtual());
        cancelamentoDebitosDTO.setUsuario(SecurityUtils.getUserAise());
        cancelamentoDebitosDTO.setMotivoCancelamento(motivoDeducao);
        cancelamentoDebitosDTO.setTipoDeducao(motivoDeducao.getTipoDeducao());
        cancelamentoDebitosDTO.setMotivo(String.format("Cancelamento do auto de infra\u00e7\u00e3o %d/%d", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        List parcelasCancelamento = debito.getParcelas().stream().map(parcela -> {
            CancelamentoDebitoParcelaDTO cancelamentoParcelaDTO = new CancelamentoDebitoParcelaDTO();
            cancelamentoParcelaDTO.setIdDebito(debito.getId());
            cancelamentoParcelaDTO.setEntidade(parcela.getId().getEntidade());
            cancelamentoParcelaDTO.setExercicio(parcela.getId().getExercicio());
            cancelamentoParcelaDTO.setTipoCadastro(parcela.getId().getTipoCadastro());
            cancelamentoParcelaDTO.setCadastroGeral(parcela.getId().getCadastroGeral());
            cancelamentoParcelaDTO.setDivida(parcela.getId().getDivida());
            cancelamentoParcelaDTO.setSubDivida(parcela.getId().getSubDivida());
            cancelamentoParcelaDTO.setParcela(parcela.getId().getParcela());
            cancelamentoParcelaDTO.setSituacaoLegal(parcela.getSituacaoLegal());
            return cancelamentoParcelaDTO;
        }).collect(Collectors.toList());
        cancelamentoDebitosDTO.getParcelas().addAll(parcelasCancelamento);
        this.addObservacao(debito, observacao);
        return this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamentoDebitosDTO);
    }

    public void validateParcelamento(Debito debito) {
        Long idParcelamento = debito.getIdParcelamento();
        if (Objects.nonNull(idParcelamento)) {
            this.parcelamentoService.findById((Serializable)idParcelamento).ifPresent(p -> {
                if (Boolean.FALSE.equals(p.getEstornado())) {
                    throw new EloValidationException(String.format("O cancelamento do d\u00e9bito do Auto de Infra\u00e7\u00e3o n\u00e3o pode ser realizado, pois h\u00e1 um contrato de parcelamento ativo associado. Consulte o contrato n\u00ba %d/%d para mais detalhes.", p.getNumeroContrato(), p.getAnoContrato()));
                }
            });
        }
    }

    public void addObservacao(Debito debito, String observacao) {
        if (Objects.nonNull(observacao)) {
            this.debitoObservacaoService.save(DebitoIdDTO.from((Debito)debito), observacao);
        }
    }

    @Generated
    public AutoInfracaoDebitoService(AutoInfracaoRepository autoInfracaoRepository, GeraDebitoService geraDebitoService, CancelamentoDebitoService cancelamentoDebitoService, DebitoService debitoService, ContextService contextService, ParcelamentoService parcelamentoService, DebitoObservacaoService debitoObservacaoService) {
        this.autoInfracaoRepository = autoInfracaoRepository;
        this.geraDebitoService = geraDebitoService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoService = debitoService;
        this.contextService = contextService;
        this.parcelamentoService = parcelamentoService;
        this.debitoObservacaoService = debitoObservacaoService;
    }
}

