/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ImportacaoDebitoWebIssNotifier
implements AgendamentoRotinaNotifier {
    private final MailService mailService;
    private final AgendamentoRotinaRepository repository;
    private final PessoaService pessoaService;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.IMPORTACAO_DEBITOS_WEBISS.equals((Object)agendamentoRotina.getRotina());
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public <R> void notify(AgendamentoRotina agendamentoRotina, R resource) {
        if (resource instanceof String) {
            this.notifyIntegracao(agendamentoRotina, (String)resource);
        }
    }

    public <R> void notify(Long idAgendamento, R resource) {
        this.repository.findById((Object)idAgendamento).ifPresent(agendamentoRotina -> this.notify(agendamentoRotina, resource));
    }

    private void notifyIntegracao(AgendamentoRotina agendamentoRotina, String mensagem) {
        String messageContent = mensagem;
        this.notifyEmail(agendamentoRotina, messageContent);
    }

    private void notifyEmail(AgendamentoRotina agendamentoRotina, String message) {
        String email;
        if (agendamentoRotina.shouldSendEmail() && Objects.nonNull(email = this.getEmail(agendamentoRotina))) {
            MailParams mailParams = this.buildMailParams(agendamentoRotina, message, email);
            this.notifyByEmail(mailParams);
        }
    }

    private MailParams buildMailParams(AgendamentoRotina agendamentoRotina, String content, String email) {
        return MailParams.builder().to(email).subject("Agendamento de rotina " + agendamentoRotina.getId() + " - Importa\u00e7\u00e3o dos d\u00e9bitos do WEBISS").multipart(false).content(content).html(false).build();
    }

    public String getEmail(AgendamentoRotina agendamentoRotina) {
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(agendamentoRotina.getUsuario());
        return Optional.ofNullable(pessoa).map(Pessoa::getContatoPrincipal).map(ContatoPessoa::getEmail).orElse(null);
    }

    @Generated
    public ImportacaoDebitoWebIssNotifier(MailService mailService, AgendamentoRotinaRepository repository, PessoaService pessoaService) {
        this.mailService = mailService;
        this.repository = repository;
        this.pessoaService = pessoaService;
    }
}

