/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations.AtualizacaoMonetariaNotifier;
import lombok.Generated;
import org.springframework.batch.core.JobExecution;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaNotifier
implements AgendamentoRotinaNotifier {
    private final MailService mailService;
    private final AgendamentoRotinaRepository repository;
    private final PessoaService pessoaService;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ATUALIZACAO_MONETARIA.equals((Object)agendamentoRotina.getRotina());
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public <R> void notify(AgendamentoRotina agendamentoRotina, R resource) {
        if (resource instanceof JobExecution) {
            this.notifyBatchStatus(agendamentoRotina, (JobExecution)resource);
        }
    }

    public <R> void notify(Long idAgendamento, R resource) {
        this.repository.findById((Object)idAgendamento).ifPresent(agendamentoRotina -> this.notify(agendamentoRotina, resource));
    }

    private void notifyBatchStatus(AgendamentoRotina agendamentoRotina, JobExecution jobExecution) {
        String messageContent = this.buildMessageContent(jobExecution);
        this.notifyEmail(agendamentoRotina, messageContent);
    }

    private void notifyEmail(AgendamentoRotina agendamentoRotina, String message) {
        if (agendamentoRotina.shouldSendEmail()) {
            MailParams mailParams = this.buildMailParams(agendamentoRotina, message);
            this.notifyByEmail(mailParams);
        }
    }

    private MailParams buildMailParams(AgendamentoRotina agendamentoRotina, String message) {
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(agendamentoRotina.getUsuario());
        return MailParams.builder().to(pessoa.getContatoPrincipal().getEmail()).subject("Agendamento de rotina " + agendamentoRotina.getId() + " - Atualiza\u00e7\u00e3o Monet\u00e1ria").multipart(false).content(message).html(false).build();
    }

    private String buildMessageContent(JobExecution jobExecution) {
        long id = jobExecution.getExecutionContext().getLong("idAtualizacaoMonetaria");
        String messageTemplate = "Rotina de atualiza\u00e7\u00e3o monet\u00e1ria foi executada";
        switch (1.$SwitchMap$org$springframework$batch$core$BatchStatus[jobExecution.getStatus().ordinal()]) {
            case 1: {
                return "Rotina de atualiza\u00e7\u00e3o monet\u00e1ria foi executada com sucesso. Atualiza\u00e7\u00e3o monet\u00e1ria: " + id;
            }
            case 2: {
                return "Rotina de atualiza\u00e7\u00e3o monet\u00e1ria foi executada com falha. Motivo: " + ((Throwable)jobExecution.getFailureExceptions().get(0)).getMessage();
            }
        }
        return "Rotina de atualiza\u00e7\u00e3o monet\u00e1ria foi executada com status: " + String.valueOf(jobExecution.getStatus());
    }

    @Generated
    public AtualizacaoMonetariaNotifier(MailService mailService, AgendamentoRotinaRepository repository, PessoaService pessoaService) {
        this.mailService = mailService;
        this.repository = repository;
        this.pessoaService = pessoaService;
    }
}

