/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.dto.AtualizaAlvaraVencidoMobiliarioResponseDTO;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AtualizaAlvaraVencidoMobiliarioNotifier
implements AgendamentoRotinaNotifier {
    private final MailService mailService;
    private final AgendamentoRotinaRepository agendamentoRotinaRepository;
    private final PessoaService pessoaService;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ATUALIZA_ALVARA_VENCIDO_MOBILIARIO.equals((Object)agendamentoRotina.getRotina());
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public <R> void notify(AgendamentoRotina agendamentoRotina, R resource) {
        if (resource instanceof AtualizaAlvaraVencidoMobiliarioResponseDTO) {
            this.notifyAlvarasVencidos(agendamentoRotina, (AtualizaAlvaraVencidoMobiliarioResponseDTO)resource);
        }
    }

    public <R> void notify(Long idAgendamento, R resource) {
        this.agendamentoRotinaRepository.findById((Object)idAgendamento).ifPresent(agendamentoRotina -> this.notify(agendamentoRotina, resource));
    }

    private void notifyAlvarasVencidos(AgendamentoRotina agendamentoRotina, AtualizaAlvaraVencidoMobiliarioResponseDTO cadastroMobiliarios) {
        String messageContent = this.buildMessageContent(cadastroMobiliarios);
        this.notifyEmail(agendamentoRotina, messageContent);
    }

    private void notifyEmail(AgendamentoRotina agendamentoRotina, String message) {
        if (agendamentoRotina.shouldSendEmail()) {
            MailParams mailParams = this.buildMailParams(agendamentoRotina, message);
            this.notifyByEmail(mailParams);
        }
    }

    private MailParams buildMailParams(AgendamentoRotina agendamentoRotina, String content) {
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(agendamentoRotina.getUsuario());
        return MailParams.builder().to(pessoa.getContatoPrincipal().getEmail()).subject("Agendamento de rotina " + agendamentoRotina.getId() + " - Atualiza\u00e7\u00e3o de Cadastros Vencidos no Cadastro Mobili\u00e1rio").multipart(false).content(content).html(false).build();
    }

    private String buildMessageContent(AtualizaAlvaraVencidoMobiliarioResponseDTO response) {
        String sucessoMensagem = String.format("Rotina de Atualiza\u00e7\u00e3o de Cadastros Mobili\u00e1rios de Alvar\u00e1s Vencidos foi executada, foram alterados %d cadastros. ", response.getQtdSucesso());
        if (response.getQtdErros() != 0) {
            String erroMensagem = String.format("Ocorreram erros em atualizar %d cadastros. Contate o Suporte para que sejam averiguados.", response.getQtdErros());
            return sucessoMensagem + erroMensagem;
        }
        return sucessoMensagem;
    }

    @Generated
    public AtualizaAlvaraVencidoMobiliarioNotifier(MailService mailService, AgendamentoRotinaRepository agendamentoRotinaRepository, PessoaService pessoaService) {
        this.mailService = mailService;
        this.agendamentoRotinaRepository = agendamentoRotinaRepository;
        this.pessoaService = pessoaService;
    }
}

