/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.enums.TipoLivroDividaAtiva;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.batch.LivroDividaAtivaJobStarter;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InscricaoDividaAtivaExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InscricaoDividaAtivaExecutor.class);
    private final LivroDividaAtivaJobStarter jobStarter;
    private final ContextService contextService;
    private final GeraLivroRepository geraLivroRepository;
    private List<AgendamentoRotinaNotifier> notifiers;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.INSCRICAO_DIVIDA_ATIVA.equals((Object)agendamentoRotina.getRotina());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void execute(AgendamentoRotina agendamentoRotina) {
        FiltroGeraLivroDTO filtros = (FiltroGeraLivroDTO)this.parseFilter(agendamentoRotina.getParametros());
        if (this.temDadosParaGerarLivro(filtros)) {
            this.jobStarter.startJob(filtros, TipoLivroDividaAtiva.EFETIVO, null, agendamentoRotina.getId());
        }
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        return this.notifiers;
    }

    protected Object parseFilter(Map<String, String> parametros) {
        FiltroGeraLivroDTO filtros = new FiltroGeraLivroDTO();
        parametros.forEach((key, value) -> this.setField((Object)filtros, key, value));
        filtros.setEntidade(this.contextService.getEntidadePrincipal());
        filtros.setExercicio(this.contextService.getExercicioAtual());
        filtros.setDataVencimentoFinal(LocalDate.now());
        filtros.setDataInscricao(LocalDate.now());
        return filtros;
    }

    private boolean temDadosParaGerarLivro(FiltroGeraLivroDTO filtros) {
        String filtroPraValidar = filtros.getFiltro(Boolean.valueOf(false));
        return this.geraLivroRepository.getDebitoParcelas(filtroPraValidar, (Pageable)PageRequest.of((int)0, (int)1), filtros.getEntidade()).hasContent();
    }

    @Generated
    public InscricaoDividaAtivaExecutor(LivroDividaAtivaJobStarter jobStarter, ContextService contextService, GeraLivroRepository geraLivroRepository, List<AgendamentoRotinaNotifier> notifiers) {
        this.jobStarter = jobStarter;
        this.contextService = contextService;
        this.geraLivroRepository = geraLivroRepository;
        this.notifiers = notifiers;
    }
}

