/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.webiss.ImportacaoArquivoWebIssService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportacaoDebitosBloqueadosWebIssExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoDebitosBloqueadosWebIssExecutor.class);
    private final List<AgendamentoRotinaNotifier> notifiers;
    private final ImportacaoArquivoWebIssService importacaoArquivoWebIssService;
    private static final Long QUANTIDADE_DIAS_CONSULTA = 2L;

    protected Object parseFilter(Map<String, String> parametros) {
        return null;
    }

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.IMPORTACAO_DEBITOS_BLOQUEADOS_WEBISS.equals((Object)agendamentoRotina.getRotina());
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        return this.notifiers;
    }

    @Transactional
    public void execute(AgendamentoRotina agendamentoRotina) {
        String mensagemEmail;
        try {
            LocalDate dataConsulta = LocalDate.now().minusDays(QUANTIDADE_DIAS_CONSULTA);
            this.importacaoArquivoWebIssService.downloadArquivoDebitosBloqueadosWebIss(dataConsulta);
            mensagemEmail = "Download do arquivo de d\u00e9bitos bloqueados do webiss realizado com sucesso";
        }
        catch (Exception e) {
            mensagemEmail = String.format("Erro ao fazer o download do arquivo de d\u00e9bitos bloqueados do WEBISS. Erro: %s ", e.getMessage());
            log.error(mensagemEmail, (Throwable)e);
        }
        this.enviarEmail(agendamentoRotina, mensagemEmail);
    }

    public void enviarEmail(AgendamentoRotina agendamentoRotina, String mensagem) {
        this.getNotifier(agendamentoRotina).notify(agendamentoRotina, (Object)mensagem);
    }

    @Generated
    public ImportacaoDebitosBloqueadosWebIssExecutor(List<AgendamentoRotinaNotifier> notifiers, ImportacaoArquivoWebIssService importacaoArquivoWebIssService) {
        this.notifiers = notifiers;
        this.importacaoArquivoWebIssService = importacaoArquivoWebIssService;
    }
}

