/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.batch.exportacaoconsultacsv.ExportacaoConsultaCsvStarter;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;

@Service
public class ExportacaoConsultaCsvExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportacaoConsultaCsvExecutor.class);
    private final ExportacaoConsultaCsvStarter exportacaoConsultaCsvStarter;
    private final List<AgendamentoRotinaNotifier> notifiers;

    protected Object parseFilter(Map<String, String> parametros) {
        if (Objects.isNull(parametros) || parametros.isEmpty()) {
            throw new EloValidationException("Par\u00e2metros inv\u00e1lidos para exporta\u00e7\u00e3o");
        }
        return parametros.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("view")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.EXPORTACAO_SQL_CSV.equals((Object)agendamentoRotina.getRotina());
    }

    public void execute(AgendamentoRotina agendamentoRotina) {
        List views = (List)this.parseFilter(agendamentoRotina.getParametros());
        log.debug(String.format("Iniciando a exporta\u00e7\u00e3o das views: %s", String.join((CharSequence)", ", views)));
        String delimitador = agendamentoRotina.getParametros().getOrDefault("delimitador", ";");
        String regexNomeArquivo = (String)agendamentoRotina.getParametros().get("regexNomeArquivo");
        try {
            this.exportacaoConsultaCsvStarter.startJob(views, delimitador, agendamentoRotina.getId(), agendamentoRotina.getDescricao(), regexNomeArquivo);
        }
        catch (JobParametersInvalidException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
            log.error(String.format("Erro ao exportar as views %s", String.join((CharSequence)", ", views)), e);
            throw new RuntimeException(e);
        }
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        return this.notifiers;
    }

    @Generated
    public ExportacaoConsultaCsvExecutor(ExportacaoConsultaCsvStarter exportacaoConsultaCsvStarter, List<AgendamentoRotinaNotifier> notifiers) {
        this.exportacaoConsultaCsvStarter = exportacaoConsultaCsvStarter;
        this.notifiers = notifiers;
    }
}

