/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.AtualizaAlvaraVencidoMobiliarioResponseDTO;
import br.com.elotech.tributos.dto.FiltroAlvaraVencidoDTO;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtualizaAlvaraVencidoMobiliarioExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizaAlvaraVencidoMobiliarioExecutor.class);
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final List<AgendamentoRotinaNotifier> notifiers;
    private final TarefaAssincronaService tarefaAssincronaService;

    protected Object parseFilter(Map<String, String> param) {
        FiltroAlvaraVencidoDTO filtros = new FiltroAlvaraVencidoDTO();
        param.forEach((key, value) -> this.setField((Object)filtros, key, value));
        return filtros;
    }

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ATUALIZA_ALVARA_VENCIDO_MOBILIARIO.equals((Object)agendamentoRotina.getRotina());
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        return this.notifiers;
    }

    private Boolean verificarTarefaEmExecucao(Long idAgendamento) {
        return this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.ATUALIZACAO_MOBILIARIO_ALVARA_VENCIDO, "CHAVE_ATUALIZACAO_ALVARA_VENCIDO_MOBILIARIO", idAgendamento.toString());
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void execute(AgendamentoRotina agendamentoRotina) {
        if (Boolean.TRUE.equals(this.verificarTarefaEmExecucao(agendamentoRotina.getId()))) {
            log.info("Atualiza\u00e7\u00e3o de Alvar\u00e1s Vencidos em Cadastros Mobili\u00e1rios ainda est\u00e1 em execu\u00e7\u00e3o.");
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaAssincronaAtualizacaoMobiliarioAlvaraVencido(agendamentoRotina.getId());
        FiltroAlvaraVencidoDTO filtroAlvaraVencidoDTO = (FiltroAlvaraVencidoDTO)this.parseFilter(agendamentoRotina.getParametros());
        if (filtroAlvaraVencidoDTO.getStatusMobiliario() == null) {
            String mensagemErro = "N\u00e3o foi possivel atualizar o cadastro mobiliario, n\u00e3o foi encontrado o status do alvar\u00e1 vencido no Filtro.";
            log.error(mensagemErro);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
            return;
        }
        this.atualizaAlvaraVencido(filtroAlvaraVencidoDTO, tarefa, agendamentoRotina);
    }

    private void atualizaAlvaraVencido(FiltroAlvaraVencidoDTO filtroAlvaraVencidoDTO, TarefaAssincronaExecucao tarefa, AgendamentoRotina agendamentoRotina) {
        log.debug("Iniciando verifica\u00e7\u00e3o de Alvar\u00e1s Vencidos do Cadastro Mobili\u00e1rio");
        try {
            AtualizaAlvaraVencidoMobiliarioResponseDTO cadastrosAtualizados = this.cadastroMobiliarioService.atualizaAlvaraVencido(filtroAlvaraVencidoDTO, tarefa);
            this.enviarEmail(cadastrosAtualizados, agendamentoRotina);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, e.getMessage());
        }
    }

    private void enviarEmail(AtualizaAlvaraVencidoMobiliarioResponseDTO cadastrosAtualizados, AgendamentoRotina agendamentoRotina) {
        if (cadastrosAtualizados.getQtdSucesso() != null && cadastrosAtualizados.getQtdErros() != null) {
            try {
                this.getNotifier(agendamentoRotina).notify(agendamentoRotina, (Object)cadastrosAtualizados);
            }
            catch (Exception e) {
                String mensagemErro = "Cadastros foram atualizados, contudo erro ao enviar e-mail ao usu\u00e1rio " + e.getMessage();
                log.error(mensagemErro, (Throwable)e);
                throw new EloValidationException(mensagemErro);
            }
        }
    }

    @Generated
    public AtualizaAlvaraVencidoMobiliarioExecutor(CadastroMobiliarioService cadastroMobiliarioService, List<AgendamentoRotinaNotifier> notifiers, TarefaAssincronaService tarefaAssincronaService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.notifiers = notifiers;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }
}

