/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina;

import br.com.elotech.agendamento.client.AgendamentoFeignClient;
import br.com.elotech.agendamento.client.dto.AgendamentoDTO;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotinaExportacao;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.AgendamentoRotinaExportacaoDTO;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaExportacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutor;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class AgendamentoRotinaService
extends CrudService<AgendamentoRotina, Long> {
    private final String AGENDAMENTO_ID_MASK = "agendamentorotina-%s";
    private final Optional<AgendamentoFeignClient> agendamentoFeignClient;
    private final ConfigurableEnvironment configurableEnvironment;
    private final List<AgendamentoRotinaExecutor> execucaoServices;
    private final AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public void executarRotina(Long idAgendamento) {
        AgendamentoRotina agendamento = (AgendamentoRotina)this.findById((Serializable)idAgendamento).orElseThrow(() -> new RestException(HttpStatus.NO_CONTENT, "N\u00e3o encontrado agendamento com id " + idAgendamento));
        if (agendamento.isAtivo()) {
            Hibernate.initialize((Object)agendamento.getParametros());
            this.getExecutor(agendamento).execute(agendamento);
        }
    }

    public void beforeSave(AgendamentoRotina agendamentoRotina, Authentication authentication) {
        agendamentoRotina.getParametros().putIfAbsent("usuario", SecurityUtils.getUserAise());
    }

    public void afterSave(AgendamentoRotina agendamentoRotina, Authentication authentication) {
        if (agendamentoRotina.isAtivo()) {
            this.ativarAgendamento(agendamentoRotina);
        } else {
            this.desativarAgendamento(agendamentoRotina);
        }
        super.afterSave((EloEntity)agendamentoRotina, authentication);
    }

    public void afterDelete(AgendamentoRotina agendamentoRotina, Authentication authentication) {
        this.desativarAgendamento(agendamentoRotina);
        super.afterDelete((EloEntity)agendamentoRotina, authentication);
    }

    private void ativarAgendamento(AgendamentoRotina agendamentoRotina) {
        String id = String.format("agendamentorotina-%s", agendamentoRotina.getId());
        String url = String.format("%s/api/agendamento-rotina/%s/executar", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.configurableEnvironment), agendamentoRotina.getId());
        AgendamentoDTO agendamentoDTO = new AgendamentoDTO();
        agendamentoDTO.setTenant(TenantContextHolder.getCurrentTenantId());
        agendamentoDTO.setCron(agendamentoRotina.getCron());
        agendamentoDTO.setHttpMethod(HttpMethod.PUT);
        agendamentoDTO.setId(id);
        agendamentoDTO.setUrl(url);
        this.agendamentoFeignClient.ifPresent(client -> client.create(agendamentoDTO));
    }

    private void desativarAgendamento(AgendamentoRotina agendamentoRotina) {
        String tenantId = TenantContextHolder.getCurrentTenantId();
        String id = String.format("agendamentorotina-%s", agendamentoRotina.getId());
        this.agendamentoFeignClient.ifPresent(client -> client.deleteById(tenantId, id));
    }

    private AgendamentoRotinaExecutor getExecutor(AgendamentoRotina agendamentoRotina) {
        return this.execucaoServices.stream().filter(e -> e.accept(agendamentoRotina)).findFirst().orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o implementado execu\u00e7\u00e3o para a rotina %s", agendamentoRotina.getRotina().toString())));
    }

    public List<AgendamentoRotinaExportacaoDTO> findByUltimaExportacao(AgendamentoRotina agendamentoRotina) {
        BatchJobExecution lastJobAgendamentoExportacao = this.agendamentoRotinaExportacaoRepository.getLastJobAgendamentoExportacao(agendamentoRotina);
        List exportacoes = this.agendamentoRotinaExportacaoRepository.findByAgendamentoRotinaAndBatchJobExportacao(agendamentoRotina, lastJobAgendamentoExportacao);
        return exportacoes.stream().map(exp -> {
            ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(exp.getFullPath(), exp.getNomeArquivo());
            return AgendamentoRotinaExportacaoDTO.from((AgendamentoRotinaExportacao)exp, (String)arquivoUrl.getUrlAssinada());
        }).toList();
    }

    @Generated
    public AgendamentoRotinaService(Optional<AgendamentoFeignClient> agendamentoFeignClient, ConfigurableEnvironment configurableEnvironment, List<AgendamentoRotinaExecutor> execucaoServices, AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.agendamentoFeignClient = agendamentoFeignClient;
        this.configurableEnvironment = configurableEnvironment;
        this.execucaoServices = execucaoServices;
        this.agendamentoRotinaExportacaoRepository = agendamentoRotinaExportacaoRepository;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }
}

